/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.panels;

import java.awt.Component;
import java.awt.Container;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.controls.SpringUtilities;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class ColumnPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private String _sql;
    private String _conn;
    private List<?> _bindList = null;
    private ArrayList<String> _selectedCols = null;
    private Map<String, ?> _bindMap = null;
    private boolean _al = false;
    private TreeCellCheckedListener _listener = null;
    private JTable _table;
    private ExtractObject _extractObject;
    private ExtractListModel _listModel;

    public ColumnPanel(ExtractObject extractObject, String string) {
        this._extractObject = extractObject;
        this._listModel = this._extractObject.getListModel();
        this.setSelectedColumns(string);
        if (this._listModel.isTypeDBO()) {
            DBObject dBObject = new DBObject(extractObject.getUrl());
            this._table = null;
            this._bindMap = dBObject.getDictionary();
            this.showPanel(dBObject.getConnectionName(), extractObject.getSql(), this._listModel.isAllowLobs());
        } else {
            this._table = (JTable)extractObject.getTable();
            this._bindList = extractObject.getBindList();
            this._bindMap = extractObject.getBindMap();
            this.showPanel(this._listModel.getSourceConnName(), extractObject.getSql(), this._listModel.isAllowLobs());
        }
    }

    public ColumnPanel(String string, String string2, boolean bl, JTable jTable) {
        this._table = jTable;
        this.showPanel(string, string2, bl);
    }

    public ColumnPanel(String string, String string2, List<?> list, boolean bl, JTable jTable) {
        this._table = jTable;
        this._bindList = list;
        this.showPanel(string, string2, bl);
    }

    public ColumnPanel(String string, String string2, Map<String, ?> map, boolean bl, JTable jTable) {
        this._table = jTable;
        this._bindMap = map;
        this.showPanel(string, string2, bl);
    }

    public void showPanel(String string, String string2, boolean bl) {
        this._sql = string2;
        this._al = bl;
        this._conn = string;
        this.draw();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablecolumnselect_html");
    }

    public void draw() {
        this.setLayout(new SpringLayout());
        this._root = this.createCheck(Messages.getString((String)"ColumnPanel.1"), true, true, false);
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.setSize(200, 200);
        this.addColumnsToTree();
        this.add(new JLabel(Messages.getString((String)"ColumnPanel.2")));
        this.add(new JScrollPane((Component)this._tree));
        SpringUtilities.makeCompactGrid((Container)this, (int)2, (int)1, (int)0, (int)0, (int)2, (int)2);
    }

    public void redrawTree(String string, boolean bl) {
        if (string != null && !this._sql.equals(string) && this._al != bl) {
            String string2;
            int n;
            this.setSql(string);
            this._al = bl;
            TriStateBoolean triStateBoolean = this.getRootState();
            TriStateBoolean triStateBoolean2 = null;
            HashMap<String, TriStateBoolean> hashMap = new HashMap<String, TriStateBoolean>();
            for (n = 0; n < this._root.getChildCount(); ++n) {
                string2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getText();
                triStateBoolean2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getCheckBoxState();
                hashMap.put(string2, triStateBoolean2);
            }
            this.removeAll();
            this.draw();
            this._tree.validate();
            this._tree.repaint();
            ((JTreeCellData)this._root.getUserObject()).setCheckBoxState(triStateBoolean);
            for (n = 0; n < this._root.getChildCount(); ++n) {
                string2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getText();
                triStateBoolean2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getCheckBoxState();
                if (hashMap.get(string2) == null || !((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).isEnabled()) continue;
                ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).setCheckBoxState((TriStateBoolean)hashMap.get(string2));
            }
            if (this._listener != null) {
                this._listener.cellChecked(null);
                this.addTreeCellCheckedListener(this._listener);
            }
            this._tree.validate();
            this._tree.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnsToTree() {
        if (this._extractObject.isEmptySelect()) {
            return;
        }
        boolean bl = true;
        ResultSet resultSet = null;
        TableColumnModel tableColumnModel = null;
        IResultSetTableModel iResultSetTableModel = null;
        ResultSetMetaData resultSetMetaData = null;
        boolean bl2 = false;
        try {
            if (this._table != null && this._table.getModel() instanceof IResultSetTableModel) {
                iResultSetTableModel = (IResultSetTableModel)((Object)this._table.getModel());
                tableColumnModel = this._table.getColumnModel();
                bl2 = iResultSetTableModel.isVerticalDisplay();
                if (bl2) {
                    resultSetMetaData = iResultSetTableModel.getResultSetMetaData();
                }
            }
            if (resultSetMetaData == null && tableColumnModel == null && Connections.getInstance().lock(this._conn)) {
                DBUtil dBUtil = DBUtil.getInstance((String)this._conn);
                resultSet = this._bindList != null && !this._bindList.isEmpty() ? dBUtil.executeQuery(this._sql, this._bindList) : dBUtil.executeQuery(this._sql, this._bindMap);
                if (resultSet != null) {
                    resultSetMetaData = resultSet.getMetaData();
                } else {
                    Connections.getInstance().unlock(this._conn);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"ColumnPanel.3"), (String)Messages.getString((String)"ColumnPanel.4"), null);
                    bl = false;
                }
            }
            if (bl) {
                int n = 0;
                n = this._table == null ? resultSetMetaData.getColumnCount() : (!bl2 ? tableColumnModel.getColumnCount() : resultSetMetaData.getColumnCount());
                int n2 = 0;
                String string = null;
                int n3 = -911;
                boolean bl3 = true;
                for (int i = 0; i < n; ++i) {
                    if (tableColumnModel != null && !bl2) {
                        n3 = tableColumnModel.getColumn(i).getModelIndex();
                        n2 = iResultSetTableModel.getColumnSqlType(n3);
                        string = iResultSetTableModel.getColumnName(n3);
                    } else {
                        n2 = resultSetMetaData.getColumnType(i + 1);
                        string = resultSetMetaData.getColumnName(i + 1);
                    }
                    bl3 = n2 == 2004 || n2 == 2005 || n2 == 2011 || "ORA_ROWSCN".equals(string) || "ROWID".equals(string) ? this._al : true;
                    if ("ORA_ROWSCN".equals(string) || "ROWID".equals(string) || "SDEV_LINK_OWNER".equals(string) || "SDEV_LINK_NAME".equals(string) || "SDEV_LINK_TYPE".equals(string) || "SDEV_LINK_LINE".equals(string)) continue;
                    boolean bl4 = this._selectedCols.contains(Messages.getString((String)"ColumnPanel.1")) ? true : this._selectedCols.contains(string);
                    this._root.add((MutableTreeNode)this.createCheck(string, bl4, bl3));
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        finally {
            if (resultSet != null) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this._conn);
            }
        }
    }

    public TriStateBoolean getRootState() {
        return ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
    }

    @Override
    public String toString() {
        return this.getSelectedColumns();
    }

    public String getSelectedColumns() {
        String string = null;
        boolean bl = true;
        TriStateBoolean triStateBoolean = ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
        DBUtil dBUtil = DBUtil.getInstance((String)this._conn);
        for (int i = 0; i < this._root.getChildCount(); ++i) {
            String string2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getText();
            triStateBoolean = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getCheckBoxState();
            if (string == null && triStateBoolean == TriStateBoolean.TRUE) {
                string = dBUtil.addDbQuotes(string2);
                continue;
            }
            if (triStateBoolean == TriStateBoolean.TRUE) {
                string = string + "," + dBUtil.addDbQuotes(string2);
                continue;
            }
            bl = false;
        }
        if (bl) {
            string = "*";
        }
        return string == null ? "" : string;
    }

    public boolean allColumnsSelected() {
        return !((JTreeCellData)this._root.getUserObject()).getCheckBoxState().isTriState();
    }

    private JMutableTreeNode createCheck(String string, boolean bl, boolean bl2) {
        return this.createCheck(string, bl, bl2, true);
    }

    private JMutableTreeNode createCheck(String string, boolean bl, boolean bl2, boolean bl3) {
        JTreeCellData jTreeCellData = new JTreeCellData(string);
        jTreeCellData.setCheckBoxEnabled(bl2);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setHasCheckBox(bl2);
        if (bl3 && this._extractObject.isColumnVirtual(string)) {
            jTreeCellData.setIcon(OracleIcons.getIcon((String)"expression.png"));
        } else if (bl3) {
            jTreeCellData.setIcon(RaptorImagesArb.getIcon("COLUMN"));
        }
        if (bl2) {
            jTreeCellData.setCheckBoxState(bl ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
        }
        return new JMutableTreeNode(jTreeCellData);
    }

    private void setSelectedColumns(String string) {
        this._selectedCols = new ArrayList();
        if (string.equals("*")) {
            this._selectedCols.add(Messages.getString((String)"ColumnPanel.1"));
        } else {
            int n = 0;
            int n2 = 0;
            while ((n2 = string.indexOf(",", n)) != -1) {
                this._selectedCols.add(this.unquote(string.substring(n, n2)));
                n = n2 + 1;
            }
            this._selectedCols.add(this.unquote(string.substring(n)));
        }
    }

    private String unquote(String string) {
        String string2 = string;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string2 = string.substring(1, string.length() - 1);
        }
        return string2;
    }

    public void setTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._listener = treeCellCheckedListener;
    }

    public void addTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._tree.addTreeCellCheckedListener(treeCellCheckedListener);
    }

    public int getColCount() {
        return this._root.getChildCount();
    }

    public String getSql() {
        return this._sql;
    }

    public void setSql(String string) {
        this._sql = string;
    }
}

