/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.readers.CSVReader;
import oracle.dbtools.importer.readers.DataReader;
import oracle.dbtools.importer.readers.DelimitedReader;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;

public class DisplayDataGizmo
extends DisplayAdapter {
    private JPanel _gizmo;
    private String _tmpFilePath;
    private String _preview;
    private String _formatOptions;
    private String _encoding = "UTF8";
    private boolean _isRefreshing = false;

    public void init() {
        if (this._gizmo == null) {
            this._gizmo = this.getGizmoPanel();
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._gizmo;
    }

    @Override
    public void close() {
        JPanel jPanel = this._gizmo;
        this._gizmo = null;
        if (jPanel != null && jPanel.getParent() != null) {
            jPanel.getParent().remove(jPanel);
        }
        super.close();
    }

    public void loadData() {
        Query query = this.getQuery();
    }

    public JPanel getGizmoPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 16));
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return jPanel;
    }

    public JPanel BuildUI() {
        this._gizmo.removeAll();
        if (this._preview != null) {
            DelimitedReader delimitedReader = new DelimitedReader();
            try {
                String[] stringArray;
                ImportDataFormat importDataFormat;
                JsonObject jsonObject = this.getJsonObject(this._formatOptions);
                if (jsonObject == null) {
                    importDataFormat = new ImportDataFormat(ImportDataFormat.IMPORT_WIZARD, CSVReader.FORMAT);
                } else {
                    importDataFormat = new ImportDataFormat(ImportDataFormat.IMPORT_WIZARD, jsonObject.getString("dataFileFormat"));
                    importDataFormat.setDelimiter(jsonObject.getString("fmtDelimiter"));
                    importDataFormat.setEnclosureLeft(jsonObject.getString("fmtEnclosureLeft"));
                    importDataFormat.setEnclosureRight(jsonObject.getString("fmtEnclosureRight"));
                    importDataFormat.setRecordTerminator(jsonObject.getString("fmtTerminator"));
                    importDataFormat.setEncoding(jsonObject.getString("fmtEncoding"));
                    importDataFormat.isHeader(false);
                    stringArray = jsonObject.getString("fmtFields").split(",");
                    delimitedReader.setDefaultColumnNames(stringArray);
                }
                delimitedReader.setDataFormat(importDataFormat);
                stringArray = this.getPreviewFile();
                delimitedReader.setFileName((String)stringArray);
                DataPreviewGizmo dataPreviewGizmo = new DataPreviewGizmo((IDataReadable)delimitedReader);
                dataPreviewGizmo.setDataFormat(importDataFormat);
                dataPreviewGizmo.initUI();
                this._gizmo.add((Component)dataPreviewGizmo, "Center");
                dataPreviewGizmo.populateDataTable((IDataReadable)delimitedReader);
                dataPreviewGizmo.resetData(true);
                delimitedReader.openFile((String)stringArray);
                this._gizmo.add((Component)this.getUIOneCol((DataReader)delimitedReader), "North");
                if (this._gizmo.getParent() != null) {
                    this._gizmo.getParent().validate();
                    this._gizmo.getParent().repaint();
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        return this._gizmo;
    }

    private JPanel getUIOneCol(DataReader dataReader) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("GIZMO_TITLE_RECORDS")));
        JScrollPane jScrollPane = new JScrollPane(22, 32);
        jPanel.add((Component)jScrollPane, "Center");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        while (dataReader.hasMoreRows()) {
            try {
                defaultListModel.addElement(dataReader.readCurrentLine());
            }
            catch (Exception exception) {}
        }
        JList<String> jList = new JList<String>(defaultListModel){
            private static final long serialVersionUID = 1L;
        };
        jScrollPane.setViewportView(jList);
        return jPanel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject getJsonObject(String string) {
        try (StringReader stringReader = new StringReader(string);){
            JsonReader jsonReader = Json.createReader((Reader)stringReader);
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
        catch (Exception exception) {
            Logger.warn(DisplayDataGizmo.class, (Throwable)exception);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private String getPreviewFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void refresh(boolean bl) {
        if (!this._isRefreshing) {
            DataDisplayTask dataDisplayTask = new DataDisplayTask(ExtractResources.getString((String)"BAD_FILE_PREVIEW"));
            RaptorTaskManager.getInstance().addTask((RaptorTask)dataDisplayTask);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isUseEditorScrollPane() {
        return false;
    }

    @Override
    public boolean isUseScrollableUI() {
        return false;
    }

    @Override
    public void addActions(List<ObjectAction> list) {
    }

    private class DataDisplayTask
    extends RaptorTask<Void> {
        public DataDisplayTask(String string) {
            super(string, true, IRaptorTaskRunMode.TASKVIEWER);
            this.getDescriptor().addListener((IRaptorTaskListener)new WaitOver());
        }

        protected Void doWork() throws TaskException {
            ResultSet resultSet = null;
            String string = DisplayDataGizmo.this.getQuery().getSql();
            this.setMessage(string);
            Connection connection = DisplayDataGizmo.this.getConnection();
            if (Connections.getInstance().lock(connection)) {
                block5: {
                    try {
                        resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, DisplayDataGizmo.this.getBindMap());
                        if (resultSet == null || !resultSet.next()) break block5;
                        DisplayDataGizmo.this._preview = resultSet.getString(1);
                        DisplayDataGizmo.this._formatOptions = resultSet.getString(2);
                    }
                    catch (Exception exception) {
                        try {
                            throw new TaskException((Throwable)exception);
                        }
                        catch (Throwable throwable) {
                            DBUtil.closeResultSet(resultSet);
                            Connections.getInstance().unlock(connection);
                            throw throwable;
                        }
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(connection);
            }
            return null;
        }

        protected void invokeLater() {
            DisplayDataGizmo.this.BuildUI();
        }

        private class WaitOver
        extends RaptorTaskAdapter {
            private WaitOver() {
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        DataDisplayTask.this.invokeLater();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

