/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format.ui;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.export.Messages;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.javatools.db.DBException;

public class TableFormatterWrapper
extends ResultsFormatterWrapper {
    protected TableModel m_model;
    protected TableColumnModel m_cols;

    protected static IResultSetTableModel getBaseModel(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            tableModel = ((TableSorter)tableModel).getTableModel();
        }
        return tableModel instanceof IResultSetTableModel ? (IResultSetTableModel)((Object)tableModel) : null;
    }

    public TableFormatterWrapper(JTable jTable) {
        this.m_model = jTable.getModel();
        this.m_cols = jTable.getColumnModel();
        IResultSetTableModel iResultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        int n = 0;
        int n2 = -911;
        int n3 = 25;
        if (this.m_cols != null) {
            n = this.m_cols.getColumnCount();
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int[] nArray = new int[n];
        int n4 = -911;
        String string = null;
        for (int i = 0; i < n; ++i) {
            n4 = this.m_cols.getColumn(i).getModelIndex();
            if (iResultSetTableModel != null) {
                string = iResultSetTableModel.getColumnName(n4);
                n2 = iResultSetTableModel.getColumnSqlType(n4);
                try {
                    n3 = iResultSetTableModel.getResultSetMetaData().getColumnDisplaySize(n4 + 1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                nArray[i] = n2 == 91 || n2 == 92 || n2 == 93 ? 25 : Math.max(n3, string.length());
            } else {
                string = this.m_model.getColumnName(n4);
                nArray[i] = string.length();
            }
            arrayList.add(string);
        }
        this.setColumnNames(arrayList);
        this.setColumnSizes(nArray);
    }

    public TableModel getModel() {
        return this.m_model;
    }

    public void interrupt() {
    }

    public Connection getConnection() {
        if (this.m_model instanceof IResultSetTableModel) {
            String string = ((IResultSetTableModel)((Object)this.m_model)).getConnectionName();
            try {
                return Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                return null;
            }
        }
        return null;
    }

    public int getDataType(int n) {
        TableColumn tableColumn = this.m_cols.getColumn(n);
        int n2 = tableColumn.getModelIndex();
        IResultSetTableModel iResultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        if (iResultSetTableModel != null) {
            return iResultSetTableModel.getColumnSqlType(n2);
        }
        return 0;
    }

    public int print() throws IOException {
        int n = -911;
        try {
            TableFormatterWrapper.fetchAllRows(this.m_model);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        IResultSetTableModel iResultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        int n2 = this.m_model.getRowCount();
        this.m_formatter.start();
        for (int i = 0; i < n2 && !this.isInterrupted(); ++i) {
            this.m_formatter.log(Messages.getString("TableFormatterWrapper.0") + i);
            ++this.m_rowNum;
            this.m_formatter.startRow();
            for (int j = 0; j < this.m_cols.getColumnCount(); ++j) {
                n = this.m_cols.getColumn(j).getModelIndex();
                this.m_formatter.printColumn(this.m_model.getValueAt(i, n), j, n);
            }
            this.m_formatter.endRow();
        }
        this.m_formatter.end();
        return this.m_model.getRowCount();
    }

    private static void fetchAllRows(TableModel tableModel) throws ExecutionException {
        IResultSetTableModel iResultSetTableModel = TableFormatterWrapper.getBaseModel(tableModel);
        if (iResultSetTableModel != null) {
            iResultSetTableModel.fetchAllRows(false);
        }
    }

    public String getSQL() {
        IResultSetTableModel iResultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        return iResultSetTableModel != null ? iResultSetTableModel.getModifiedSql() : null;
    }

    public int print(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws IOException, ExecutionException {
        iRaptorTaskProgressUpdater.checkCanProceed();
        IResultSetTableModel iResultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        TableFormatterWrapper.fetchAllRows(this.m_model);
        int n = this.m_model.getRowCount();
        this.m_formatter.start();
        for (int i = 0; i < n; ++i) {
            iRaptorTaskProgressUpdater.checkCanProceed();
            this.m_formatter.log(Messages.getString("TableFormatterWrapper.1") + i);
            ++this.m_rowNum;
            this.m_formatter.startRow();
            int n2 = this.m_cols.getColumnCount();
            for (int j = 0; j < n2; ++j) {
                if (iResultSetTableModel != null && iResultSetTableModel.isNewGrid()) {
                    this.m_formatter.printColumn(this.m_model.getValueAt(i, this.m_cols.getColumn(j).getModelIndex()), j, this.m_cols.getColumn(j).getModelIndex());
                    continue;
                }
                this.m_formatter.printColumn(this.m_model.getValueAt(i, this.m_cols.getColumn(j).getModelIndex()), j, this.m_cols.getColumn(j).getModelIndex());
            }
            this.m_formatter.endRow();
        }
        this.m_formatter.end();
        return this.m_model.getRowCount();
    }
}

