/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.UIUpdater;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;

public class DBTreeUpdater
extends UIUpdater {
    private String m_protocol;
    private NavigatorTree m_tree;

    public DBTreeUpdater(String string, NavigatorWindow navigatorWindow) {
        this.m_protocol = string;
        this.m_tree = navigatorWindow.getTree();
    }

    @Override
    public void objectRemoved(String string, DBObject dBObject) {
        NavigatorTreeNode navigatorTreeNode = this.findTreeNode(string, dBObject);
        if (navigatorTreeNode != null) {
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
            final List<TreePath> list = this.updateSelectionStateForDelete(navigatorTreeNode);
            this.m_tree.removeChildFromNode(navigatorTreeNode2, navigatorTreeNode);
            if (list.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorContext.restoreSelectionState(DBTreeUpdater.this.m_tree, list);
                    }
                });
            }
        }
    }

    private List<TreePath> updateSelectionStateForDelete(NavigatorTreeNode navigatorTreeNode) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        TreePath treePath = new TreePath(navigatorTreeNode.getPath());
        for (TreePath treePath2 : NavigatorContext.storeSelectionState(this.m_tree)) {
            if (treePath2.isDescendant(treePath)) {
                DefaultMutableTreeNode defaultMutableTreeNode = navigatorTreeNode.getPreviousSibling();
                if (defaultMutableTreeNode == null && (defaultMutableTreeNode = navigatorTreeNode.getNextSibling()) == null) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)navigatorTreeNode.getParent();
                }
                if (defaultMutableTreeNode == null) continue;
                arrayList.add(new TreePath(defaultMutableTreeNode.getPath()));
                continue;
            }
            arrayList.add(treePath2);
        }
        return arrayList;
    }

    @Override
    public void refreshObject(String string, DBObject dBObject) {
        NavigatorTreeNode navigatorTreeNode = this.findTreeNode(string, dBObject);
        if (navigatorTreeNode != null) {
            this.m_tree.refresh(navigatorTreeNode);
        }
    }

    @Override
    public void refreshParent(String string, DBObject dBObject) {
        URL uRL;
        NavigatorTreeNode navigatorTreeNode = null;
        NavigatorTreeNode navigatorTreeNode2 = this.findTreeNode(string, dBObject);
        if (navigatorTreeNode2 != null) {
            navigatorTreeNode = (NavigatorTreeNode)navigatorTreeNode2.getParent();
        }
        if (navigatorTreeNode == null && (uRL = dBObject.getURL()) != null) {
            URL uRL2 = DBURLFormatHelper.getURL(uRL.getProtocol(), DBURLFormatHelper.getConnectionName(uRL), DBURLFormatHelper.getCatalog(uRL), DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL));
            DBObject dBObject2 = new DBObject(uRL2);
            navigatorTreeNode = this.findTreeNode(string, dBObject2);
        }
        if (navigatorTreeNode != null) {
            this.m_tree.refresh(navigatorTreeNode);
        }
    }

    @Override
    public void objectsAdded(String string, DBObject[] dBObjectArray) {
    }

    protected final NavigatorTreeNode findTreeNode(String string, DBObject dBObject) {
        URL uRL;
        NavigatorTreeNode navigatorTreeNode = this.getConnectionNode(string);
        if (navigatorTreeNode != null && (uRL = dBObject.getURL()) != null) {
            return this.m_tree.findTreeNode(dBObject.getURL(), navigatorTreeNode);
        }
        return null;
    }

    protected NavigatorTreeNode getConnectionNode(String string) {
        DatabaseConnection databaseConnection = Databases.getConnectionNode(string, false);
        if (databaseConnection == null) {
            return null;
        }
        return this.m_tree.findTreeNode(databaseConnection, this.m_tree.getRoot());
    }

    @Override
    public boolean canHandleObject(DBObject dBObject) {
        URL uRL = dBObject.getURL();
        return uRL != null && this.m_protocol.equals(uRL.getProtocol());
    }

    protected final NavigatorTree getTree() {
        return this.m_tree;
    }
}

