/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.controls.display.DrillObject;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class DrillToBaseObject
extends GridContextMenuItem {
    private static DrillToBaseObject _instance = null;
    private static String _drillCmdName = "TABLE_DRILL_TO";
    private static int _drillCmdId = Ide.findOrCreateCmdID((String)_drillCmdName);
    private IdeAction _action = null;
    private static final String URL = "DRILL_RO_URL";

    private DrillToBaseObject() {
        this.initAction();
    }

    private void initAction() {
        if (this._action == null) {
            this._action = this.createAction(_drillCmdId, Messages.getString("RSTableDrillToBaseObject.2"), null);
        }
    }

    public static DrillToBaseObject getInstance() {
        if (_instance == null) {
            _instance = new DrillToBaseObject();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        return this._table != null;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        try {
            if (this._table != null) {
                DrillObject drillObject;
                URL uRL;
                String string;
                List<DrillObject> list;
                int n = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
                if (!((n = this._table.convertRowIndexToModel(n)) < 0 || !(this._table.getModel() instanceof ResultSetTableModel) || (list = ((ResultSetTableModel)((Object)this._table.getModel())).getDrillUrls()).size() <= n || (string = DBURLFormatHelper.getBaseType(uRL = (drillObject = list.get(n)).getUrl())).contains("JAVA") || string.contains("LOB") || string.contains("INDEX PARTITION") || string.contains("TABLE PARTITION") || string.contains("CLUSTER") || string.contains("CONSUMER GROUP") || string.contains("CONTEXT") || string.contains("DIRECTORY") || string.contains("EDITION") || string.contains("EVALUATION CONTEXT") || string.contains("XML SCHEMA") || string.contains("WINDOW GROUP") || string.contains("WINDOW") || string.contains("JOB") || string.contains("JOB CLASS") || string.contains("LIBRARY") || string.contains("OPERATOR") || string.contains("PROGRAM") || string.contains("RULE") || string.contains("RULE SET") || string.contains("SCHEDULE") || string.contains("INDEXTYPE") || string.contains("TABLE SUBPARTITION"))) {
                    JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._action);
                    jMenuItem.setText(MessageFormat.format(Messages.getString("RSTableDrillToBaseObject.3"), DBURLFormatHelper.getName(uRL)));
                    this._action.putValue(URL, (Object)drillObject);
                    contextMenu.add((Component)jMenuItem);
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(DrillToBaseObject.class, (Throwable)exception);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == _drillCmdId) {
            DrillObject drillObject = (DrillObject)ideAction.getValue(URL);
            URL uRL = drillObject.getUrl();
            if (DBURLFormatHelper.getBaseType(uRL).contains("PACKAGE") || DBURLFormatHelper.getBaseType(uRL).equals("PROCEDURE") || DBURLFormatHelper.getBaseType(uRL).equals("FUNCTION")) {
                try {
                    String string = drillObject.getRow();
                    int n = Integer.parseInt(string);
                    NavSelectionListener.getInstance().open(uRL, n + 1, 0);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IdentifierDefinitionLookup.goTo(uRL, false);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }
}

