/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.ide.util.MetaResource;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.AbstractDisplayModelParser;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.DrillToBaseObject;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.oviewer.base.ViewerEditorAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerNavigationPoint;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.support.MetaPackageReference;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionInitializer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.util.Util;
import oracle.dbtools.xml.MetadataManifest;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Pair;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ViewerAddin
implements Addin {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-viewers";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-viewers", "sqldev-viewer-hook");
    private static final String ENTRY_ELEMENT = "viewerDescriptor";
    private static final String PACKAGE_ATTR = "package";
    private static Logger logger = Logger.getLogger(ViewerAddin.class.getName());
    private static final String CLASS = "class";
    private static List<Pair<String, ClassLoader>> _registeredPackages = new ArrayList<Pair<String, ClassLoader>>();
    private Map<String, List<ViewerEditorAddin>> _editorsAddins = new HashMap<String, List<ViewerEditorAddin>>();
    private Map<String, List<DisplayModel>> _editors = new HashMap<String, List<DisplayModel>>();
    private static Object __LOCK__ = new Object();
    private static Thread s_loader;
    private static boolean s_XML_Loaded;
    private static XMLParser PARSER;
    public static final String LOCAL_ACCELERATORS_FILE = "oracle/dbtools/raptor/oviewer/base/accelerators.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXmlLoaded() {
        Object object = __LOCK__;
        synchronized (object) {
            return s_XML_Loaded;
        }
    }

    public static void registerPackage(String string) {
        ViewerAddin.registerPackage(string, ViewerAddin.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPackage(String string, ClassLoader classLoader) {
        Object object = __LOCK__;
        synchronized (object) {
            if (PARSER == null) {
                _registeredPackages.add((Pair<String, ClassLoader>)new Pair((Object)string, (Object)classLoader));
            } else {
                ViewerAddin.loadPackage(string, classLoader);
            }
        }
    }

    public void initialize() {
        NavSelectionListener.initialize();
        ResultSetTable.setDrillDown(NavSelectionListener.getInstance());
        ResultSetTable.addGridContextMenu((GridContextMenuItem)DrillToBaseObject.getInstance());
        ConnectionInitializer connectionInitializer = new ConnectionInitializer(){
            ConnectionInitializer self;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeConnection(ConnectionDetails connectionDetails) {
                this.self = this;
                Object object = __LOCK__;
                synchronized (object) {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Connections.getInstance().removeInitializer(self);
                            ViewerAddin.this.loadXMLEditors();
                            Object object = __LOCK__;
                            synchronized (object) {
                                s_loader = null;
                            }
                        }
                    };
                    s_loader = new Thread(runnable, "Objectviewer XML Loader");
                    s_loader.start();
                }
            }
        };
        Connections.getInstance().addInitializer(connectionInitializer);
        NavigationManager navigationManager = NavigationManager.getNavigationManager();
        if (navigationManager != null) {
            navigationManager.registerEditorNavigationPoint(ViewerNavigationPoint.class, XMLBasedEditor.class);
        }
    }

    public void addTab(String string, String string2, String string3, Class<? extends Editor> clazz, DisplayModel displayModel) {
        ViewerEditorAddin viewerEditorAddin = new ViewerEditorAddin(string, string2, string3, clazz, displayModel);
        if (XMLBasedEditor.class.isAssignableFrom(clazz)) {
            String string4 = ViewerAddin.getKey(string2, string3);
            this.registerEditor(viewerEditorAddin, string4);
        }
        if (Ide.isRunning() && EditorManager.getEditorManager() != null) {
            EditorManager.getEditorManager().registerDynamic((EditorAddin)viewerEditorAddin);
        }
    }

    private static String getKey(String string, String string2) {
        if (string == null) {
            string = "Oracle";
        }
        return string + "#" + string2;
    }

    private void registerEditor(ViewerEditorAddin viewerEditorAddin, String string) {
        List<ViewerEditorAddin> list = this._editorsAddins.get(string);
        if (list == null) {
            list = new ArrayList<ViewerEditorAddin>();
            this._editorsAddins.put(string, list);
        }
        list.add(viewerEditorAddin);
    }

    public DisplayModel getModel(DBObject dBObject, int n) {
        String string = null;
        string = dBObject.getKey();
        DisplayModel displayModel = null;
        List<ViewerEditorAddin> list = this.getEditorsAddins(string);
        if (list != null && list.size() > n) {
            displayModel = list.get(n).getModel();
        }
        return displayModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ViewerEditorAddin> getEditorsAddins(String string) {
        Object object = __LOCK__;
        synchronized (object) {
            return this._editorsAddins.get(string);
        }
    }

    public Map<String, List<DisplayModel>> getXMLEditors() {
        return this._editors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXMLEditors() {
        Object object = __LOCK__;
        synchronized (object) {
            URL uRL3;
            Object object2;
            Iterator iterator;
            Object object3;
            Object object5;
            long l = System.currentTimeMillis();
            this.loadCommonQueries();
            PARSER = new XMLParser();
            ClassLoader classLoader = ViewerAddin.class.getClassLoader();
            URL uRL2 = classLoader.getResource("META-INF/metadata.json");
            if (uRL2 != null) {
                try {
                    object5 = uRL2.openStream();
                    Throwable object42 = null;
                    try {
                        object3 = MetadataManifest.createManifest((InputStream)object5);
                        iterator = object3.viewers().iterator();
                        while (iterator.hasNext()) {
                            object2 = (String)iterator.next();
                            uRL3 = classLoader.getResource((String)object2);
                            if (uRL3 == null) continue;
                            ViewerAddin.loadURL(uRL3, classLoader);
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable exception = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object5 != null) {
                            if (object42 != null) {
                                try {
                                    ((InputStream)object5).close();
                                }
                                catch (Throwable throwable) {
                                    object42.addSuppressed(throwable);
                                }
                            } else {
                                ((InputStream)object5).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (Pair pair : _registeredPackages) {
                object3 = (String)pair.first;
                iterator = (ClassLoader)pair.second;
                ViewerAddin.loadPackage((String)object3, (ClassLoader)((Object)iterator));
            }
            object5 = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            object5.addHashStructureHookListener((HashStructureHookListener)new Listener());
            if (System.getProperty("raptor.user.editors") != null) {
                try {
                    PARSER.processXML(MetaURLReference.createURLReference((File)new File(System.getProperty("raptor.user.editors")), (ClassLoader)this.getClass().getClassLoader()));
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, Messages.getString("ViewerAddin.14") + exception.getMessage());
                }
            }
            ClassLoader classLoader2 = this.getClass().getClassLoader();
            object3 = DBConfig.getInstance().getExtensions("EDITOR");
            if (object3 != null) {
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    uRL3 = null;
                    try {
                        uRL3 = new URL((String)object2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL3 = URLFactory.newFileURL((File)new File((String)object2));
                    }
                    if (uRL3 != null) {
                        ViewerAddin.loadURL(uRL3, classLoader2);
                        continue;
                    }
                    Logger.getLogger(ViewerAddin.class.getName()).warning(Messages.getString("ViewerAddin.3") + URLFileSystem.getSystemDisplayName((URL)uRL3));
                }
            }
            if ((iterator = Util.getUserExtensionsDirectory()) != null) {
                for (URL uRL3 : FileUtils.getFilesInPath((URL[])new URL[]{iterator}, (String)"xml")) {
                    ViewerAddin.loadURL(uRL3, classLoader2);
                }
            }
            s_XML_Loaded = true;
            logger.info(MessageFormat.format("Time to loadXMLEditors(): {1}ms", this.getClass().getName(), System.currentTimeMillis() - l));
        }
    }

    private static void loadURL(URL uRL, ClassLoader classLoader) {
        try {
            PARSER.processXML(MetaURLReference.createURLReference((URL)uRL, (ClassLoader)classLoader));
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, Messages.getString("ViewerAddin.15") + exception.getMessage());
        }
    }

    private static void loadPackage(String string, ClassLoader classLoader) {
        for (URL uRL : FileUtils.getFilesInPackage((String)string, (ClassLoader)classLoader, (String)"xml")) {
            try {
                PARSER.processXML(MetaURLReference.createURLReference((URL)uRL, (ClassLoader)classLoader));
            }
            catch (Exception exception) {
                logger.info(Messages.getString("ViewerAddin.11") + URLFileSystem.getSystemDisplayName((URL)uRL));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL getCommonQueriesXMLURL() {
        ClassLoader classLoader = NavigatorHook.class.getClassLoader();
        URL uRL = classLoader.getResource("META-INF/metadata.json");
        if (uRL == null) return null;
        try (InputStream inputStream = uRL.openStream();){
            String string;
            URL uRL2;
            MetadataManifest metadataManifest = MetadataManifest.createManifest((InputStream)inputStream);
            Iterator iterator = metadataManifest.commonQueries().iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while ((uRL2 = classLoader.getResource(string = (String)iterator.next())) == null);
            URL uRL3 = uRL2;
            return uRL3;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void loadCommonQueries() {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        URL uRL = ViewerAddin.getCommonQueriesXMLURL();
        if (uRL == null) {
            return;
        }
        try {
            dOMParser.parse(uRL);
        }
        catch (XMLParseException xMLParseException) {
            logger.log(Level.WARNING, xMLParseException.getStackTrace()[0].toString(), xMLParseException);
        }
        catch (SAXException sAXException) {
            logger.log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        NodeList nodeList = xMLDocument.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node = nodeList.item(i);
            if (node.getNodeName().equals("queries")) {
                Query.getQueries((org.w3c.dom.Node)node);
                continue;
            }
            if (node.getNodeName().equals("query")) {
                Query.getQuery((org.w3c.dom.Node)node, null);
                continue;
            }
            if (!node.getNodeName().equals("display")) continue;
            DisplayModel.getDisplayModel(MetaXMLReference.createXMLReference((org.w3c.dom.Node)node, (ClassLoader)this.getClass().getClassLoader()), null);
        }
    }

    public List<DisplayModel> getModels(Class<? extends Node> clazz) {
        if (!Node.class.isAssignableFrom(clazz)) {
            return null;
        }
        String string = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1);
        String[] stringArray = AbstractDisplayModelParser.getTypesForNode(string);
        String string2 = ViewerAddin.getKey("Oracle", stringArray[0]);
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        List<ViewerEditorAddin> list = this.getEditorsAddins(string2);
        for (ViewerEditorAddin viewerEditorAddin : list) {
            arrayList.add(viewerEditorAddin.getModel());
        }
        return arrayList;
    }

    public List<DisplayModel> getModels(DBObject dBObject) {
        String string = ViewerAddin.getKey(dBObject.getConnectionType(), dBObject.getObjectType());
        List<ViewerEditorAddin> list = this.getEditorsAddins(string);
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        if (list != null) {
            for (ViewerEditorAddin viewerEditorAddin : list) {
                arrayList.add(viewerEditorAddin.getModel());
            }
        }
        return arrayList;
    }

    public void cloneEditors(String string, String string2, String string3) {
        this.cloneEditors(string, string2, string3, string2);
    }

    public void cloneEditors(String string, String string2, String string3, String string4) {
        String string5 = ViewerAddin.getKey(string, string2);
        List<ViewerEditorAddin> list = this.getEditorsAddins(string5);
        for (ViewerEditorAddin viewerEditorAddin : list) {
            String string6 = viewerEditorAddin.getModel().getName();
            this.addTab(string6, string3, string4, viewerEditorAddin.getEditorClass(), viewerEditorAddin.getModel());
        }
    }

    private final class XMLParser
    extends AbstractDisplayModelParser {
        private XMLParser() {
        }

        @Override
        protected void registerEditor(String string, String string2, DisplayModel displayModel, MetaClass<? extends Editor> metaClass) {
            String string3 = ViewerAddin.getKey(string, string2);
            if (string3 != null) {
                displayModel.getExtAttributes().put(ViewerAddin.CLASS, string3);
                if (ViewerAddin.this._editors.get(string3) == null) {
                    ViewerAddin.this._editors.put(string3, new ArrayList());
                }
                if (metaClass == null) {
                    ((List)ViewerAddin.this._editors.get(string3)).add(displayModel);
                }
                Class<Editor> clazz = null;
                try {
                    if (metaClass != null) {
                        clazz = metaClass.toClass().asSubclass(Editor.class);
                    } else {
                        int n = ((List)ViewerAddin.this._editors.get(string3)).size() - 1;
                        String string4 = "oracle.dbtools.raptor.oviewer.xmleditor.holders.XMLBasedEditor" + n;
                        clazz = this.getClass().getClassLoader().loadClass(string4).asSubclass(Editor.class);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.severe(Messages.getString("ViewerAddin.51") + classNotFoundException.getMessage());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    logger.severe(Messages.getString("ViewerAddin.51") + noClassDefFoundError.getMessage());
                }
                ViewerAddin.this.addTab(displayModel.getName(), string, string2, clazz, displayModel);
            }
        }
    }

    private class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDescriptors(HashStructure hashStructure) {
            Object object = __LOCK__;
            synchronized (object) {
                List list = hashStructure.getAsList(ViewerAddin.ENTRY_ELEMENT);
                if (list != null) {
                    for (HashStructure hashStructure2 : list) {
                        LazyResourceAdapter lazyResourceAdapter = LazyResourceAdapter.getInstance((HashStructure)hashStructure2);
                        MetaResource metaResource = lazyResourceAdapter.getMetaResource(ViewerAddin.PACKAGE_ATTR);
                        if (metaResource == null) continue;
                        MetaPackageReference metaPackageReference = MetaPackageReference.createPackageReference((MetaResource)metaResource);
                        for (MetaURLReference metaURLReference : metaPackageReference.getURLReferences("xml")) {
                            try {
                                PARSER.processXML(metaURLReference);
                            }
                            catch (Exception exception) {
                                logger.info(Messages.getString("ViewerAddin.11") + URLFileSystem.getSystemDisplayName((URL)metaURLReference.getURL()));
                            }
                        }
                    }
                }
            }
        }
    }
}

