/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.breadcrumbs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.plsql.breadcrumbs.PlSqlBreadcrumb;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;

public class PlSqlBreadcrumbsModel
implements BreadcrumbsModel,
ParserEventListener {
    private final List<BreadcrumbsModelListener> m_listeners = new LinkedList<BreadcrumbsModelListener>();
    private final ArrayList<Breadcrumb> m_crumbs = new ArrayList();
    private BackgroundParser parser = null;

    public PlSqlBreadcrumbsModel(BackgroundParser backgroundParser) {
        this.parser = backgroundParser;
    }

    public int getBreadcrumbCount() {
        return this.m_crumbs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breadcrumb getBreadcrumb(int n) {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            if (n < this.getBreadcrumbCount()) {
                return this.m_crumbs.get(n);
            }
            return null;
        }
    }

    public void addBreadcrumbsModelListener(BreadcrumbsModelListener breadcrumbsModelListener) {
        if (!this.m_listeners.contains(breadcrumbsModelListener)) {
            this.m_listeners.add(breadcrumbsModelListener);
        }
    }

    public void removeBreadcrumbsModelListener(BreadcrumbsModelListener breadcrumbsModelListener) {
        if (this.m_listeners.contains(breadcrumbsModelListener)) {
            this.m_listeners.remove(breadcrumbsModelListener);
        }
    }

    public boolean hasChildren(Breadcrumb breadcrumb) {
        return ((PlSqlBreadcrumb)breadcrumb).canHavePopupItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(int n) {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            this.m_crumbs.clear();
            int n2 = LexerToken.char2lex(this.parser.src, (int)n);
            try {
                if (this.parser.src == null) {
                    return true;
                }
                if (this.parser.output == null) {
                    return true;
                }
                LazyNode lazyNode = PlSqlBreadcrumbsModel.leafAtPos(this.parser.output, n2);
                while (lazyNode != null) {
                    int n3 = lazyNode.from;
                    String string = this.parser.src.get((int)n3).content;
                    String string2 = "";
                    LazyNode lazyNode2 = PlSqlBreadcrumbsModel.leafAtPos(lazyNode, lazyNode.from);
                    if (lazyNode.isCompilationUnit() || lazyNode.isProcedure() || "if".equalsIgnoreCase(string) || "for".equalsIgnoreCase(string)) {
                        string2 = " " + this.parser.src.get((int)(n3 + 1)).content;
                    }
                    if (n3 + 1 < this.parser.src.size() && "body".equalsIgnoreCase(this.parser.src.get((int)(n3 + 1)).content)) {
                        string = string + " BODY";
                        string2 = " " + this.parser.src.get((int)(n3 + 2)).content;
                    }
                    if (!("create".equalsIgnoreCase(string) || lazyNode.isAs() || this.isForLoop(this.parser.output, lazyNode))) {
                        PlSqlBreadcrumb plSqlBreadcrumb = new PlSqlBreadcrumb(string, string2, this.parser.src.get((int)n3).begin, "tooltip");
                        this.m_crumbs.add(0, plSqlBreadcrumb);
                    }
                    lazyNode = PlSqlBreadcrumbsModel.parent(this.parser.output, lazyNode);
                }
                return true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                this.m_crumbs.clear();
            }
        }
        return false;
    }

    private boolean isForLoop(LazyNode lazyNode, LazyNode lazyNode2) {
        if (!"loop".equalsIgnoreCase(lazyNode2.startToken)) {
            return false;
        }
        LazyNode lazyNode3 = (LazyNode)this.parser.output.parent(lazyNode2.from, lazyNode2.to);
        if (lazyNode3 == null) {
            return false;
        }
        return "for".equalsIgnoreCase(lazyNode3.startToken);
    }

    public void dispose() {
        this.m_crumbs.clear();
    }

    void fireBreadcrumbsUpdated() {
        for (BreadcrumbsModelListener breadcrumbsModelListener : this.m_listeners) {
            breadcrumbsModelListener.breadcrumbsUpdated();
        }
    }

    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
    }

    public static LazyNode leafAtPos(LazyNode lazyNode, int n) {
        ParseNode parseNode;
        Iterator iterator = lazyNode.shallowChildren().iterator();
        while (iterator.hasNext() && (parseNode = (ParseNode)iterator.next()) instanceof LazyNode) {
            if (parseNode.from > n || n >= parseNode.to) continue;
            return PlSqlBreadcrumbsModel.leafAtPos((LazyNode)parseNode, n);
        }
        return lazyNode;
    }

    public static LazyNode parent(LazyNode lazyNode, LazyNode lazyNode2) {
        ParseNode parseNode;
        Iterator iterator = lazyNode.shallowChildren().iterator();
        while (iterator.hasNext() && (parseNode = (ParseNode)iterator.next()) instanceof LazyNode) {
            if (parseNode == lazyNode2) {
                return lazyNode;
            }
            if (parseNode.from > lazyNode2.from || lazyNode2.to > parseNode.to) continue;
            return PlSqlBreadcrumbsModel.parent((LazyNode)parseNode, lazyNode2);
        }
        return null;
    }
}

