/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.plsql.structure.MergedNode;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;

public class ArboriGrid
extends JTable {
    protected Boolean isZebraRows() {
        return DBConfig.getInstance().getBoolean("ZEBRA_ROWS");
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (this.isZebraRows().booleanValue() && !this.isCellSelected(n, n2)) {
            if (n % 2 == 0 && n2 % 2 == 0) {
                component.setBackground(RaptorGridTable.color00);
            } else if (n % 2 == 0 && n2 % 2 == 1) {
                component.setBackground(RaptorGridTable.color10);
            } else if (n % 2 == 1 && n2 % 2 == 0) {
                component.setBackground(RaptorGridTable.color01);
            } else if (n % 2 == 1 && n2 % 2 == 1) {
                component.setBackground(RaptorGridTable.color11);
            }
        }
        return component;
    }

    static ArboriGrid initGrid(final OutlinePanel outlinePanel) {
        final ArboriGrid arboriGrid = new ArboriGrid();
        arboriGrid.setCellSelectionEnabled(true);
        arboriGrid.setColumnSelectionAllowed(false);
        arboriGrid.setRowSelectionAllowed(true);
        arboriGrid.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2) {
                    return;
                }
                int n2 = arboriGrid.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                ParseNode parseNode = (ParseNode)arboriGrid.getValueAt(n2, n = arboriGrid.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY())));
                if (parseNode == null) {
                    return;
                }
                outlinePanel.current = parseNode;
                for (int i = 0; i < outlinePanel.tree.getRowCount(); ++i) {
                    TreePath treePath = outlinePanel.tree.getPathForRow(i);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    ParseNode parseNode2 = (ParseNode)defaultMutableTreeNode.getUserObject();
                    if (parseNode2.from <= parseNode.from && parseNode.to <= parseNode2.to) {
                        if (parseNode2 instanceof MergedNode) {
                            outlinePanel.expandTreeNode(defaultMutableTreeNode);
                        }
                        outlinePanel.tree.expandRow(i);
                    }
                    if (parseNode2.from != parseNode.from || parseNode2.to != parseNode.to) continue;
                    outlinePanel.tree.setSelectionRow(i);
                    if (treePath == null) continue;
                    Rectangle rectangle = outlinePanel.tree.getPathBounds(treePath);
                    rectangle.height = outlinePanel.tree.getVisibleRect().height;
                    outlinePanel.tree.scrollRectToVisible(rectangle);
                }
            }
        });
        arboriGrid.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = arboriGrid.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                int n2 = arboriGrid.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (n == -1 || n2 == -1) {
                    arboriGrid.setCursor(new Cursor(0));
                    return;
                }
                Object object = arboriGrid.getModel().getValueAt(n, n2);
                String string = object.toString();
                if (string == null || "...".equals(string) || string.length() == 0) {
                    arboriGrid.setCursor(new Cursor(0));
                    return;
                }
                arboriGrid.setCursor(new Cursor(12));
            }
        });
        arboriGrid.setDefaultRenderer(ParseNode.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                StringBuilder stringBuilder = new StringBuilder("<html><pre>");
                ParseNode parseNode = (ParseNode)object;
                stringBuilder.append("<font color=green>");
                stringBuilder.append("[" + parseNode.from + "," + parseNode.to + ")");
                stringBuilder.append("</font>");
                for (String string : parseNode.contentAsStrings()) {
                    if (string.contains("[")) continue;
                    if (string.charAt(0) == '\'') {
                        string = "<font color=blue>" + string + "</font>";
                    }
                    stringBuilder.append(" " + string);
                }
                this.setText(stringBuilder.toString());
            }
        });
        return arboriGrid;
    }
}

