/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.plsql.structure.ArboriGrid;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriLanguageSupport;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.icons.OracleIcons;

public class ArboriToolbar
extends JToolBar {
    ArboriPanel context;
    static final String sugarcoatError = "<html><font color=red>";

    public ArboriToolbar(ArboriPanel arboriPanel) {
        this.context = arboriPanel;
        JButton jButton = new JButton(OracleIcons.getIcon((String)"run.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArboriToolbar.this.run();
            }
        });
        this.add(jButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        this.context.tabbedPane.removeAll();
        try {
            Program.debug = false;
            String string = this.context.code.getText();
            SyntaxError syntaxError = ((ArboriLanguageSupport)this.context.code.getLanguageSupport()).parser.error;
            if (syntaxError != null) {
                throw syntaxError;
            }
            OutlinePanel outlinePanel = (OutlinePanel)OutlineWindow.getInstance().getGUI();
            SqlProgram sqlProgram = new SqlProgram(string);
            if (outlinePanel.parser == null || outlinePanel.parser.text == null) {
                throw new AssertionError((Object)"No active Worksheet or PL/SQL editor? Please also open the Code Outline panel.");
            }
            List list = LexerToken.parse((String)outlinePanel.parser.text);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("outlinePanel", outlinePanel);
            hashMap.put("arboriPanel", this.context);
            hashMap.put("connections", Connections.getInstance());
            Map map = sqlProgram.run(outlinePanel.parser.text, list, new String[]{"program"}, hashMap);
            LinkedList linkedList = sqlProgram.querySequence();
            for (String string2 : linkedList) {
                Object object2;
                final MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get(string2);
                final ParseNode[][] parseNodeArray = new ParseNode[materializedPredicate.cardinality()][materializedPredicate.arity()];
                int n = -1;
                for (Object object2 : materializedPredicate.getTuples()) {
                    ++n;
                    for (int i = 0; i < materializedPredicate.arity(); ++i) {
                        ParseNode parseNode;
                        parseNodeArray[n][i] = parseNode = materializedPredicate.getAttribute((Tuple)object2, materializedPredicate.getAttribute(i));
                    }
                }
                ArboriGrid arboriGrid = ArboriGrid.initGrid(outlinePanel);
                arboriGrid.setModel(new DefaultTableModel(){

                    @Override
                    public int getRowCount() {
                        return materializedPredicate.cardinality();
                    }

                    @Override
                    public int getColumnCount() {
                        return materializedPredicate.arity();
                    }

                    @Override
                    public String getColumnName(int n) {
                        return materializedPredicate.getAttribute(n);
                    }

                    @Override
                    public Class<?> getColumnClass(int n) {
                        return ParseNode.class;
                    }

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int n, int n2) {
                        return parseNodeArray[n][n2];
                    }
                });
                object2 = new JScrollPane(arboriGrid);
                ((JScrollPane)object2).setHorizontalScrollBarPolicy(30);
                ((JScrollPane)object2).setVerticalScrollBarPolicy(20);
                this.context.tabbedPane.add(string2, (Component)object2);
            }
        }
        catch (SyntaxError syntaxError) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("<html><font color=red>Arbori syntax error:"));
            jPanel.add(new JLabel(sugarcoatError + syntaxError.getMessage()));
            this.context.tabbedPane.add("Error", jPanel);
        }
        catch (AssertionError assertionError) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("<html><font color=red>AssertionError"));
            jPanel.add(new JLabel(sugarcoatError + ((Throwable)((Object)assertionError)).getMessage()));
            this.context.tabbedPane.add("Error", jPanel);
        }
        catch (Exception exception) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("<html><font color=red>Exception " + exception.getClass().getName()));
            jPanel.add(new JLabel(sugarcoatError + exception.getMessage()));
            this.context.tabbedPane.add("Error", jPanel);
            exception.printStackTrace();
        }
    }
}

