/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure.arbori;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.java.JavaEarley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.plsql.language.PLSQLStyles;
import oracle.dbtools.raptor.plsql.structure.arbori.BackgroundParser;
import oracle.dbtools.raptor.plsql.structure.arbori.ParserEventListener;
import oracle.javatools.editor.language.AbstractDocumentRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyledFragmentsList;

class ArboriDocumentRenderer
extends AbstractDocumentRenderer
implements ParserEventListener {
    BackgroundParser parser;
    private static Logger logger = Logger.getLogger(ArboriDocumentRenderer.class.getName());

    ArboriDocumentRenderer(LanguageSupport languageSupport, BackgroundParser backgroundParser) {
        super(languageSupport);
        this.parser = backgroundParser;
    }

    public void renderRegion(StyledFragmentsList styledFragmentsList, int n, int n2) {
        if (n2 <= n) {
            return;
        }
        long l = System.currentTimeMillis();
        this.render(styledFragmentsList, n, n2);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (30L < l3) {
            logger.log(Level.INFO, "renderRegion [" + n + "," + n2 + ")");
            logger.log(Level.INFO, "renderRegion time = " + l3);
        }
    }

    private void render(StyledFragmentsList styledFragmentsList, int n, int n2) {
        if (this.parser == null || this.parser.src == null || this.parser.increments.size() != 0) {
            styledFragmentsList.add(PLSQLStyles.plsqlPlainStyle.getName(), n, n2);
            return;
        }
        int n3 = 0;
        int n4 = n;
        int n5 = -1;
        int n6 = -1;
        if (this.parser.error != null) {
            n5 = this.parser.error.end;
            if (this.parser.text.length() - 3 < n5) {
                n5 = this.parser.text.length() - 3;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            n6 = n5 + 3;
            if (this.parser.text.length() < n6) {
                n6 = this.parser.text.length();
            }
        }
        for (LexerToken lexerToken : this.parser.allSrc) {
            n3 = lexerToken.begin + lexerToken.content.length();
            if (lexerToken.type == Token.COMMENT) {
                n3 = lexerToken.end;
            }
            if (n2 <= lexerToken.begin) break;
            if (n <= n3) {
                if (lexerToken.begin <= n5 && n5 < lexerToken.end || lexerToken.begin <= n6 && n6 < lexerToken.end) {
                    ArboriDocumentRenderer.addFragment(styledFragmentsList, "css-error-style", lexerToken.begin, n3);
                    n4 = n3;
                    continue;
                }
                String string = null;
                boolean bl = false;
                ParseNode parseNode = this.parser.root.leafAtPos(LexerToken.scanner2parserOffset(this.parser.src, (int)lexerToken.begin));
                if (parseNode != null) {
                    ParseNode parseNode2 = parseNode.ancestor(this.parser.earley.getSymbol("javascript"));
                    if (parseNode2 != null) {
                        bl = true;
                    } else if (parseNode.contains("payload") && SqlEarley.getInstance().getSymbol(lexerToken.content) == -1) {
                        ArboriDocumentRenderer.addFragment(styledFragmentsList, "css-function-style", lexerToken.begin, n3);
                        n4 = n3;
                        continue;
                    }
                }
                switch (lexerToken.type) {
                    case IDENTIFIER: {
                        if (bl && (JavaEarley.isKeyword((String)lexerToken.content) || "var".equals(lexerToken.content))) {
                            string = PLSQLStyles.plsqlKeywordStyle.getName();
                            break;
                        }
                        string = PLSQLStyles.plsqlIdentifierStyle.getName();
                        break;
                    }
                    case DIGITS: {
                        string = PLSQLStyles.plsqlNumberStyle.getName();
                        break;
                    }
                    case QUOTED_STRING: {
                        string = PLSQLStyles.plsqlStringStyle.getName();
                        break;
                    }
                    case OPERATION: {
                        string = "diff-removal-style";
                        break;
                    }
                    case LINE_COMMENT: 
                    case COMMENT: {
                        string = PLSQLStyles.plsqlCommentStyle.getName();
                        break;
                    }
                    default: {
                        string = PLSQLStyles.plsqlPlainStyle.getName();
                    }
                }
                try {
                    ArboriDocumentRenderer.addFragment(styledFragmentsList, string, lexerToken.begin, n3);
                }
                catch (IllegalStateException illegalStateException) {
                    ArboriDocumentRenderer.addFragment(styledFragmentsList, PLSQLStyles.plsqlPlainStyle.getName(), n4, n2);
                    return;
                }
            }
            n4 = n3;
        }
        if (n3 < n2 && n <= n3) {
            ArboriDocumentRenderer.addFragment(styledFragmentsList, PLSQLStyles.plsqlCommentStyle.getName(), n3, n2);
        }
    }

    private static void addFragment(StyledFragmentsList styledFragmentsList, String string, int n, int n2) {
        String string2 = null;
        if (string2 == null) {
            styledFragmentsList.add(string, n, n2);
        } else {
            styledFragmentsList.add(string2, n, n2);
        }
    }

    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
    }
}

