/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure.arbori;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.plsql.structure.arbori.ParserEventListener;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public class BackgroundParser
implements TextBufferListener,
EditorPlugin {
    private static Logger logger = Logger.getLogger(BackgroundParser.class.getName());
    public List<LexerToken> src = null;
    public List<LexerToken> allSrc = null;
    public String text = null;
    public ArrayList<NumberRange> increments = new ArrayList();
    private TextBuffer buffer = null;
    public Matrix matrix = null;
    public ParseNode root = null;
    public SyntaxError error = null;
    Earley earley;
    long lastUpdate = -1L;
    public BasicEditorPane editor;
    boolean quit = false;
    public boolean isInsertion = false;
    public boolean isSingleChar = false;
    static int cnt = 0;
    int instance;
    public boolean isParsing = false;
    private List<ParserEventListener> listeners = new ArrayList<ParserEventListener>();

    BackgroundParser() {
        try {
            this.earley = Program.getArboriParser();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n + n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n - n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractText() {
        block18: {
            boolean bl;
            if (!this.buffer.tryReadLock()) {
                return false;
            }
            try {
                if (this.buffer.getLength() > 5000000) {
                    this.quit = true;
                    Logger.getLogger(this.getClass().getName()).warning("Mem exceeded");
                    boolean bl2 = false;
                    return bl2;
                }
                this.text = this.buffer.getString(0, this.buffer.getLength());
                if (this.text != null) break block18;
                bl = false;
            }
            catch (Exception exception) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                try {
                    this.buffer.readUnlock();
                }
                catch (Throwable throwable) {}
            }
            return bl;
        }
        return true;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.quit = true;
        if (this.buffer != null) {
            this.buffer.removeTextBufferListener((TextBufferListener)this);
        }
        basicEditorPane.deinstallPlugin((EditorPlugin)this);
    }

    private void cleanup() {
        this.listeners.clear();
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        this.buffer = basicDocument.getTextBuffer();
        this.buffer.addTextBufferListener((TextBufferListener)this);
        if (this.text == null) {
            this.extractText();
        }
        this.init();
    }

    private void init() {
        this.src = null;
        if (this.extractText()) {
            try {
                this.parse();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            this.instance = cnt++;
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker("Arbori Background Parser#" + this.instance){

                @Override
                public Object construct() {
                    BackgroundParser.this.quit = false;
                    while (!BackgroundParser.this.quit) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (BackgroundParser.this.src != null && System.currentTimeMillis() - BackgroundParser.this.lastUpdate < 250L || BackgroundParser.this.src != null && BackgroundParser.this.increments.size() == 0) continue;
                        BackgroundParser.this.isInsertion = BackgroundParser.this.isInsertion();
                        BackgroundParser.this.isSingleChar = BackgroundParser.this.isSingleChar();
                        if (!BackgroundParser.this.extractText()) continue;
                        try {
                            BackgroundParser.this.parse();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    BackgroundParser.this.cleanup();
                    return null;
                }
            };
            namedSwingWorker.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        Object object;
        this.increments = new ArrayList();
        this.isParsing = true;
        long l = System.currentTimeMillis();
        if (this.text == null) {
            this.isParsing = false;
            return;
        }
        if (this.editor != null) {
            this.allSrc = LexerToken.parse((String)this.text, (boolean)true);
            List list = LexerToken.parse((String)this.text);
            int n = 15000;
            if (list.size() < n) {
                object = new Matrix((Parser)this.earley);
                this.earley.parse(list, (Matriceable)object);
                this.root = this.earley.forest(list, (Matrix)object);
                this.matrix = object;
                this.error = SyntaxError.checkSyntax((String)this.text, (String[])new String[]{"program"}, (List)list, (Earley)this.earley, (Matrix)this.matrix);
            } else {
                this.root = null;
                this.matrix = null;
                this.error = null;
            }
            this.src = list;
        } else {
            this.src = LexerToken.parse((String)this.text);
            this.matrix = new Matrix((Parser)this.earley);
            this.earley.parse(this.src, (Matriceable)this.matrix);
            this.root = this.earley.forest(this.src, this.matrix);
            this.error = SyntaxError.checkSyntax((String)this.text, (String[])new String[]{"program"}, this.src, (Earley)this.earley, (Matrix)this.matrix);
        }
        this.isParsing = false;
        long l2 = System.currentTimeMillis();
        object = new LinkedList();
        Object object2 = this.listeners;
        synchronized (object2) {
            for (ParserEventListener parserEventListener : this.listeners) {
                object.add(parserEventListener);
            }
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            ParserEventListener parserEventListener = (ParserEventListener)object2.next();
            try {
                if (0 < this.increments.size()) {
                    return;
                }
                parserEventListener.stateChanged(this);
            }
            catch (Throwable throwable) {
                throwable.fillInStackTrace();
            }
        }
        if (0 < this.increments.size()) {
            return;
        }
        this.editor.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParserEventListener(ParserEventListener parserEventListener) {
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(parserEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParserEventListener(ParserEventListener parserEventListener) {
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(parserEventListener);
        }
    }

    public int recalculatePosition(int n) {
        int n2 = this.recalcPos(n);
        while (n2 != n) {
            n = n2;
            n2 = this.recalcPos(n2);
        }
        return n2;
    }

    private int recalcPos(int n) {
        for (NumberRange numberRange : this.increments) {
            if (numberRange.end != n) continue;
            return numberRange.start;
        }
        return n;
    }

    private boolean isInsertion() {
        boolean bl = false;
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start < numberRange.end) {
                bl = true;
                continue;
            }
            if (numberRange.start <= numberRange.end) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isSingleChar() {
        if (this.increments.size() != 1) {
            return false;
        }
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start + 1 == numberRange.end) continue;
            return false;
        }
        return true;
    }
}

