/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.ProcArg;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.NameProcedurePanel;
import oracle.dbtools.raptor.refactor.RefactorException;
import oracle.dbtools.raptor.refactor.UndoableRefactoring;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class ProcedureExtractor
extends UndoableRefactoring {
    String name;
    boolean isLocal = false;
    boolean namedArguments = false;
    final String prefix = "p_";
    String selection = null;
    List<LexerToken> fragment;
    Matrix matrix;
    ParseNode selRoot;
    Connection conn = null;
    String connName = null;
    boolean isBody = false;
    int offset;
    int start;
    int end;
    static final SqlEarley earley = SqlEarley.getInstance();
    static int procedure_call = earley.getSymbol("procedure_call");
    static int expr = earley.getSymbol("expr");
    private Map<String, String> parameters;
    private Map<String, String> localVars;
    private List<Integer> defsToComment;

    public ProcedureExtractor(String string, List<LexerToken> list, ParseNode parseNode) {
        super(string, list, parseNode);
        int n = 0;
        for (LexerToken lexerToken : list) {
            if (n++ > 100) break;
            if (!"BODY".equalsIgnoreCase(lexerToken.content)) continue;
            this.isBody = true;
            break;
        }
        this.output = StackParser.getInstance().parse(list);
    }

    public ProcedureExtractor(Context context) {
        super(context);
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode) {
            this.isBody = ((PlSqlNode)node).isBody();
            this.connName = ((PlSqlNode)node).getConnectionName();
        } else if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser && view instanceof DbEditor) {
            BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
            this.src = backgroundParser.src;
            int n = 0;
            for (LexerToken lexerToken : this.src) {
                if (n++ > 100) break;
                if (!"BODY".equalsIgnoreCase(lexerToken.content)) continue;
                this.isBody = true;
                break;
            }
            this.connName = ((DbEditor)view).getConnectionName();
        }
        try {
            this.conn = Connections.getInstance().getConnection(this.connName);
        }
        catch (DBException dBException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Pieces extract(String string, String string2, String string3, String string4) throws RefactorException {
        Pieces pieces = new Pieces();
        this.connName = string4;
        try {
            this.conn = Connections.getInstance().getConnection(this.connName);
        }
        catch (DBException dBException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.selection = string;
        this.start = 0;
        this.end = string.length();
        this.offset = 0;
        this.isLocal = true;
        this.namedArguments = true;
        if (!this.parse(this.selection)) {
            throw new RefactorException(string2);
        }
        this.src = this.fragment;
        this.output = StackParser.getInstance().parse(this.src);
        this.name = string2.replace(" ", "");
        pieces.input = string;
        pieces.pkg_name = string3;
        this.finishExtract(pieces, null);
        return pieces;
    }

    private void extractParameters() {
        Map<ParseNode, Pair<Integer, Integer>> map = null;
        if (this.selRoot instanceof LazyNode) {
            throw new RuntimeException("VT: selRoot instanceof LazyNode");
        }
        map = IdentifiersDb.instance.collectIdentifiers(this.selRoot);
        Map<ParseNode, Pair<Integer, Integer>> map2 = IdentifiersDb.collectIdentifiers(this.offset, this.offset + 1, this.output);
        this.parameters = new TreeMap<String, String>();
        this.localVars = new TreeMap<String, String>();
        this.defsToComment = new LinkedList<Integer>();
        int n = -1;
        for (LexerToken lexerToken : this.fragment) {
            String string;
            ParseNode parseNode;
            ParseNode parseNode2;
            ParseNode parseNode3;
            ParseNode parseNode4;
            if (lexerToken.type != Token.IDENTIFIER || (parseNode4 = IdentifiersDb.getIdentifierDefinition((parseNode3 = new ParseNode(++n, n + 1, -1, -1, (Parser)SqlEarley.getInstance())).content(this.src), parseNode3.from, this.fragment, map)) != null || (parseNode2 = IdentifiersDb.getIdentifierDefinition((parseNode = new ParseNode(n + this.offset, n + this.offset + 1, -1, -1, (Parser)SqlEarley.getInstance())).content(this.src), parseNode.from, this.src, map2)) == null) continue;
            Pair<Integer, Integer> pair = map2.get(parseNode2);
            boolean bl = this.isUsedOutsideFragment(lexerToken.content, parseNode2.to, (Integer)pair.second(), this.offset, this.offset + this.fragment.size());
            if (!bl && (string = this.output.shallowLeaf(parseNode2.from, parseNode2.to)) != null && "(".equals(((LazyNode)string).startToken)) {
                bl = true;
            }
            string = parseNode2.content(this.src);
            String string2 = null;
            for (ParseNode parseNode5 : this.output.parent(parseNode2.from, parseNode2.from + 1).descendants()) {
                if (!parseNode5.contains(IdentifiersDb.instance.object_d_rhs) && !parseNode5.contains(IdentifiersDb.instance.unconstrained_type_wo_datetime) && !parseNode5.contains(IdentifiersDb.instance.unconstrained_type)) continue;
                string2 = parseNode5.content(this.src);
                if (!bl) {
                    this.defsToComment.add(Service.pair((int)parseNode2.from, (int)parseNode5.to));
                    break;
                }
                if (string2.indexOf(40) > 0) {
                    string2 = string2.substring(0, string2.indexOf(40));
                    break;
                }
                if (string2.indexOf(":=") <= 0) break;
                string2 = string2.substring(0, string2.indexOf(":="));
                break;
            }
            if (bl) {
                boolean bl2 = false;
                boolean bl3 = false;
                for (ParseNode parseNode6 : this.selRoot.ancestors(n)) {
                    if (parseNode6.contains(procedure_call)) {
                        bl3 = true;
                        continue;
                    }
                    if (!parseNode6.contains(expr)) continue;
                    bl2 = true;
                }
                String string3 = this.parameters.get(string);
                if (string3 != null && string3.startsWith("IN OUT")) continue;
                this.parameters.put(string, "IN " + (bl3 || !bl2 ? "OUT " : " ") + string2);
                continue;
            }
            this.localVars.put(string, " " + string2);
        }
    }

    private String processPlsqlBlock() {
        int n;
        Object object;
        Object object22;
        if (!this.selRoot.contains(ProcedureExtractor.earley.sql_statements)) {
            return this.selection;
        }
        Map<ParseNode, Pair<Integer, Integer>> map = IdentifiersDb.instance.collectIdentifiers(this.selRoot, true);
        List<ProcArg> list = ProcArg.collectViaDbQuery(this.selRoot, this.fragment, this.connName);
        for (ParseNode object32 : map.keySet()) {
            List list2 = this.selRoot.ancestors(object32.from);
            int string = 0;
            for (Object object22 : list2) {
                if (!object22.contains(IdentifiersDb.instance.block_stmt) && !object22.contains(IdentifiersDb.instance.loop_stmt)) continue;
                ++string;
            }
            if (string > 1) continue;
            object = this.selRoot.parent(object32.from, object32.from + 1);
            object22 = this.selRoot.parent(((ParseNode)object).from, ((ParseNode)object).from + 1);
            if (object22.contains(IdentifiersDb.instance.iteration_scheme)) continue;
            this.localVars.put(this.selection.substring(this.fragment.get((int)object22.from).begin, this.fragment.get((int)object22.to).begin), "");
        }
        TreeSet treeSet = new TreeSet();
        for (List list2 : this.selRoot.descendants()) {
            if (!list2.contains(IdentifiersDb.instance.bind_var)) continue;
            String string = IdentifiersDb.guessType((ParseNode)list2, this.fragment, this.selRoot, map, list);
            object = list2.content(this.fragment);
            object22 = this.parameters.get(object);
            if (object22 != null) {
                string = object22;
            }
            if (string == null) {
                string = ((String)object).contains("name") || ((String)object).contains("NAME") ? "VARCHAR2" : (((String)object).endsWith("_id") || ((String)object).endsWith("_ID") ? "NUMBER" : "VARCHAR2/*?*/");
            }
            if (!string.startsWith("IN")) {
                this.parameters.put((String)object, "IN " + string);
            }
            int n2 = this.fragment.get((int)((ParseNode)list2).from).begin;
            treeSet.add(n2);
        }
        Integer[] integerArray = treeSet.toArray(new Integer[0]);
        for (n = integerArray.length - 1; n >= 0; --n) {
            this.selection = this.selection.substring(0, integerArray[n]) + "p_" + this.selection.substring(integerArray[n] + 1);
        }
        n = integerArray.length;
        Object object3 = null;
        if (this.selRoot.contains(IdentifiersDb.instance.block_stmt)) {
            for (Object object22 : this.selRoot.children()) {
                if (!object22.contains(IdentifiersDb.instance.seq_of_stmts)) continue;
                object3 = object22;
                break;
            }
        }
        if (object3 == null) {
            return this.selection;
        }
        return this.selection.substring(this.fragment.get((int)object3.from).begin, this.fragment.get((int)object3.to).begin + n);
    }

    private boolean isUsedOutsideFragment(String string, int n, int n2, int n3, int n4) {
        int n5 = -1;
        for (LexerToken lexerToken : this.src) {
            if (++n5 < n || n2 <= n5 || n3 <= n5 && n5 < n4 || lexerToken.type != Token.IDENTIFIER || !lexerToken.content.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean finishExtract(Pieces pieces, BasicEditorPane basicEditorPane) {
        assert (pieces != null && basicEditorPane == null || pieces == null && basicEditorPane != null);
        this.extractParameters();
        String string = this.processPlsqlBlock();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = -1;
        for (String object3 : this.parameters.keySet()) {
            ++n;
            String object4 = object3;
            if (object3.charAt(0) == ':') {
                object4 = "p_" + object3.substring(1);
            }
            stringBuffer2.append((n > 0 ? "," : "(") + object4 + " " + this.parameters.get(object3));
            object4 = this.namedArguments ? object4 + "=>" + object3 : object3;
            stringBuffer.append((n > 0 ? "," : "(") + object4);
            if (this.parameters.size() <= 2) continue;
            stringBuffer.append("\n   ");
            stringBuffer2.append("\n   ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer2.append(')');
            stringBuffer.append(')');
        }
        try {
            String string2;
            for (Integer n2 : this.defsToComment) {
                int n3 = ((LexerToken)this.src.get((int)Service.Y((int)n2.intValue()))).begin + 1;
                int n4 = ((LexerToken)this.src.get((int)Service.X((int)n2.intValue()))).begin;
                if (n3 < n4 + 4) continue;
                string2 = null;
                if (basicEditorPane != null) {
                    basicEditorPane.setSelectionStart(n4);
                    basicEditorPane.setSelectionEnd(n3);
                    string2 = basicEditorPane.getSelectedText();
                } else {
                    string2 = pieces.input.substring(n4, n3);
                }
                this.replaceInterval(pieces, basicEditorPane, n4, n3, "/+" + string2.substring(2, string2.length() - 2) + "+/");
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            StringBuffer stringBuffer4 = new StringBuffer();
            stringBuffer3.append("procedure " + this.name + stringBuffer2.toString());
            stringBuffer4.append(" as\n");
            Object object = this.localVars.keySet().iterator();
            while (object.hasNext()) {
                int n5;
                int n6;
                String string3;
                string2 = string3 = object.next();
                if (!"".equals(this.localVars.get(string3))) {
                    string2 = string2 + " " + this.localVars.get(string3);
                }
                if (string2.contains(":=") && (n6 = string2.indexOf(":", (n5 = string2.indexOf(":=")) + 1)) > 0) {
                    string2 = string2.substring(0, n6) + "p_" + string2.substring(n6 + 1);
                }
                stringBuffer4.append("    " + string2 + ";\n");
            }
            stringBuffer4.append("begin\n" + string + "\nend;\n");
            object = ProcedureExtractor.indent(this.start, basicEditorPane) + this.name + stringBuffer.toString() + ";\n";
            String string4 = "";
            if (pieces != null && pieces.pkg_name != null) {
                string4 = pieces.pkg_name + ".";
            }
            if (pieces != null || this.src.size() == this.fragment.size()) {
                object = "begin\n" + string4 + (String)object + "end;\n";
            }
            if (!(this.isBody || this.isLocal || ProcedureExtractor.storeProcDefinition(this.conn, stringBuffer3.toString() + stringBuffer4.toString()))) {
                return true;
            }
            int n7 = this.calculateInsertPosition();
            this.replaceInterval(pieces, basicEditorPane, this.start, this.end, (String)object);
            if (this.isBody || this.isLocal) {
                if (pieces == null) {
                    this.replaceInterval(pieces, basicEditorPane, n7, n7, "\n-- refactored\n" + stringBuffer3.toString() + stringBuffer4.toString() + "\n");
                } else {
                    pieces.header = stringBuffer3.toString();
                    pieces.body = stringBuffer4.toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void replaceInterval(Pieces pieces, BasicEditorPane basicEditorPane, int n, int n2, String string) {
        if (basicEditorPane != null) {
            if (n == this.start && n2 == this.end) {
                basicEditorPane.select(n, n2);
            } else {
                basicEditorPane.setSelectionStart(n);
                basicEditorPane.setSelectionEnd(n2);
            }
            basicEditorPane.replaceSelection(string);
        } else {
            pieces.call = pieces.input.substring(0, n) + string + pieces.input.substring(n2);
        }
    }

    private int calculateInsertPosition() {
        int n = 0;
        if (!this.isBody && this.isLocal) {
            block0: for (ParseNode parseNode : this.output.intermediates(this.offset, this.offset + this.fragment.size())) {
                if (!parseNode.contains(IdentifiersDb.instance.subprg_body) && (!(parseNode instanceof LazyNode) || !"procedure".equalsIgnoreCase(((LazyNode)parseNode).startToken) && !"function".equalsIgnoreCase(((LazyNode)parseNode).startToken))) continue;
                for (ParseNode parseNode2 : parseNode.children()) {
                    if (!"BEGIN".equalsIgnoreCase(parseNode2.content(this.src)) && (!(parseNode2 instanceof LazyNode) || !"begin".equalsIgnoreCase(((LazyNode)parseNode2).startToken))) continue;
                    n = ((LexerToken)this.src.get((int)(parseNode2.from - 1))).end + 1;
                    continue block0;
                }
            }
        } else {
            for (ParseNode parseNode : this.output.intermediates(this.offset, this.offset + this.fragment.size())) {
                if (!parseNode.contains(IdentifiersDb.instance.subprg_body) && (!(parseNode instanceof LazyNode) || !"procedure".equalsIgnoreCase(((LazyNode)parseNode).startToken) && !"function".equalsIgnoreCase(((LazyNode)parseNode).startToken))) continue;
                n = ((LexerToken)this.src.get((int)(parseNode.from - 1))).end + 1;
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean storeProcDefinition(Connection connection, String string) {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
        basicEditorPane.setText("create \n" + string);
        basicEditorPane.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 22, 32);
        boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)jScrollPane, (String)Messages.getString("ProcedureExtractor.46"), (String)"f1_confirmrunningsql_html");
        if (bl) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.execute(basicEditorPane.getText());
            }
            catch (SQLException sQLException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)Messages.getString("ProcedureExtractor.48"), null);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return bl;
    }

    private boolean parse(String string) {
        this.fragment = LexerToken.parse((String)string);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(this.fragment, (Matriceable)matrix);
        if (!matrix.contains(0, this.fragment.size(), ProcedureExtractor.earley.sql_statements)) {
            return false;
        }
        this.selRoot = earley.forest(this.fragment, matrix);
        return true;
    }

    public static String indent(int n, BasicEditorPane basicEditorPane) {
        if (basicEditorPane == null) {
            return "";
        }
        int n2 = basicEditorPane.getLineFromOffset(n);
        int n3 = basicEditorPane.getLineStartOffset(n2);
        int n4 = basicEditorPane.getLineStartOffset(n2 + 1);
        String string = null;
        try {
            string = basicEditorPane.getText(n3, n4 - n3);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return stringBuffer.toString();
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    @Override
    protected Replacements runProgram(int n, int n2, Object object) {
        Replacements replacements = new Replacements(this.text);
        this.selection = this.text.substring(n, n2);
        if (!this.parse(this.selection)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("NotSequenceOfStatements"), null, null);
            return null;
        }
        this.name = (String)object;
        if (this.name == null) {
            if (!NameProcedurePanel.askForName(this, !this.isBody && this.conn != null)) {
                return null;
            }
        } else {
            this.isLocal = true;
            this.namedArguments = true;
        }
        if (this.output == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("ProcedureExtractor.1"), null, null);
            return null;
        }
        this.extractParameters();
        String string = this.processPlsqlBlock();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = -1;
        for (String object22 : this.parameters.keySet()) {
            ++n3;
            String object4 = object22;
            if (object22.charAt(0) == ':') {
                object4 = "p_" + object22.substring(1);
            }
            stringBuffer2.append((n3 > 0 ? "," : "(") + object4 + " " + this.parameters.get(object22));
            object4 = this.namedArguments ? object4 + "=>" + object22 : object22;
            stringBuffer.append((n3 > 0 ? "," : "(") + object4);
            if (this.parameters.size() <= 2) continue;
            stringBuffer.append("\n   ");
            stringBuffer2.append("\n   ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer2.append(')');
            stringBuffer.append(')');
        }
        try {
            String string2;
            for (Integer n4 : this.defsToComment) {
                int n5 = ((LexerToken)this.src.get((int)Service.Y((int)n4.intValue()))).begin + 1;
                int n6 = ((LexerToken)this.src.get((int)Service.X((int)n4.intValue()))).begin;
                if (n5 < n6 + 4) continue;
                string2 = this.text.substring(n6, n5);
                replacements.put(n6, n5, "/*" + string2.substring(2, string2.length() - 2) + "*/");
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            StringBuffer stringBuffer4 = new StringBuffer();
            stringBuffer3.append("procedure " + this.name + stringBuffer2.toString());
            stringBuffer4.append(" as\n");
            Object object2 = this.localVars.keySet().iterator();
            while (object2.hasNext()) {
                int n7;
                int n8;
                String string3;
                string2 = string3 = object2.next();
                if (!"".equals(this.localVars.get(string3))) {
                    string2 = string2 + " " + this.localVars.get(string3);
                }
                if (string2.contains(":=") && (n8 = string2.indexOf(":", (n7 = string2.indexOf(":=")) + 1)) > 0) {
                    string2 = string2.substring(0, n8) + "p_" + string2.substring(n8 + 1);
                }
                stringBuffer4.append("    " + string2 + ";\n");
            }
            stringBuffer4.append("begin\n" + string + "\nend;\n");
            object2 = "  ";
            if (this.p != null) {
                object2 = ProcedureExtractor.indent(n, this.p);
            }
            String string4 = (String)object2 + this.name + stringBuffer.toString() + ";\n";
            if (this.text != null || this.src.size() == this.fragment.size()) {
                string4 = "begin\np_" + string4 + "end;\n";
            }
            if (!(this.isBody || this.isLocal || ProcedureExtractor.storeProcDefinition(this.conn, stringBuffer3.toString() + stringBuffer4.toString()))) {
                return null;
            }
            int n9 = this.calculateInsertPosition();
            replacements.put(n, n2, string4);
            if (this.isBody || this.isLocal) {
                replacements.put(n9, n9, "\n-- refactored\n" + stringBuffer3.toString() + stringBuffer4.toString() + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return replacements;
    }

    public static class Pieces {
        public String pkg_name;
        public String input;
        public String header;
        public String body;
        public String call;
    }
}

