/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.refactor.Extractor;
import oracle.dbtools.raptor.refactor.Inliner;
import oracle.dbtools.raptor.refactor.UndoableRefactoring;
import oracle.dbtools.util.Service;

public class RegressionTest {
    static Integer singleTest = null;
    private static int maxTestNo = 0;
    private static int total = 0;
    private static Set<Integer> failedTests = new TreeSet<Integer>();
    static Set<RuleTuple> rules = RegressionTest.insightRules();
    static Earley earley = new Earley(rules){

        protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
            LexerToken lexerToken = list.get(n);
            return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING || n2 == this.identifier && lexerToken.type == Token.BQUOTED_STRING;
        }
    };
    private static int output = (Integer)RegressionTest.earley.symbolIndexes.get("output");
    private static int oper = (Integer)RegressionTest.earley.symbolIndexes.get("oper");
    private static int assertion = (Integer)RegressionTest.earley.symbolIndexes.get("assertion");
    private static int query = (Integer)RegressionTest.earley.symbolIndexes.get("query");
    private static int comment = (Integer)RegressionTest.earley.symbolIndexes.get("comment");
    private static int marker = (Integer)RegressionTest.earley.symbolIndexes.get("marker");
    private static int prompt = (Integer)RegressionTest.earley.symbolIndexes.get("prompt");
    private static int line = (Integer)RegressionTest.earley.symbolIndexes.get("line");
    private static int comma = (Integer)RegressionTest.earley.symbolIndexes.get("','");
    private static int sql_fragment = (Integer)RegressionTest.earley.symbolIndexes.get("sql_fragment");

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(RegressionTest.class, (String)"regression.test");
        List list = LexerToken.parse((String)string, (String)"`#");
        Matrix matrix = new Matrix((Parser)earley);
        Visual visual = null;
        if (list.size() < 100) {
            visual = new Visual(list, (Parser)earley);
        }
        earley.parse(list, (Matriceable)matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)earley, (Matrix)matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw((Matriceable)matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        long l = System.currentTimeMillis();
        RegressionTest.atest(parseNode, list, string);
        long l2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (l2 - l));
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + total + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> " + failedTests.toString());
        }
    }

    private static Set<RuleTuple> insightRules() {
        try {
            String string = Service.readFile(RegressionTest.class, (String)"test.grammar");
            List list = LexerToken.parse((String)string, (boolean)false, (int)1);
            ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
            return treeSet;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"VT: failed to init grammar for refactor test");
        }
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            ++total;
            System.out.print("TEST#" + maxTestNo + " -> ");
            if (RegressionTest.assertion(parseNode, list, string, maxTestNo)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
                failedTests.add(maxTestNo);
            }
            return;
        }
        if (parseNode.contains(output)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            ++total;
            String string2 = null;
            ParseNode parseNode2 = null;
            for (ParseNode parseNode3 : parseNode.children()) {
                if (parseNode3.contains(oper)) {
                    string2 = parseNode3.content(list);
                    break;
                }
                if (!parseNode3.contains(query)) continue;
                parseNode2 = parseNode3;
            }
            System.out.println("TEST#" + maxTestNo + " ->\n" + RegressionTest.query(parseNode2, list, string, string2).output());
            return;
        }
        if (parseNode.contains(comment)) {
            RegressionTest.comment(parseNode, list, string);
            return;
        }
        for (ParseNode parseNode4 : parseNode.children()) {
            RegressionTest.atest(parseNode4, list, string);
        }
    }

    private static boolean assertion(ParseNode parseNode, List<LexerToken> list, String string, int n) {
        Replacements replacements = null;
        Object object = null;
        String string2 = null;
        ParseNode parseNode2 = null;
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode3.contains(query)) {
                parseNode2 = parseNode3;
                continue;
            }
            if (parseNode3.contains(oper)) {
                string2 = parseNode3.content(list);
                continue;
            }
            if (!parseNode3.contains(prompt)) continue;
            object = RegressionTest.prompt(parseNode3, list, string);
        }
        replacements = RegressionTest.query(parseNode2, list, string, string2);
        if (!replacements.equals(object)) {
            System.out.println(replacements.diff(object));
            return false;
        }
        return true;
    }

    private static Object prompt(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.contains("identifier")) {
            return parseNode.content(list);
        }
        Replacements replacements = new Replacements("0123456789012345");
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (!parseNode2.contains(line)) continue;
            RegressionTest.line(parseNode2, list, string, replacements);
        }
        return replacements;
    }

    private static void line(ParseNode parseNode, List<LexerToken> list, String string, Replacements replacements) {
        Integer n = null;
        Integer n2 = null;
        String string2 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (n == null) {
                n = Integer.parseInt(parseNode2.content(list));
                continue;
            }
            if (parseNode2.contains(comma)) continue;
            if (n2 == null) {
                n2 = Integer.parseInt(parseNode2.content(list));
                continue;
            }
            if (string2 != null) continue;
            string2 = parseNode2.content(list);
        }
        if (string2.startsWith("`")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        replacements.put(n.intValue(), n2.intValue(), string2);
    }

    private static Replacements query(ParseNode parseNode, List<LexerToken> list, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        int n2 = -1;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(marker)) {
                if (n == -1) {
                    n = stringBuilder.length();
                } else {
                    n2 = stringBuilder.length();
                }
            }
            if (!parseNode2.contains(sql_fragment)) continue;
            stringBuilder.append(RegressionTest.sql_fragment(parseNode2, list, string));
        }
        if (n2 == -1) {
            n2 = n;
        }
        String string3 = stringBuilder.toString();
        if ("inline".equalsIgnoreCase(string2)) {
            return RegressionTest.output(string3, n, n2, Inliner.class, Boolean.TRUE);
        }
        if ("extract".equalsIgnoreCase(string2)) {
            return RegressionTest.output(string3, n, n2, Extractor.class, "newName");
        }
        if ("toggleJoin".equalsIgnoreCase(string2)) {
            return RegressionTest.toggleJoin(string3);
        }
        throw new AssertionError((Object)("operation " + string2 + " not recognized"));
    }

    private static Replacements output(String string, int n, int n2, Class clazz, Object object) {
        List list = LexerToken.parse((String)string);
        ParseNode parseNode = SqlEarley.getInstance().parse(list);
        try {
            Field field;
            Constructor constructor = clazz.getConstructor(String.class, List.class, ParseNode.class);
            Object t = constructor.newInstance(string, list, parseNode);
            if (null != singleTest) {
                try {
                    field = clazz.getDeclaredField("debug");
                    field.setAccessible(true);
                    field.setBoolean(t, true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            field = ((UndoableRefactoring)((Object)t)).runProgram(n, n2, object);
            return field;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    private static Replacements toggleJoin(String string) {
        Replacements replacements = new Replacements(string);
        return replacements;
    }

    private static String sql_fragment(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.from + 1 == parseNode.to) {
            String string2 = list.get((int)parseNode.from).content;
            if (string2.charAt(0) == '\"' || string2.charAt(0) == '`') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        String string3 = "";
        for (ParseNode parseNode2 : parseNode.children()) {
            string3 = string3 + RegressionTest.sql_fragment(parseNode2, list, string);
        }
        return string3.replace(". ", ".").replace(" .", ".");
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = string.substring(list.get((int)(parseNode.from + 1)).begin, list.get((int)(parseNode.to - 1)).end - 1);
        int n = Integer.parseInt(string2);
        if (maxTestNo < n) {
            maxTestNo = n;
        }
        if (singleTest != null && singleTest != n) {
            return null;
        }
        return null;
    }
}

