/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.URLFileChooserPaths;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBox;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBoxLoader;
import oracle.dbtools.raptor.utils.URLChooserShortcuts;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserAdapter;
import oracle.ide.net.URLChooserEvent;
import oracle.ide.net.URLChooserListener;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.NetArb;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class URLFileChooser
extends URLChooser {
    private static final long serialVersionUID = 1L;
    private boolean checkIfFileExists;
    private int _trackSelectionScope = -1;
    private URL lastApprovedURL;
    private boolean showEncodings;
    private String encodingsString = Messages.getString("FilePanelAcc.1");
    public static final String ENCODINGS_TIP = Messages.getString("FilePanelAcc.0");
    private JLabel encodingsLabel = new JLabel();
    private JComboBox encodingsCombo;
    private static List<Object> _encodings;
    private static final JFileChooser _jFileChooser;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    private static final int INTERNAL_SELECTION = -1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private boolean selectedURLSet;
    private URL selectedURL;
    private URLChooserAdapter _adjustFileNameAdapter = new URLChooserAdapter(){

        public void listSelectionChanged(URLChooserEvent uRLChooserEvent) {
        }

        public void urlFilterChanged(URLChooserEvent uRLChooserEvent) {
            URLFileChooser.this.adjustFileNameURL(uRLChooserEvent.getCurrentFilter(), true);
        }
    };
    private URLFileChooserPaths.URLFileChooserPathContext pathContext;
    private URLFileChooserPaths.URLFileChooserPathContext defaultPathContext;
    private boolean firingActionEvent;
    public static String URL_SELECTED;

    public URLFileChooser() {
        this((URL)null);
    }

    public URLFileChooser(URL uRL) {
        this(null, uRL);
    }

    public URLFileChooser(URL[] uRLArray, URL uRL) {
        this(uRLArray, uRL, Context.newIdeContext());
    }

    public URLFileChooser(Context context) {
        this(null, null, context);
    }

    private URLFileChooser(URL[] uRLArray, URL uRL, Context context) {
        super(uRLArray, uRL);
        this.setSelectionScope(0);
        DialogUtil.initURLChooser((URLChooser)this, (Context)context);
        this.selectedURLSet = uRL != null;
        this.setDefaultPathContext("DEFAULT_CONTEXT");
    }

    public int showOpenDialog(Component component) {
        return this.showOpenDialog(component, null);
    }

    public int showOpenDialog(Component component, String string) {
        return this.showOpenDialog(component, (Traversable)this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showOpenDialog(Component component, Traversable traversable, String string) {
        int n = -1;
        try {
            this.setContextShortcuts();
            n = super.showOpenDialog(component, traversable, string);
            if (0 == n) {
                File file;
                this.setSelectedURL(super.getSelectedURL());
                if (this.checkIfFileExists() && (null == (file = this.getSelectedFile()) || !file.exists())) {
                    n = -1;
                    MessageDialog.information((Component)((Object)this), (Object)Messages.getString("URLFileChooser.FileNotFound"), (String)string, null);
                }
                this.trackApproved(0, string);
            }
        }
        finally {
            this.resetContextShortcuts();
        }
        return n;
    }

    private void setContextShortcuts() {
        URLChooserShortcuts.getInstance().setPathContext(this.getPathContextKey());
        DialogUtil.addShortcutButtons((URLChooser)this, (Context)Context.newIdeContext());
    }

    private void resetContextShortcuts() {
        URLChooserShortcuts.getInstance().setPathContext(null);
        DialogUtil.addShortcutButtons((URLChooser)this, (Context)Context.newIdeContext());
    }

    public void setCheckIfFileExists(boolean bl) {
        this.checkIfFileExists = bl;
    }

    public boolean checkIfFileExists() {
        return this.checkIfFileExists;
    }

    public int getSelectionScope() {
        return this._trackSelectionScope;
    }

    public void setSelectionScope(int n) {
        super.setSelectionScope(n);
        this._trackSelectionScope = n;
    }

    private void trackApproved(int n, String string) {
        URL uRL = this.getSelectedURL();
        if (0 == this._trackSelectionScope && URLFileSystem.isDirectoryPath((URL)uRL)) {
            return;
        }
        if (uRL != this.lastApprovedURL) {
            this.lastApprovedURL = uRL;
            if (uRL != null) {
                if (this.getPathContextPaths() != null) {
                    this.addPathContextPath(uRL);
                } else {
                    this.addDefaultPathContextPath(uRL);
                }
            }
        }
    }

    private String getChooserTitle(int n, String string) {
        String string2;
        if (string != null) {
            return string;
        }
        switch (n) {
            case 0: {
                if (this._trackSelectionScope == 0 || this._trackSelectionScope == 2) {
                    string2 = NetArb.getString((int)15);
                    break;
                }
                string2 = NetArb.getString((int)17);
                break;
            }
            default: {
                string2 = this._trackSelectionScope == 0 ? NetArb.getString((int)19) : NetArb.getString((int)17);
            }
        }
        return string2;
    }

    public int showSaveDialog(Component component) {
        return this.showSaveDialog(component, null);
    }

    public int showSaveDialog(Component component, String string) {
        return this.showSaveDialog(component, (Traversable)this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showSaveDialog(Component component, Traversable traversable, String string) {
        int n = -1;
        URL uRL = this.getSelectedURL();
        boolean bl = this.getShowJarsAsDirs();
        try {
            this.setContextShortcuts();
            this.setShowJarsAsDirs(false);
            this.setSelectedURL(uRL);
            if (this._trackSelectionScope == 0) {
                this.addURLChooserListener((URLChooserListener)this._adjustFileNameAdapter);
            }
            n = super.showSaveDialog(component, traversable, string);
            if (this._trackSelectionScope == 0) {
                this.adjustSelectedURL();
            }
            if (0 == n) {
                this.setSelectedURL(super.getSelectedURL());
                uRL = this.getSelectedURL();
                this.trackApproved(1, string);
            }
        }
        finally {
            this.resetContextShortcuts();
            this.setShowJarsAsDirs(bl);
            this.setSelectedURL(uRL);
        }
        return n;
    }

    public void showEncodings(boolean bl) {
        if (bl == this.showEncodings) {
            return;
        }
        if (this.showEncodings) {
            if (this.encodingsCombo != null) {
                this.remove(this.encodingsLabel);
                this.remove(this.encodingsCombo);
                this.changeShortcutBarHeight(4, 3);
                this.validate();
            }
        } else {
            if (null == this.encodingsCombo) {
                this.encodingsCombo = this.createEncodingsCombo(this.encodingsLabel);
            }
            Insets insets = new Insets(5, 5, 5, 0);
            this.add(this.encodingsLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add(this.encodingsCombo, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
            this.changeShortcutBarHeight(3, 4);
            this.validate();
        }
        this.showEncodings = bl;
    }

    public void encodingsStripMnemonic() {
        this.encodingsString = StringUtils.stripMnemonic((String)this.encodingsString);
    }

    JComboBox createEncodingsCombo(JLabel jLabel) {
        DelayedLoadingComboBox delayedLoadingComboBox = new DelayedLoadingComboBox(this.encodingsString, IdeUtil.getIdeEncoding(), new DelayedLoadingComboBoxLoader(){

            @Override
            public List<Object> getComboContents() throws TaskException {
                if (null == _encodings) {
                    _encodings = Arrays.asList((Object[])Encodings.getEncodings());
                }
                return _encodings;
            }
        });
        ResourceUtils.resLabel((JLabel)jLabel, (Component)delayedLoadingComboBox, (String)this.encodingsString);
        jLabel.setToolTipText(ENCODINGS_TIP);
        return delayedLoadingComboBox;
    }

    private void changeShortcutBarHeight(int n, int n2) {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        for (Component component : this.getComponents()) {
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(component);
            if (gridBagConstraints.gridheight != n) continue;
            gridBagConstraints.gridheight = n2;
            this.remove(component);
            this.add(component, gridBagConstraints);
            break;
        }
    }

    public String getEncoding() {
        if (!this.showEncodings || null == this.encodingsCombo) {
            return IdeUtil.getIdeEncoding();
        }
        return this.encodingsCombo.getSelectedItem().toString();
    }

    public void setEncoding(String string) {
        this.showEncodings(true);
        this.encodingsCombo.setSelectedItem(string);
    }

    private File toFile(URL uRL) {
        URI uRI = this.toURI(uRL);
        return null == uRI ? null : new File(uRI);
    }

    private URI toURI(URL uRL) {
        String string = uRL.getPath();
        try {
            string = URLDecoder.decode(uRL.getPath(), System.getProperty("file.encoding"));
        }
        catch (Throwable throwable) {
            Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)throwable);
        }
        URI uRI = null;
        try {
            uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), string, uRL.getQuery(), uRL.getRef());
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
        return uRI;
    }

    public URLFileChooser(File file) {
        this();
        this.setCurrentDirectory(file);
    }

    public File getCurrentDirectory() {
        URL uRL = this.getSelectedURL();
        if (null == uRL) {
            return null;
        }
        File file = this.toFile(uRL);
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        return file;
    }

    public void setCurrentDirectory(File file) {
        _jFileChooser.setCurrentDirectory(file);
        File file2 = _jFileChooser.getCurrentDirectory();
        try {
            this.setSelectedURL(file2.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)malformedURLException);
        }
    }

    public File getSelectedFile() {
        Object object;
        URL uRL = this.getSelectedURL();
        if (uRL == null) {
            object = this.getFileNameURL();
            try {
                uRL = new URL((String)object);
            }
            catch (Exception exception) {
                Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }
        if (null == uRL) {
            return null;
        }
        object = this.toFile(uRL);
        return object;
    }

    public URL getSelectedURL() {
        return this.selectedURL;
    }

    protected URL superGetSelectedURL() {
        return super.getSelectedURL();
    }

    public boolean approveSelection() {
        return super.approveSelection();
    }

    public void setSelectedFile(File file) {
        try {
            this.setSelectedURL(file == null ? null : file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)malformedURLException);
        }
    }

    public void setSelectedURL(URL uRL) {
        super.setSelectedURL(uRL);
        boolean bl = this.selectedURLSet = uRL != null;
        if (ModelUtil.areDifferent((Object)this.selectedURL, (Object)uRL)) {
            this.selectedURL = uRL;
            this.trackApproved(-1, URL_SELECTED);
            this.fireActionEvent();
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        if (fileFilter != null) {
            this.setURLFilter(new FileFilterURLWrapper(fileFilter));
        }
    }

    public void setURLFilter(URLFilter uRLFilter) {
        super.setURLFilter(uRLFilter);
        if (uRLFilter != null) {
            this.setCurrentDirectoryFromPathContext();
        }
    }

    public void setFileSelectionMode(int n) {
        this.setSelectionScope(n);
    }

    private String getDefaultExtension(URLFilter uRLFilter) {
        String string = "";
        String string2 = uRLFilter.toString();
        int n = string2.indexOf("*");
        int n2 = string2.indexOf(",");
        if (n != -1) {
            n2 = n2 != -1 ? n2 : string2.indexOf(")");
            string = string2.substring(n + 1, n2);
            string = string.equals(".*") ? "" : string;
        }
        return string;
    }

    private void adjustFileNameURL(URLFilter uRLFilter, boolean bl) {
        if (null == uRLFilter) {
            return;
        }
        String string = this.getFileNameURL();
        int n = string.lastIndexOf(".");
        String string2 = this.getDefaultExtension(uRLFilter);
        if (n != -1 && bl && !string2.equals("") && (string = string.substring(0, n)).endsWith(string2)) {
            this.setFileNameURL(string);
            return;
        }
        this.setFileNameURL(string + string2);
    }

    private void adjustSelectedURL() {
        URL[] uRLArray = this.getSelectedURLs();
        if (uRLArray.length == 0) {
            return;
        }
        if (this.getSelectedFilter() == null) {
            return;
        }
        if (this.getSelectedFilter().accept(uRLArray[0])) {
            return;
        }
        this.adjustFileNameURL(this.getSelectedFilter(), false);
        boolean bl = this.approveSelection();
        if (!bl) {
            URLFileChooserException uRLFileChooserException = new URLFileChooserException("approveSelection failed for " + this.getSelectedURL());
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)uRLFileChooserException);
            throw uRLFileChooserException;
        }
    }

    public static URLFileChooserPanel createURLFileChooserPanel() {
        return new URLFileChooserPanel();
    }

    public static URLFileChooserPanel createURLFileChooserPanel(int n, String string) {
        return new URLFileChooserPanel(n, string);
    }

    public static URLFileChooserPanel createURLFileChooserPanel(int n, String string, boolean bl) {
        return new URLFileChooserPanel(n, string, bl);
    }

    public static URLFileChooserPanel createURLFileChooserPanel(int n, String string, boolean bl, boolean bl2) {
        return new URLFileChooserPanel(n, string, bl, bl2);
    }

    public static URLFileChooserPanel createURLFileChooserPanel(int n, String string, String string2, boolean bl, boolean bl2) {
        return new URLFileChooserPanel(n, string, string2, bl, bl2);
    }

    public static URLFileChooserPanel createURLFileChooserPanel(int n, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        return new URLFileChooserPanel(n, string, string2, bl, bl2, null, bl3);
    }

    public static URLFileChooserPanel createURLFileChooserPanel(int n, String string, String string2, boolean bl, boolean bl2, String string3) {
        return new URLFileChooserPanel(n, string, string2, bl, bl2, string3, true);
    }

    public void setPathContext(String string) {
        this.pathContext = DBConfig.getInstance().getURLFileChooserPaths().getPathContext(string);
        this.setCurrentDirectoryFromPathContext();
    }

    public String getText() {
        File file = this.getSelectedFile();
        return null == file ? "" : file.getAbsolutePath();
    }

    private void setCurrentDirectoryFromPathContext() {
        if (this.selectedURLSet) {
            return;
        }
        if (this.setToFirstContextPathDirectory(this.getPathContextPaths())) {
            return;
        }
        if (this.setToFirstContextPathDirectory(this.getDefaultPathContextPaths())) {
            return;
        }
        this.setToUserHomeDirectory();
        this.selectedURLSet = false;
    }

    private boolean setToFirstContextPathDirectory(URLPath uRLPath) {
        boolean bl = false;
        if (uRLPath != null) {
            for (URL uRL : uRLPath.getEntries()) {
                if (null != this.getSelectedFilter() && !this.accept(uRL)) continue;
                if ("file".equals(uRL.getProtocol())) {
                    this.setCurrentDirectory(this.toFile(uRL));
                } else {
                    this.setSelectedURL(uRL);
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void setToUserHomeDirectory() {
        String string = Ide.getTrueUserHomeDirectory();
        if (string != null && string.length() > 0) {
            this.setSelectedURL(URLFactory.newDirURL((String)string));
        }
    }

    private URLPath getPathContextPaths() {
        return null == this.pathContext ? null : this.pathContext.getURLPath();
    }

    private String getPathContextKey() {
        return null == this.pathContext ? null : this.pathContext.getKey();
    }

    private void addPathContextPath(URL uRL) {
        if (null == this.pathContext) {
            return;
        }
        this.pathContext.add(uRL);
    }

    private void setDefaultPathContext(String string) {
        this.defaultPathContext = DBConfig.getInstance().getURLFileChooserPaths().getPathContext(string);
        this.setCurrentDirectoryFromPathContext();
    }

    private URLPath getDefaultPathContextPaths() {
        return null == this.defaultPathContext ? null : this.defaultPathContext.getURLPath();
    }

    private void addDefaultPathContextPath(URL uRL) {
        if (null == this.defaultPathContext) {
            return;
        }
        this.defaultPathContext.add(uRL);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent actionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            long l = EventQueue.getMostRecentEventTime();
            int n = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n = ((ActionEvent)aWTEvent).getModifiers();
            }
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ActionListener.class) continue;
                if (actionEvent == null) {
                    actionEvent = new ActionEvent((Object)this, 1001, URL_SELECTED, l, n);
                }
                ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
            }
            this.firingActionEvent = false;
        }
    }

    static {
        _jFileChooser = new JFileChooser();
        URL_SELECTED = "url_selected";
    }

    private static class ExtendedURLTextField
    extends URLTextField
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;
        private int _selectionScope;
        private String nullValueText;

        public ExtendedURLTextField(URL uRL, boolean bl, boolean bl2, int n) {
            super(uRL, bl, bl2);
            this._selectionScope = n;
        }

        public void setSelectionScope(int n) {
            this._selectionScope = n;
            this.setDirectoryOnly(1 == n);
        }

        protected boolean isTextValid() {
            if (!this.isValidateExistingFile()) {
                return true;
            }
            File file = new File(this.getText().trim());
            if (this.isOnlyDirectories()) {
                return file.isDirectory();
            }
            if (0 == this._selectionScope) {
                return file.exists() && !file.isDirectory();
            }
            return file.exists();
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object object) {
            URL uRL;
            URL uRL2 = uRL = URLFileChooserPanel.NULL_SELECTION == object ? null : (URL)object;
            if (0 == this._selectionScope && URLFileSystem.isDirectoryPath((URL)uRL)) {
                return;
            }
            this.setURL(uRL);
        }

        @Override
        public Object getItem() {
            URL uRL = this.getURL();
            if (null == uRL) {
                if (null == this.getText() || this.getText().isEmpty()) {
                    return URLFileChooserPanel.NULL_SELECTION;
                }
                try {
                    File file = new File(this.getText());
                    if (file != null) {
                        uRL = file.toURI().toURL();
                    }
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                    return URLFileChooserPanel.NULL_SELECTION;
                }
            }
            return uRL;
        }

        public void setNullValueText(String string) {
            this.nullValueText = string;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if ((null == this.getText() || this.getText().isEmpty()) && this.nullValueText != null) {
                int n = this.getHeight();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                Insets insets = this.getInsets();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n2 = this.getBackground().getRGB();
                int n3 = this.getForeground().getRGB();
                int n4 = -16843010;
                int n5 = ((n2 & n4) >>> 1) + ((n3 & n4) >>> 1);
                graphics.setColor(new Color(n5, true));
                graphics.drawString(this.nullValueText, insets.left, n / 2 + fontMetrics.getAscent() / 2 - 2);
            }
        }
    }

    public static class URLFileChooserPanel
    extends JPanel
    implements LayoutControl {
        private static final long serialVersionUID = 1L;
        private URLFileChooser chooser = new URLFileChooser();
        private ComponentAdapter _componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                try {
                    uiTextCombo.setSelectedItem(this.getSelectedURL());
                }
                catch (Exception exception) {
                    Logger.ignore(this.getClass(), (Throwable)exception);
                }
            }
        };
        private String labelText;
        private int chooserType;
        private boolean showLabel;
        private boolean showMnemonics = true;
        private boolean showUIButton = true;
        private String dialogTitle;
        private ExtendedURLTextField uiText = null;
        private JLabel uiLabel = new JLabel();
        private JComboBox<URL> uiTextCombo;
        private JButton uiButton = new JButton();
        private String chooserButtonString = Messages.getString("FilePanel.1");
        private JLabel uiEncLabel = new JLabel();
        private JComboBox uiEncCombo;
        private static int MAX_URL_COMBOBOX_COUNT = 10;
        private boolean allowNullSelection = true;
        private static final URL NULL_SELECTION = URLFactory.newDirURL((String)"/NULL_SELECTION");
        private String nullSelectionText = Messages.getString("URLFileChooser.NullSelectionText");

        public URLFileChooserPanel() {
            this(0, null);
        }

        public URLFileChooserPanel(int n, String string) {
            this(n, string, true);
        }

        public URLFileChooserPanel(int n, String string, boolean bl) {
            this(n, string, bl, false);
        }

        public URLFileChooserPanel(int n, String string, boolean bl, boolean bl2) {
            this(n, string, null, bl, bl2);
        }

        public URLFileChooserPanel(int n, String string, String string2, boolean bl, boolean bl2) {
            this(n, string, string2, bl, bl2, null, true);
        }

        public URLFileChooserPanel(int n, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
            this(n, string, string2, bl, bl2, null, bl3);
        }

        public URLFileChooserPanel(int n, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3) {
            this.showLabel = bl;
            this.showMnemonics = bl2;
            this.showUIButton = bl3;
            this.chooserType = n;
            this.labelText = string;
            this.dialogTitle = string2;
            if (string3 != null) {
                this.chooserButtonString = string3;
            }
            this.initUI();
        }

        private void initUI() {
            if (null == this.labelText) {
                this.labelText = this.chooser.getChooserTitle(this.chooserType, null);
            }
            this.uiLabel.setVisible(this.showLabel);
            if (this.dialogTitle == null) {
                this.dialogTitle = StringUtils.stripMnemonic((String)this.labelText);
            }
            if (!this.showMnemonics) {
                this.chooser.encodingsStripMnemonic();
                this.chooserButtonString = StringUtils.stripMnemonic((String)this.chooserButtonString);
                this.labelText = StringUtils.stripMnemonic((String)this.labelText);
            }
            this.uiEncCombo = this.chooser.createEncodingsCombo(this.uiEncLabel);
            this.uiButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.browseForURL();
                }
            });
            this.uiEncLabel.setVisible(false);
            this.uiEncCombo.setVisible(false);
            this.chooser.showEncodings(false);
            this.uiText = new ExtendedURLTextField(null, false, false, this.chooser.getSelectionScope());
            this.uiText.setNullValueText(this.nullSelectionText);
            this.uiTextCombo = this.createURLCombo(this.uiLabel);
            this.uiTextCombo.addActionListener(actionEvent -> {
                URL uRL = (URL)this.uiTextCombo.getSelectedItem();
                if (NULL_SELECTION == uRL) {
                    uRL = null;
                }
                this.setSelectedURL(uRL);
            });
            this.uiTextCombo.addComponentListener(this._componentListener);
            ResourceUtils.resLabel((JLabel)this.uiLabel, this.uiTextCombo, (String)this.labelText);
            ResourceUtils.resButton((AbstractButton)this.uiButton, (String)this.chooserButtonString);
            this.uiButton.setVisible(this.showUIButton);
            this.setLayout(new GridBagLayout());
            int n = 0;
            if (this.uiLabel.isVisible()) {
                this.add((Component)this.uiLabel, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.NONE));
                this.add(this.uiTextCombo, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
                this.add((Component)this.uiButton, LayoutControl.GBC.gbc(2, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
            } else {
                this.add(this.uiTextCombo, LayoutControl.GBC.gbc(0, n, 2, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
                this.add((Component)this.uiButton, LayoutControl.GBC.gbc(2, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
            }
            this.add((Component)this.uiEncLabel, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
            this.add((Component)this.uiEncCombo, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X));
        }

        private void browseForURL() {
            int n;
            URL uRL;
            if (this.uiEncCombo.isVisible()) {
                this.chooser.setEncoding((String)this.uiEncCombo.getSelectedItem());
            }
            if (null == (uRL = this.getSelectedURL())) {
                this.chooser.setCurrentDirectoryFromPathContext();
            }
            if (0 == (n = 0 == this.chooserType ? this.chooser.showOpenDialog(this, this.dialogTitle) : this.chooser.showSaveDialog(this, this.dialogTitle))) {
                this.uiTextCombo.setSelectedItem(this.chooser.getSelectedURL());
                this.uiEncCombo.setSelectedItem(this.chooser.getEncoding());
            } else {
                this.chooser.setSelectedURL(uRL);
            }
        }

        public void showEncodings(boolean bl) {
            this.chooser.showEncodings(bl);
            this.uiEncLabel.setVisible(bl);
            this.uiEncCombo.setVisible(bl);
            this.validate();
        }

        public String getEncoding() {
            return this.uiEncCombo.getSelectedItem().toString();
        }

        public void setEncoding(String string) {
            this.chooser.setEncoding(string);
            this.uiEncCombo.setSelectedItem(string);
        }

        public File getCurrentDirectory() {
            return this.chooser.getCurrentDirectory();
        }

        public void setCurrentDirectory(File file) {
            this.chooser.setCurrentDirectory(file);
            this.uiTextCombo.setSelectedItem(this.chooser.getSelectedURL());
        }

        public File getSelectedFile() {
            return this.chooser.getSelectedFile();
        }

        public void setSelectedFile(File file) {
            try {
                this.setSelectedURL(file == null ? null : file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Logger.warn(this.getClass(), (Throwable)malformedURLException);
            }
        }

        public String getText() {
            return this.chooser.getText();
        }

        public void setText(String string) {
            this.setSelectedFile(string != null && !string.isEmpty() ? new File(string) : null);
        }

        public void setFileFilter(FileFilter fileFilter) {
            this.chooser.setFileFilter(fileFilter);
        }

        public void setFileSelectionMode(int n) {
            this.chooser.setFileSelectionMode(n);
        }

        public void addChooseableURLFilter(URLFilter uRLFilter) {
            this.chooser.addChooseableURLFilter(uRLFilter);
        }

        public void clearChooseableURLFilters() {
            this.chooser.clearChooseableURLFilters();
        }

        public URL getSelectedURL() {
            return this.chooser.getSelectedURL();
        }

        public void setSelectionMode(int n) {
            this.chooser.setSelectionMode(n);
        }

        public void setSelectedURL(URL uRL) {
            this.chooser.setSelectedURL(uRL);
            this.uiTextCombo.setSelectedItem(uRL);
            this.uiText.setItem(uRL);
        }

        public void setSelectionScope(int n) {
            this.chooser.setSelectionScope(n);
            this.uiText.setSelectionScope(n);
        }

        public void setURLFilter(URLFilter uRLFilter) {
            this.chooser.setURLFilter(uRLFilter);
        }

        public void addURLChooserListener(URLChooserAdapter uRLChooserAdapter) {
            this.chooser.addURLChooserListener((URLChooserListener)uRLChooserAdapter);
        }

        public void removeURLChooserListener(URLChooserAdapter uRLChooserAdapter) {
            this.chooser.removeURLChooserListener((URLChooserListener)uRLChooserAdapter);
        }

        public void setCheckIfFileExists(boolean bl) {
            this.chooser.setCheckIfFileExists(bl);
            this.uiText.setValidateExistingFile(bl);
        }

        public void setShowJarsAsDirs(boolean bl) {
            this.chooser.setShowJarsAsDirs(bl);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.uiLabel.setEnabled(bl);
            this.uiText.setEnabled(bl);
            this.uiTextCombo.setEnabled(bl);
            this.uiButton.setEnabled(bl);
            this.uiEncLabel.setEnabled(bl);
            this.uiEncCombo.setEnabled(bl);
        }

        private JComboBox<URL> createURLCombo(JLabel jLabel) {
            URLPath uRLPath = new URLPath(this.getSelectedURL());
            JComboBox<URL> jComboBox = new JComboBox<URL>(uRLPath.getEntries());
            jComboBox.setEditor(this.uiText);
            jComboBox.setEditable(true);
            jComboBox.setMaximumRowCount(10);
            jComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = String.valueOf(object);
                    if (object instanceof URL) {
                        string = NULL_SELECTION == object ? this.getNullSelectionText() : URLFileSystem.getPlatformPathName((URL)((URL)object));
                    }
                    return super.getListCellRendererComponent(jList, string, n, bl, bl2);
                }
            });
            jComboBox.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    URL uRL = (URL)uiTextCombo.getSelectedItem();
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    URLPath uRLPath = chooser.getPathContextPaths();
                    if (uRLPath != null) {
                        for (URL uRL2 : uRLPath.asList()) {
                            if (!this.accept(uRL2) || arrayList.contains(uRL2)) continue;
                            arrayList.add(uRL2);
                        }
                    }
                    if ((uRLPath = chooser.getDefaultPathContextPaths()) != null) {
                        for (URL uRL2 : uRLPath.asList()) {
                            if (!this.accept(uRL2) || arrayList.contains(uRL2)) continue;
                            arrayList.add(uRL2);
                        }
                    }
                    if (this.isAllowNullSelection()) {
                        arrayList.add(0, NULL_SELECTION);
                    }
                    if (uRL != null && this.accept(uRL) && !arrayList.contains(uRL)) {
                        arrayList.add(0, uRL);
                    }
                    if (arrayList.size() > MAX_URL_COMBOBOX_COUNT) {
                        arrayList.subList(MAX_URL_COMBOBOX_COUNT - 1, arrayList.size()).clear();
                    }
                    DefaultComboBoxModel<URL> defaultComboBoxModel = new DefaultComboBoxModel<URL>(arrayList.toArray(new URL[0]));
                    uiTextCombo.setModel(defaultComboBoxModel);
                    int n = Math.max(-1, defaultComboBoxModel.getIndexOf(uRL));
                    if (n < 0) {
                        uiTextCombo.setSelectedItem(uRL);
                    } else {
                        uiTextCombo.setSelectedIndex(n);
                    }
                }

                private boolean accept(URL uRL) {
                    boolean bl = chooser.accept(uRL);
                    if (bl) {
                        if (0 == chooser.getSelectionScope()) {
                            if (URLFileSystem.isDirectoryPath((URL)uRL)) {
                                bl = false;
                            }
                        } else if (1 == chooser.getSelectionScope() && !URLFileSystem.isDirectoryPath((URL)uRL)) {
                            bl = false;
                        }
                    }
                    return bl;
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
            ResourceUtils.resLabel((JLabel)jLabel, jComboBox, (String)this.labelText);
            return jComboBox;
        }

        public void setPathContext(String string) {
            this.chooser.setPathContext(string);
            this.uiTextCombo.setSelectedItem(this.getSelectedURL());
        }

        public void addActionListener(ActionListener actionListener) {
            this.chooser.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.chooser.removeActionListener(actionListener);
        }

        public ActionListener[] getActionListeners() {
            return this.chooser.getActionListeners();
        }

        public void setAllowNullSelection(boolean bl) {
            this.allowNullSelection = bl;
            if (this.allowNullSelection) {
                this.uiText.setNullValueText(this.nullSelectionText);
            } else {
                this.uiText.setNullValueText(null);
            }
        }

        public boolean isAllowNullSelection() {
            return this.allowNullSelection;
        }

        public void setNullSelectionText(String string) {
            this.nullSelectionText = string;
            this.uiText.setNullValueText(string);
        }

        public String getNullSelectionText() {
            return this.nullSelectionText;
        }
    }

    public static class URLFileChooserException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public URLFileChooserException() {
        }

        public URLFileChooserException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public URLFileChooserException(String string) {
            super(string);
        }

        public URLFileChooserException(Throwable throwable) {
            super(throwable);
        }
    }

    public class FileFilterURLWrapper
    implements URLFilter {
        private FileFilter _fileFilter;

        public FileFilterURLWrapper(FileFilter fileFilter) {
            assert (fileFilter != null);
            this._fileFilter = fileFilter;
        }

        public boolean accept(URL uRL) {
            if (uRL != null) {
                try {
                    File file = URLFileChooser.this.toFile(uRL);
                    return this._fileFilter.accept(file);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.warn(this.getClass(), (String)(uRL.toString() + " skipped."), (Throwable)illegalArgumentException);
                }
            }
            return false;
        }

        public boolean equals(Object object) {
            return this._fileFilter.equals(object);
        }

        public String toString() {
            return this._fileFilter.getDescription();
        }
    }
}

