/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public abstract class SearchForObjects
extends RaptorTask<ArrayList<URL>> {
    protected boolean _isCanceled = false;
    private String _filter;
    private String _connName;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private String _types;

    public SearchForObjects(String string, String string2, String string3) {
        super(ControlsArb.getString("SearchForObjects.1"), true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this._filter = string3;
        this._connName = string;
    }

    public boolean cancel() {
        this._isCanceled = true;
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<URL> doWork() {
        Object object;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("OWNER", "SYS");
        hashMap.put("OBJECT_NAME", "DBA_OBJECTS");
        DBUtil dBUtil = DBUtil.getInstance((String)this._connName);
        String string = dBUtil.executeOracleReturnOneCol("select count(1) from sys.all_objects where owner = :OWNER and object_name = :OBJECT_NAME", hashMap);
        hashMap.clear();
        hashMap.put("OBJECT_NAME", "RECYCLEBIN");
        String string2 = dBUtil.executeOracleReturnOneCol("select count(1) from sys.all_objects where object_name = :OBJECT_NAME", hashMap);
        StringBuilder stringBuilder = new StringBuilder(" select object_name,owner,object_type from ");
        StringBuilder stringBuilder2 = new StringBuilder("select db_link object_name ,owner,'DATABASE LINK' object_type from ");
        if (string.equals("0")) {
            stringBuilder.append(" sys.all_objects");
        } else {
            stringBuilder.append(" sys.dba_objects");
        }
        stringBuilder2.append(" sys.all_db_links");
        hashMap.clear();
        try {
            if (VersionTracker.checkVersion((ConnectionIdentifier)dBUtil.getConnectionIdentifier(), null, (Version)DBUtil.ORACLE10g_VERSION) && this._filter.startsWith("/") && (this._filter.endsWith("/") || this._filter.substring(this._filter.length() - 2, 1).startsWith("/"))) {
                object = null;
                if (this._filter.endsWith("i")) {
                    stringBuilder.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME,'i') ");
                    stringBuilder2.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME,'i') ");
                    object = this._filter.substring(1, this._filter.length() - 2);
                } else {
                    stringBuilder.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME) ");
                    stringBuilder2.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME) ");
                    object = this._filter.substring(1, this._filter.length() - 1);
                }
                hashMap.put("NAME", object);
                this.logger.info("Using regex:" + (String)object);
            } else {
                if (this._filter.indexOf(".") > 0) {
                    stringBuilder.append(" where owner like :OWNER");
                    stringBuilder2.append(" where owner like :OWNER");
                    stringBuilder.append(" and object_name like :NAME");
                    stringBuilder.append(" and GENERATED = 'N' ");
                    stringBuilder2.append(" and db_link like :NAME");
                    object = this._filter.split("\\.");
                    hashMap.put("OWNER", this.scrubBind(object[0]));
                    if (((Object)object).length == 2) {
                        hashMap.put("NAME", this.scrubBind((String)object[1]));
                    } else {
                        hashMap.put("NAME", "%");
                    }
                } else {
                    stringBuilder.append(" where object_name like :NAME");
                    stringBuilder2.append(" where db_link like :NAME");
                    hashMap.put("NAME", this.scrubBind(this._filter) + "%");
                }
                if (DBConfig.getInstance().getBoolean("SEARCH_AUTO_WILDCARD").booleanValue()) {
                    hashMap.put("NAME", (String)hashMap.get("NAME") + "%");
                }
            }
            if (this._types != null) {
                object = this._types.split(":");
                stringBuilder.append(" and object_type in (");
                stringBuilder2.append(" and 'DATABASE LINK' in (");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    hashMap.put("TYPE" + i, ((String)object[i]).replace("_", " "));
                    stringBuilder.append(":TYPE" + i);
                    stringBuilder2.append(":TYPE" + i);
                    if (i == ((Object)object).length - 1) continue;
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                stringBuilder.append(") ");
                stringBuilder2.append(") ");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.severe("Format number failed:" + numberFormatException.getMessage());
        }
        stringBuilder.append(" AND NOT EXISTS (SELECT 1 from all_queue_tables WHERE QUEUE_TABLE = object_name AND OWNER = owner) ");
        object = new StringBuilder("select * from ( ");
        ((StringBuilder)object).append(stringBuilder.toString());
        ((StringBuilder)object).append(" union ");
        ((StringBuilder)object).append(stringBuilder2.toString());
        ((StringBuilder)object).append(" union ");
        ((StringBuilder)object).append(" select queue_table object_name,owner, 'QUEUE TABLE' object_type from all_queue_tables where owner = :OWNER and queue_table like :NAME and 'QUEUE TABLE' in (:TYPE0) ");
        ((StringBuilder)object).append(" union ");
        ((StringBuilder)object).append(" select master object_name,log_owner, 'MATERIALIZED VIEW LOG' object_type from all_snapshot_logs where log_owner = :OWNER and master like :NAME and 'MATERIALIZED VIEW LOG' in (:TYPE0) ");
        ((StringBuilder)object).append(" ) ");
        if (string2.equals("1")) {
            ((StringBuilder)object).append(" where (object_name) not in (select object_name from recyclebin) ");
            ((StringBuilder)object).append(" AND NOT EXISTS (SELECT 1 FROM SYS.ALL_MVIEWS WHERE MVIEW_NAME = object_name AND OWNER = owner and object_type != 'MATERIALIZED VIEW') ");
        } else {
            ((StringBuilder)object).append(" where NOT EXISTS (SELECT 1 FROM SYS.ALL_MVIEWS WHERE MVIEW_NAME = object_name AND OWNER = owner and object_type != 'MATERIALIZED VIEW') ");
        }
        ((StringBuilder)object).append(" AND NOT ( object_name like 'AQ%'  and (  ");
        ((StringBuilder)object).append(" object_name != 'AQ$_'|| object_name||'_G'  ");
        ((StringBuilder)object).append(" or  object_name != 'AQ$_'|| object_name||'_H'  ");
        ((StringBuilder)object).append(" or  object_name != 'AQ$_'|| object_name||'_I' ");
        ((StringBuilder)object).append(" or  object_name != 'AQ$_'|| object_name||'_S' ");
        ((StringBuilder)object).append(" or  object_name != 'AQ$_'|| object_name||'_T' )) ");
        ((StringBuilder)object).append(" order by owner,object_name");
        if (Connections.getInstance().lock(this._connName)) {
            ResultSet resultSet = dBUtil.executeQuery(((StringBuilder)object).toString(), hashMap);
            try {
                while (resultSet.next() && !this._isCanceled) {
                    URL uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this._connName, null, resultSet.getString("OWNER"), resultSet.getString("OBJECT_TYPE")), resultSet.getString("OBJECT_NAME"));
                    if (uRL == null) continue;
                    arrayList.add(uRL);
                    if (resultSet.getRow() % 10 != 0) continue;
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(this._connName);
            }
        }
        return arrayList;
    }

    private String scrubBind(String string) {
        if (string.length() > 0 && string.charAt(0) == '\"' && string.charAt(string.length()) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public void setFilter(String string) {
        this._filter = string;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setTypes(String string) {
        this._types = string;
    }

    public String getTypes() {
        return this._types;
    }
}

