/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.javatools.buffer.LineMap;

public class AttributeLocator
extends Locator {
    public static final short STYLE_SINGLE = 0;
    public static final short STYLE_DOUBLE = 1;
    public static final short STYLE_MISSING = 2;
    public static final short USAGE_NORMAL = 0;
    public static final short USAGE_MISSING_START = 1;
    public static final short USAGE_MISSING_END = 2;
    public static final short USAGE_MISSING_BOTH = 3;
    private SimpleLocator _nameLocator = null;
    private SimpleLocator _equalsLocator = null;
    private TextLocator _valueLocator = null;
    private short _quoteStyle = (short)2;
    private short _quoteUsage = (short)3;
    private boolean _specified = true;

    @Override
    public Locator getCopy() {
        AttributeLocator ret = new AttributeLocator(this.getLineMap(), (SimpleLocator)Locator.getCopy(this._nameLocator));
        ret.setQuoteStyle(this._quoteStyle);
        ret.setQuoteUsage(this._quoteUsage);
        if (this._equalsLocator != null) {
            ret.setEqualsLocator((SimpleLocator)this._equalsLocator.getCopy());
        }
        if (this._valueLocator != null) {
            ret.setValueLocator((TextLocator)this._valueLocator.getCopy());
        }
        ret.setSpecified(this.isSpecified());
        return ret;
    }

    @Override
    public int getStartOffset() {
        return this._nameLocator.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        if (this._valueLocator != null) {
            return this._valueLocator.getEndOffset();
        }
        if (this._equalsLocator != null) {
            return this._equalsLocator.getEndOffset();
        }
        return this._nameLocator.getEndOffset();
    }

    @Override
    public void attach(LocatorManager manager, boolean attach) {
        Locator.attach(manager, attach, this._nameLocator);
        Locator.attach(manager, attach, this._equalsLocator);
        Locator.attach(manager, attach, this._valueLocator);
    }

    public SimpleLocator getNameLocator() {
        return this._nameLocator;
    }

    public void setNameLocator(SimpleLocator nameLocator) {
        this._nameLocator = nameLocator;
    }

    public TextLocator getValueLocator() {
        return this._valueLocator;
    }

    public void setValueLocator(TextLocator valueLocator) {
        this._valueLocator = valueLocator;
    }

    public SimpleLocator getEqualsLocator() {
        return this._equalsLocator;
    }

    public void setEqualsLocator(SimpleLocator equalsLocator) {
        this._equalsLocator = equalsLocator;
    }

    public short getQuoteStyle() {
        return this._quoteStyle;
    }

    public void setQuoteStyle(short quoteStyle) {
        this._quoteStyle = quoteStyle;
    }

    public short getQuoteUsage() {
        return this._quoteUsage;
    }

    public void setQuoteUsage(short quoteUsage) {
        this._quoteUsage = quoteUsage;
    }

    public boolean isSpecified() {
        return this._specified;
    }

    public void setSpecified(boolean specified) {
        this._specified = specified;
    }

    public final boolean isStartQuotePresent() {
        return this._quoteUsage == 0 || this._quoteUsage == 2;
    }

    public final boolean isEndQuotePresent() {
        return this._quoteUsage == 0 || this._quoteUsage == 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("attrLocator[");
        buf.append("name: " + this._nameLocator);
        buf.append(", equals: " + this._equalsLocator);
        buf.append(", value: " + this._valueLocator);
        buf.append(this._usageAndStyle());
        buf.append("]");
        return buf.toString();
    }

    private String _usageAndStyle() {
        switch (this._quoteUsage) {
            case 3: {
                return ", missing both";
            }
            case 2: {
                return ", missing end, " + this._style();
            }
            case 1: {
                return ", missing start, " + this._style();
            }
            case 0: {
                return ", normal, " + this._style();
            }
        }
        return "invalid value";
    }

    private String _style() {
        switch (this._quoteStyle) {
            case 1: {
                return "\"";
            }
            case 0: {
                return "'";
            }
        }
        return "missing";
    }

    protected AttributeLocator(LineMap lineMap, SimpleLocator nameLocator) {
        super(lineMap);
        this._nameLocator = nameLocator;
    }
}

