/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.DomCommitException;
import oracle.bali.xml.dom.DomModelEvent;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.impl.ChangeRecord;
import oracle.bali.xml.dom.impl.ChildDomModelTransaction;
import oracle.bali.xml.dom.impl.DomModelImpl;
import oracle.bali.xml.dom.impl.InTransactionChangeRollbackHandler;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MutationEvent;

public abstract class DomModelTransaction {
    private SafeListenerManager _changeListeners;
    private ChildDomModelTransaction _child;
    private final DomModelImpl _model;

    DomModelTransaction(DomModelImpl model) {
        this._model = model;
    }

    public final DomModelImpl getModel() {
        return this._model;
    }

    public final Document getDocument() {
        return this.getModel().getDocument();
    }

    public ChildDomModelTransaction startNestedTransaction(String description) {
        ChildDomModelTransaction child = new ChildDomModelTransaction(this._model, this, description);
        this.setNestedTransaction(child);
        return child;
    }

    protected void setNestedTransaction(ChildDomModelTransaction child) {
        if (this._child != null) {
            throw new IllegalStateException("Transaction already open");
        }
        this._child = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomCommitException precommitChild(int changeIncrement) {
        DomCommitException result = null;
        ChildDomModelTransaction child = null;
        DomModelTransaction domModelTransaction = this;
        synchronized (domModelTransaction) {
            child = this._child;
            if (child == null) {
                throw new IllegalStateException("Parent has no child transaction to precommit");
            }
            try {
                result = this.precommitDomChanges(child, changeIncrement);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (RuntimeException e) {
                this.getModel().getLogger().log(Level.WARNING, "Unexpected Exception!", e);
                throw e;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitChild(int changeIncrement) {
        int changeFlags;
        Node changeTarget;
        ChildDomModelTransaction child;
        DomModelTransaction domModelTransaction = this;
        synchronized (domModelTransaction) {
            child = this._child;
            if (child == null) {
                throw new IllegalStateException("Parent has no child transaction to commit");
            }
            try {
                this._child = null;
                this.updateChangeTarget(child, changeIncrement);
                changeTarget = this.getChangeTarget();
                changeFlags = this.getChangeFlags();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (RuntimeException e) {
                this._child = child;
                this.getModel().getLogger().log(Level.WARNING, "Unexpected Exception!", e);
                throw e;
            }
        }
        this.fireSubtreeChanged(changeTarget, changeFlags, this._createDomChangeList(child.getMutationChanges()), null, child.getNodeChangeDetails());
    }

    protected void rollbackChild() {
        if (this._child == null) {
            throw new IllegalStateException("Parent has no child transaction to rollback");
        }
        this._child = null;
    }

    protected Node getChangeTarget() {
        return this._child.getChangeTarget();
    }

    protected int getChangeFlags() {
        return this._child.getChangeFlags();
    }

    protected DomCommitException precommitDomChanges(ChildDomModelTransaction child, int changeIncrement) {
        return null;
    }

    protected void updateChangeTarget(ChildDomModelTransaction child, int changeIncrement) {
    }

    public abstract DomCommitException precommit();

    public abstract DomModelTransaction commit();

    public abstract DomModelTransaction rollback();

    protected abstract DomModelTransaction getParent();

    protected ChildDomModelTransaction getChild() {
        return this._child;
    }

    public Node getCommittedChangeTarget() {
        if (this._child != null) {
            return this._child.getCommittedChangeTarget();
        }
        return null;
    }

    public String getDescription() {
        if (this._child != null) {
            return this._child.getDescription();
        }
        return null;
    }

    public void addDomChangeListener(DomModelListener listener) {
        if (this._changeListeners == null) {
            this._changeListeners = new SafeListenerManager();
        }
        this._changeListeners.addListener(listener);
    }

    public void removeDomChangeListener(DomModelListener listener) {
        this._changeListeners.removeListener(listener);
    }

    public boolean hasModifications() {
        if (this._child != null) {
            return this._child.hasModifications();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferListeners(DomModelTransaction oldTrans) {
        DomModelTransaction domModelTransaction = this;
        synchronized (domModelTransaction) {
            this._changeListeners = oldTrans._changeListeners;
            oldTrans._changeListeners = null;
        }
    }

    public void handleMutationEvent(Event event) {
        int changeFlag;
        DomChange change;
        Node changedNode;
        Logger log = this.getLogger();
        if (this._child != null) {
            log.severe("Child transaction open");
            throw new IllegalStateException("Child transaction open");
        }
        MutationEvent mEvent = (MutationEvent)event;
        Node targetNode = (Node)((Object)mEvent.getTarget());
        Node mergeNode = mEvent.getRelatedNode();
        String eventType = mEvent.getType();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(DomUtils.getEventDebugMsg((MutationEvent)mEvent));
        }
        if ("DOMNodeInserted".equals(eventType) && targetNode.getNodeType() == 1 && targetNode.getParentNode() == this.getDocument()) {
            int numElements = 0;
            for (Node walk = this.getDocument().getFirstChild(); walk != null; walk = walk.getNextSibling()) {
                if (walk.getNodeType() != 1) continue;
                ++numElements;
            }
            if (numElements > 1) {
                throw new IllegalStateException("Got element inserted event for element with document as its parent and found there to be " + numElements + " root elements!");
            }
        }
        if ("DOMAttrModified".equals(eventType)) {
            Attr attr = (Attr)mEvent.getRelatedNode();
            changedNode = attr;
            mergeNode = targetNode;
            switch (mEvent.getAttrChange()) {
                case 2: {
                    change = new AttrAddedChange(attr);
                    break;
                }
                case 3: {
                    change = new AttrRemovedChange(attr, mergeNode);
                    break;
                }
                case 1: {
                    String newValue = mEvent.getNewValue();
                    String oldValue = mEvent.getPrevValue();
                    if (newValue == oldValue || newValue != null && newValue.equals(oldValue)) {
                        change = null;
                        break;
                    }
                    change = new AttrValueChange(attr, oldValue, newValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid mutation event: " + mEvent);
                }
            }
            changeFlag = 8;
        } else if ("DOMCharacterDataModified".equals(eventType)) {
            changedNode = mergeNode = targetNode;
            changeFlag = 16;
            String newValue = mEvent.getNewValue();
            String oldValue = mEvent.getPrevValue();
            if (newValue == null) {
                newValue = "";
                LogUtils.log((Logger)log, (Level)Level.WARNING, (String)"A CharacterData node was set to a null value. The DOM specification is unclear on this, but it makes no sense set the value of a CharacterData node to null. Removing the outer node or setting the data to an empty string are both valid options.  The CharacterData node will be treated as having empty string as a value . owning element={0}", (Object[])new Object[]{changedNode.getParentNode()}, (Throwable)new Throwable("stack trace -- caller set value of CharacterData node to null"));
            }
            if (oldValue == null) {
                oldValue = "";
            }
            change = newValue == oldValue || newValue.equals(oldValue) ? null : new NodeValueChange(targetNode, oldValue, newValue);
        } else if ("DOMNodeRemoved".equals(eventType)) {
            changedNode = targetNode;
            change = new NodeRemovedChange(targetNode);
            changeFlag = 2;
        } else if ("DOMNodeInserted".equals(eventType)) {
            changedNode = targetNode;
            change = new NodeInsertedChange(targetNode);
            changeFlag = 1;
        } else {
            throw new IllegalStateException("Invalid mutation event: " + mEvent);
        }
        if (change != null) {
            this.handleMutationEventHook(mergeNode, changeFlag, new ChangeRecord(change, changedNode), mEvent);
            if (log.isLoggable(Level.FINEST)) {
                log.finer("  " + change);
            }
            NodeChangeDetails details = null;
            this.fireSubtreeChanged(mergeNode, changeFlag, Collections.singletonList(change), null, details);
        }
    }

    protected abstract void handleMutationEventHook(Node var1, int var2, ChangeRecord var3, MutationEvent var4);

    protected void rollbackChanges(List list) {
        ListIterator itor = list.listIterator(list.size());
        while (itor.hasPrevious()) {
            Object prev = itor.previous();
            if (prev instanceof List) {
                this.rollbackChanges((List)prev);
                continue;
            }
            if (!(prev instanceof ChangeRecord)) continue;
            ChangeRecord changeRecord = (ChangeRecord)prev;
            DomChange change = changeRecord.getChange();
            Node node = changeRecord.getAssociatedNode();
            change.process(new InTransactionChangeRollbackHandler(this._model, node));
        }
    }

    protected final void fireSubtreeChanged(Node changeTarget, int changeFlags, List domChanges, Map propertyChanges, NodeChangeDetails details) {
        this.fireSubtreeChanged(changeTarget, changeFlags, domChanges, propertyChanges, details, !this.getModel().isInTopLevelTransaction());
    }

    protected void fireSubtreeChanged(Node changeTarget, int changeFlags, List domChanges, Map propertyChanges, NodeChangeDetails details, boolean isNestedTransaction) {
        if (this._changeListeners == null || this._changeListeners.isEmpty()) {
            return;
        }
        DomModelEvent changeEvent = this.createDomChangeEvent(changeTarget, changeFlags, domChanges, propertyChanges = PropertyChange.mergePropertyChangeMaps(propertyChanges, this.getModel().getExtraPropertyChanges(changeTarget, changeFlags, isNestedTransaction), null), details);
        if (changeEvent == null) {
            return;
        }
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "DomModel firing event: {0}", changeEvent);
        }
        Iterator changeListeners = this._changeListeners.iterator();
        while (changeListeners.hasNext()) {
            DomModelListener listener = (DomModelListener)changeListeners.next();
            try {
                listener.modelChanged(changeEvent);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Exception caught during DomModel event dispatch:", t);
            }
        }
    }

    protected final DomModelEvent createDomChangeEvent(Node changeTarget, int changeFlags, List domChanges, Map propertyChanges, NodeChangeDetails details) {
        if (changeFlags == 0 && (propertyChanges == null || propertyChanges.isEmpty()) && domChanges.isEmpty()) {
            return null;
        }
        return new DomModelEvent(this.getModel(), changeTarget, changeFlags, domChanges, propertyChanges, details);
    }

    protected final Logger getLogger() {
        return this.getModel().getLogger();
    }

    private List _createDomChangeList(List changeRecords) {
        if (changeRecords.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList ret = new ArrayList(changeRecords.size());
        this._addDomChangesToList(changeRecords, ret);
        return ret;
    }

    private void _addDomChangesToList(List changeRecords, List outDomChangeList) {
        for (Object next : changeRecords) {
            if (next instanceof List) {
                this._addDomChangesToList((List)next, outDomChangeList);
                continue;
            }
            if (next instanceof ChangeRecord) {
                ChangeRecord record = (ChangeRecord)next;
                outDomChangeList.add(record.getChange());
                continue;
            }
            throw new IllegalStateException("Invalid item in changeRecords list! item=" + next);
        }
    }
}

