/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation.impl.example;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import oracle.bali.xml.model.annotation.impl.SideFileAnnotationModel;
import oracle.bali.xml.model.annotation.impl.example.ExampleAnnotationProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExampleAnnotationModel
extends SideFileAnnotationModel {
    public static final QualifiedName XML_ID = QualifiedName.getQualifiedName((String)"http://www.w3.org/XML/1998/namespace", (String)"id");
    public static final String INSTANCE_ANNOTATION_NS = "http://www.example.org/instance-annotation";
    public static final QualifiedName INSTANCE_ANNOTATION = QualifiedName.getQualifiedName((String)"http://www.example.org/instance-annotation", (String)"instance-annotation");
    public static final QualifiedName IDREF_ATTR = QualifiedName.getQualifiedName(null, (String)"node-id");

    public ExampleAnnotationModel(XmlContext instanceContext, XmlContext sideFileContext) {
        super(instanceContext, sideFileContext);
    }

    @Override
    public AnnotationProvider getAnnotationProvider(Node node) {
        String idValue;
        Element element;
        Attr idAttr;
        if (DomUtils.isElement((Node)node) && (idAttr = DomUtils.getAttribute((Element)(element = (Element)node), (QualifiedName)XML_ID)) != null && (idValue = idAttr.getValue()) != null && idValue.length() > 0) {
            return this._getAnnotationProvider(idValue);
        }
        return null;
    }

    private AnnotationProvider _getAnnotationProvider(String id) {
        Element root;
        ExampleAnnotationProvider provider = null;
        XmlModel sideFileModel = this.getSideFileModel();
        Document annotationDoc = sideFileModel.getDocument();
        if (annotationDoc != null && (root = annotationDoc.getDocumentElement()) != null) {
            Element annotationElement = this._findExistingAnnotationElement(root, id);
            if (annotationElement == null) {
                annotationElement = annotationDoc.createElementNS(INSTANCE_ANNOTATION.getNamespace(), INSTANCE_ANNOTATION.getName());
                annotationElement.setAttributeNS(IDREF_ATTR.getNamespace(), IDREF_ATTR.getName(), id);
            }
            provider = new ExampleAnnotationProvider(sideFileModel, annotationDoc, annotationElement, id);
        }
        return provider;
    }

    private Element _findExistingAnnotationElement(Element root, String id) {
        if (root != null) {
            for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                Attr idref;
                Element element;
                QualifiedName qName;
                if (!DomUtils.isElement((Node)child) || !INSTANCE_ANNOTATION.equals((Object)(qName = DomUtils.getQualifiedName((Node)(element = (Element)child)))) || (idref = DomUtils.getAttribute((Element)element, (QualifiedName)IDREF_ATTR)) == null || !id.equals(idref.getValue())) continue;
                return element;
            }
        }
        return null;
    }
}

