/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractPositionTargetingOperation;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NodeList;

class CopyOperation
extends AbstractPositionTargetingOperation {
    CopyOperation() {
    }

    @Override
    public boolean apply(AbstractModel model, DomPosition pos, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        DocumentFragment fragment = (DocumentFragment)data.getData(FetchMode.STANDARD, false);
        if (fragment != null) {
            String txnName = this.getDisplayName(model, data);
            Collection ret = CopyOperation.__insertNodes(model, pos, fragment, txnName, token);
            return ret != null;
        }
        return false;
    }

    @Override
    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragCopy");
        }
        return model.getTranslatedString("DragCopy_Data", infoDesc);
    }

    @Override
    public float getSuitabilityRank() {
        return 0.9f;
    }

    @Override
    public int getSupportedActions() {
        return 1;
    }

    @Override
    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_DOCUMENTFRAGMENT;
    }

    @Override
    protected boolean isValidData(AbstractModel model, TransferDataInfo info, Object datum) {
        return super.isValidData(model, info, datum) && (datum == null || datum instanceof DocumentFragment) && XmlTransferUtils.hasOriginalNodesOrRange(info);
    }

    @Override
    protected boolean isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        if (!super.isValidPosition(model, pos, info, datum)) {
            return false;
        }
        return CopyOperation.__isValidPosition(model, pos, info, datum);
    }

    @Override
    protected DomPosition convertPosition(AbstractModel model, DomPosition originalPos, Object datum) {
        return model.convertInsertionPosition(originalPos);
    }

    static boolean __isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        if (!model.getXmlMetadataResolver().canAddChild(pos)) {
            return false;
        }
        if (datum == null) {
            List keys = (List)info.getMetadata(XmlTransferUtils.KEY_XMLKEY_LIST);
            if (keys == null) {
                return true;
            }
            return model.getXmlMetadataResolver().isValidInsertion(pos, keys);
        }
        DocumentFragment fragment = (DocumentFragment)datum;
        return model.getXmlMetadataResolver().isValidInsertion(pos, fragment.getChildNodes());
    }

    static Collection __insertNodes(AbstractModel model, final DomPosition pos, final DocumentFragment fragment, String txnName, final TransactionToken token) throws XmlCommitException {
        final Collection[] ret = new Collection[1];
        new FixedNameTransactionTask(txnName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                model.getContext().setTransactionToken(token);
                DocumentFragment imported = (DocumentFragment)model.getDocument().importNode(fragment, true);
                ret[0] = model.insertNodes(pos, "internal __insertNodes transaction", DomUtils.nodeListToList((NodeList)imported.getChildNodes()), true);
            }
        }.runThrowingXCE(model);
        return ret[0];
    }
}

