/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.console.ItemTypeView;
import oracle.dbtools.raptor.metrics.console.SourceTypeView;
import oracle.dbtools.raptor.metrics.console.ViewObject;
import oracle.dbtools.raptor.metrics.listener.JobTypeChange;

public class JobTypeView
extends ViewObject<JobTypeChange> {
    private ObjectProperty<SourceTypeView> sourceTypeProperty;
    private ObservableList<ItemTypeView> itemTypesProperty;
    private ObservableList<ItemTypeView> unmodifiableItemTypesProperty;

    public SourceTypeView getSourceType() {
        return (SourceTypeView)this.sourceTypeProperty().get();
    }

    public ObservableObjectValue<SourceTypeView> sourceTypeProperty() {
        return this.sourceTypeProperty;
    }

    public ObservableList<ItemTypeView> getItemTypes() {
        return this.unmodifiableItemTypesProperty;
    }

    JobTypeView() {
    }

    @Override
    void onAdd(ViewObject.Context context, JobTypeChange jobTypeChange) {
        super.onAdd(context, jobTypeChange);
        this.itemTypesProperty = FXCollections.observableArrayList();
        this.unmodifiableItemTypesProperty = FXCollections.unmodifiableObservableList(this.itemTypesProperty);
        this.sourceTypeProperty = new SimpleObjectProperty((Object)this, "sourceType", (Object)context.lookupObject(SourceTypeView.class, jobTypeChange.getSourceTypeId()));
        ((SourceTypeView)this.sourceTypeProperty.get()).addJobTypeView(this);
    }

    @Override
    void onRemove() {
        ((SourceTypeView)this.sourceTypeProperty.get()).removeJobTypeView(this);
    }

    void addItemTypeView(ItemTypeView itemTypeView) {
        this.itemTypesProperty.add((Object)itemTypeView);
    }

    void removeItemTypeView(ItemTypeView itemTypeView) {
        this.itemTypesProperty.remove((Object)itemTypeView);
    }
}

