/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.effect.MotionBlur;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.facet.Augmentor;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.SnapshotAttribute;

public abstract class AbstractChangeIndicatorObject
implements Augmentor {
    private ObservableBooleanValue connectedValue;
    private ObservableBooleanValue availableValue;
    private ChangeListener<Boolean> availableListener;
    private boolean inTransition;
    private FadeTransition fadeTransition;
    private Context context;

    @Override
    public Class<?> getBindToClass() {
        return Node.class;
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return AbstractChangeIndicatorObject.class;
    }

    public ObservableBooleanValue getConnectedValue() {
        return this.connectedValue;
    }

    protected void playContainerNodeChangeEffect(Context context) {
        if (this.availableValue.get()) {
            this.inTransition = true;
            context.getLinkedTarget(Node.class, this).setEffect((Effect)new MotionBlur(0.0, 10.0));
            this.fadeTransition.play();
        }
    }

    private void onAvailable() {
        if (this.availableListener != null) {
            this.availableValue.removeListener(this.availableListener);
            this.availableListener = null;
        }
        if (!this.inTransition) {
            this.inTransition = true;
            this.context.getLinkedTarget(Node.class, this).setEffect((Effect)new BoxBlur());
            this.fadeTransition.play();
        }
    }

    private void setNonTransitionEffect(Node node) {
        BoxBlur boxBlur = null;
        if (this.availableValue == null || !this.availableValue.get()) {
            boxBlur = new BoxBlur();
        }
        node.setEffect((Effect)boxBlur);
    }

    private void onTimeout() {
        if (this.inTransition) {
            this.inTransition = false;
            this.setNonTransitionEffect(this.context.getLinkedTarget(Node.class, this));
        }
    }

    protected abstract class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            AbstractChangeIndicatorObject.this.context = context;
        }

        @Override
        public void onOpen(Context context) {
            if (!SnapshotAttribute.get(context)) {
                AbstractChangeIndicatorObject.this.inTransition = false;
                AbstractChangeIndicatorObject.this.setNonTransitionEffect(context.getLinkedTarget(Node.class, AbstractChangeIndicatorObject.this));
            }
        }

        @Override
        public void onStart(Context context, DXListenerList dXListenerList) {
            if (!SnapshotAttribute.get(context)) {
                List<DataObject<?>> list;
                Node node = context.getLinkedTarget(Node.class, AbstractChangeIndicatorObject.this);
                Monitor monitor = context.getLinkedSource(Monitor.class, node);
                if (monitor != null && (list = monitor.getDataObjects(context)) != null) {
                    for (DataObject<?> dataObject : list) {
                        if (AbstractChangeIndicatorObject.this.availableValue == null) {
                            AbstractChangeIndicatorObject.this.availableValue = (ObservableBooleanValue)dataObject.availableProperty();
                        } else {
                            AbstractChangeIndicatorObject.this.availableValue = (ObservableBooleanValue)Bindings.and((ObservableBooleanValue)AbstractChangeIndicatorObject.this.availableValue, (ObservableBooleanValue)dataObject.availableProperty());
                        }
                        if (AbstractChangeIndicatorObject.this.connectedValue == null) {
                            AbstractChangeIndicatorObject.this.connectedValue = (ObservableBooleanValue)dataObject.connectedProperty();
                            continue;
                        }
                        AbstractChangeIndicatorObject.this.connectedValue = (ObservableBooleanValue)Bindings.and((ObservableBooleanValue)AbstractChangeIndicatorObject.this.connectedValue, (ObservableBooleanValue)dataObject.connectedProperty());
                    }
                }
                AbstractChangeIndicatorObject.this.setNonTransitionEffect(context.getLinkedTarget(Node.class, AbstractChangeIndicatorObject.this));
                AbstractChangeIndicatorObject.this.fadeTransition = new FadeTransition(Duration.seconds((double)0.25), node);
                if (AbstractChangeIndicatorObject.this.availableValue != null) {
                    if (((Boolean)AbstractChangeIndicatorObject.this.availableValue.getValue()).booleanValue()) {
                        AbstractChangeIndicatorObject.this.onAvailable();
                    } else {
                        AbstractChangeIndicatorObject.this.availableListener = (observableValue, bl, bl2) -> {
                            if (bl2.booleanValue()) {
                                AbstractChangeIndicatorObject.this.onAvailable();
                            }
                        };
                        AbstractChangeIndicatorObject.this.availableValue.addListener(AbstractChangeIndicatorObject.this.availableListener);
                    }
                }
                AbstractChangeIndicatorObject.this.fadeTransition.setFromValue(1.0);
                AbstractChangeIndicatorObject.this.fadeTransition.setToValue(0.9);
                AbstractChangeIndicatorObject.this.fadeTransition.setCycleCount(2);
                AbstractChangeIndicatorObject.this.fadeTransition.setAutoReverse(true);
                AbstractChangeIndicatorObject.this.fadeTransition.setOnFinished(actionEvent -> AbstractChangeIndicatorObject.this.onTimeout());
            }
        }

        @Override
        public void onStop(Context context, DXListenerList dXListenerList) {
            if (!SnapshotAttribute.get(context)) {
                AbstractChangeIndicatorObject.this.inTransition = false;
                context.getLinkedTarget(Node.class, AbstractChangeIndicatorObject.this).setEffect((Effect)new BoxBlur());
                if (AbstractChangeIndicatorObject.this.availableValue != null && AbstractChangeIndicatorObject.this.availableListener != null) {
                    AbstractChangeIndicatorObject.this.availableValue.removeListener(AbstractChangeIndicatorObject.this.availableListener);
                }
                if (AbstractChangeIndicatorObject.this.fadeTransition != null) {
                    AbstractChangeIndicatorObject.this.fadeTransition.stop();
                }
                AbstractChangeIndicatorObject.this.availableValue = null;
                AbstractChangeIndicatorObject.this.availableListener = null;
                AbstractChangeIndicatorObject.this.connectedValue = null;
                AbstractChangeIndicatorObject.this.fadeTransition = null;
            }
        }
    }
}

