/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.facet.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.facet.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.facet.TableCellFactory;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSet;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSetSelector;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

public abstract class AbstractTableViewMonitor
extends AbstractTableMonitor<TableColumn<DXRow, Object>, TableCell<DXRow, Object>, TableFeatureSet> {
    private TableView<DXRow> tableView;
    private TablePosition<DXRow, ?> selectedTablePosition;
    private DXKey selectedKey = null;
    private final ObservableList<TableFeatureSetSelector<TableFeatureSet>> featureSetSelectors = FXCollections.observableArrayList();

    @Override
    public ObservableList<TableFeatureSetSelector<TableFeatureSet>> getFeatureSetSelectors() {
        return this.featureSetSelectors;
    }

    public TableView<DXRow> getTableView() {
        return this.tableView;
    }

    @Override
    public Class<?> getBindToClass() {
        return TableView.class;
    }

    @Override
    protected DXRow getRow(TableCell<DXRow, Object> tableCell) {
        TableRow tableRow;
        DXRow dXRow = null;
        int n = tableCell.getIndex();
        Object object = tableCell.getItem();
        if (n >= 0 && object != null && (tableRow = tableCell.getTableRow()) != null) {
            dXRow = (DXRow)tableRow.getItem();
        }
        return dXRow;
    }

    @Override
    protected TableColumn<DXRow, Object> getColumn(TableCell<DXRow, Object> tableCell) {
        return tableCell.getTableColumn();
    }

    protected TableCellFactory<TableCell<DXRow, Object>> getCellFactory(TableColumn<DXRow, Object> tableColumn) {
        TableCellFactory tableCellFactory = null;
        Callback callback = tableColumn.getCellFactory();
        if (callback instanceof TableCellFactory) {
            tableCellFactory = (TableCellFactory)callback;
        }
        return tableCellFactory;
    }

    protected void bindTableView(Context context, TableView<DXRow> tableView) {
        if (tableView != null) {
            ObservableList observableList = tableView.getColumns();
            for (TableColumn tableColumn : observableList) {
                this.bindTableColumn(tableColumn);
            }
            this.getItem().updatingProperty().addListener((observableValue, bl, bl2) -> {
                if (bl2.booleanValue()) {
                    DXRow dXRow = (DXRow)tableView.getSelectionModel().getSelectedItem();
                    this.selectedKey = dXRow != null ? dXRow.getKey() : null;
                    ObservableList observableList = tableView.getSelectionModel().getSelectedCells();
                    this.selectedTablePosition = observableList.isEmpty() ? null : (TablePosition)observableList.get(0);
                } else if (this.selectedTablePosition != null) {
                    if (this.selectedKey != null) {
                        DXRow dXRow = (DXRow)tableView.getItems().get(this.selectedTablePosition.getRow());
                        if (this.selectedKey.equals(dXRow.getKey())) {
                            tableView.getSelectionModel().select(this.selectedTablePosition.getRow(), this.selectedTablePosition.getTableColumn());
                        } else {
                            boolean bl3 = false;
                            ObservableList observableList = tableView.getItems();
                            for (int i = 0; i < observableList.size(); ++i) {
                                if (!this.selectedKey.equals(((DXRow)observableList.get(i)).getKey())) continue;
                                tableView.getSelectionModel().select(i, this.selectedTablePosition.getTableColumn());
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                tableView.getSelectionModel().clearSelection();
                            }
                        }
                    } else {
                        tableView.getSelectionModel().clearSelection();
                    }
                    this.selectedTablePosition = null;
                    this.selectedKey = null;
                }
            });
        }
    }

    private void bindTableColumn(TableColumn<DXRow, ?> tableColumn) {
        TableCellFactory<TableCell<DXRow, Object>> tableCellFactory = this.getCellFactory(tableColumn);
        if (tableCellFactory instanceof AbstractCellFactory) {
            TableColumn<DXRow, ?> tableColumn2 = tableColumn;
            tableColumn2.setCellValueFactory(cellDataFeatures -> ((DXRow)cellDataFeatures.getValue()).get(tableCellFactory.getValueColumn()));
        }
    }

    private void showSelectedCellContextMenu(ContextMenuEvent contextMenuEvent) {
        ObservableList observableList = this.tableView.getSelectionModel().getSelectedCells();
        if (!observableList.isEmpty()) {
            double d;
            double d2;
            TablePosition tablePosition = (TablePosition)observableList.get(0);
            TableCellFactory<TableCell<DXRow, Object>> tableCellFactory = this.getCellFactory((TableColumn<DXRow, Object>)tablePosition.getTableColumn());
            TableCell<DXRow, Object> tableCell = tableCellFactory.getCell(tablePosition.getRow());
            if (contextMenuEvent != null) {
                d2 = contextMenuEvent.getScreenX();
                d = contextMenuEvent.getScreenY();
            } else {
                Bounds bounds = tableCell.getBoundsInLocal();
                Point2D point2D = tableCell.localToScreen(0.0, bounds.getHeight());
                d2 = point2D.getX();
                d = point2D.getY();
            }
            this.showContextMenu(tableCell.getContextMenu(), tableCell, d2, d);
        }
    }

    protected abstract class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            AbstractTableViewMonitor.this.tableView = context.getLinkedTarget(TableView.class, AbstractTableViewMonitor.this);
            AbstractTableViewMonitor.this.tableView.getSelectionModel().setCellSelectionEnabled(AbstractTableViewMonitor.this.isCellSelectionEnabled());
            if (AbstractTableViewMonitor.this.tableView != null) {
                for (TableColumn tableColumn : AbstractTableViewMonitor.this.tableView.getColumns()) {
                    TableCellFactory<TableCell<DXRow, Object>> tableCellFactory = AbstractTableViewMonitor.this.getCellFactory((TableColumn<DXRow, Object>)tableColumn);
                    tableCellFactory.initCellFactory(AbstractTableViewMonitor.this);
                }
                AbstractTableViewMonitor.this.tableView.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, contextMenuEvent -> {
                    if (!contextMenuEvent.isKeyboardTrigger()) {
                        AbstractTableViewMonitor.this.showSelectedCellContextMenu(contextMenuEvent);
                    }
                });
                AbstractTableViewMonitor.this.tableView.setOnKeyReleased(keyEvent -> {
                    if (AbstractTableViewMonitor.this.isShowContextMenuEvent((KeyEvent)keyEvent)) {
                        AbstractTableViewMonitor.this.showSelectedCellContextMenu(null);
                    }
                });
            }
        }
    }
}

