/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

public class OptionMonitor
implements Monitor {
    private TemplateInstance<Parent> panelInstance;
    private Node unselectedPane;
    private Context context;
    private final BooleanProperty selectedProperty = new SimpleBooleanProperty((Object)this, "selector", false);
    private final ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty = new SimpleObjectProperty((Object)this, "panelTemplate");
    private final BooleanProperty stopOnDeselectProperty = new SimpleBooleanProperty((Object)this, "stopOnDeselect", false);
    private final ObjectProperty<Node> unselectedGraphicProperty = new SimpleObjectProperty((Object)this, "unselectedGraphic");
    private final StringProperty unselectedTextProperty = new SimpleStringProperty((Object)this, "unselectedText", "");

    public OptionMonitor() {
        this.init(new Listener());
    }

    public boolean isSelected() {
        return this.selectedProperty.get();
    }

    public void setSelected(boolean bl) {
        this.selectedProperty.set(bl);
    }

    public BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public PanelTemplate<Parent> getPanelTemplate() {
        return (PanelTemplate)this.panelTemplateProperty.get();
    }

    public void setPanelTemplate(PanelTemplate<Parent> panelTemplate) {
        this.panelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty() {
        return this.panelTemplateProperty;
    }

    public boolean isStopOnDeselect() {
        return this.stopOnDeselectProperty.get();
    }

    public void setStopOnDeselect(boolean bl) {
        this.stopOnDeselectProperty.set(bl);
    }

    public BooleanProperty stopOnDeselectProperty() {
        return this.stopOnDeselectProperty;
    }

    public Node getUnselectedGraphic() {
        return (Node)this.unselectedGraphicProperty.get();
    }

    public void setUnselectedGraphic(Node node) {
        this.unselectedGraphicProperty.set((Object)node);
    }

    public ObjectProperty<Node> unselectedGraphicProperty() {
        return this.unselectedGraphicProperty;
    }

    public String getUnselectedText() {
        return (String)this.unselectedTextProperty.get();
    }

    public void setUnselectedText(String string) {
        this.unselectedTextProperty.set((Object)string);
    }

    public StringProperty unselectedTextProperty() {
        return this.unselectedTextProperty;
    }

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        return Collections.emptyList();
    }

    @Override
    public Class<?> getBindToClass() {
        return StackPane.class;
    }

    private Node createUnselectedPanel() {
        Object object;
        int n;
        GridPane gridPane = new GridPane();
        gridPane.setVgap(5.0);
        for (n = 0; n < 3; ++n) {
            object = new ColumnConstraints();
            object.setPercentWidth(33.333333333333336);
            gridPane.getColumnConstraints().add(object);
        }
        for (n = 0; n < 2; ++n) {
            object = new RowConstraints();
            object.setPercentHeight(50.0);
            gridPane.getRowConstraints().add(object);
        }
        Node node = this.getUnselectedGraphic();
        if (node != null) {
            GridPane.setValignment((Node)node, (VPos)VPos.BOTTOM);
            GridPane.setHalignment((Node)node, (HPos)HPos.CENTER);
            gridPane.add(node, 1, 0);
        }
        if ((object = this.getUnselectedText()) != null) {
            Label label = new Label((String)object);
            label.getStyleClass().add((Object)"unselected-label");
            label.setMaxWidth(Double.MAX_VALUE);
            label.setAlignment(Pos.TOP_CENTER);
            GridPane.setValignment((Node)label, (VPos)VPos.TOP);
            GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
            gridPane.add((Node)label, 1, 1);
        }
        return gridPane;
    }

    private TemplateInstance<Parent> getInstance() {
        if (this.panelInstance == null) {
            PanelTemplate<Parent> panelTemplate = this.getPanelTemplate();
            this.panelInstance = panelTemplate.newPanel();
            if (this.panelInstance != null) {
                Node node = (Node)this.panelInstance.getRootObject();
                node.setVisible(false);
                StackPane stackPane = this.context.getLinkedTarget(StackPane.class, this);
                stackPane.getChildren().add((Object)node);
            }
        }
        return this.panelInstance;
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            OptionMonitor.this.context = context;
        }

        @Override
        public void onOpen(Context context) {
            StackPane stackPane = context.getLinkedTarget(StackPane.class, OptionMonitor.this);
            OptionMonitor.this.unselectedPane = OptionMonitor.this.createUnselectedPanel();
            stackPane.getChildren().add((Object)OptionMonitor.this.unselectedPane);
            if (OptionMonitor.this.isSelected()) {
                TemplateInstance templateInstance = OptionMonitor.this.getInstance();
                ((Parent)templateInstance.getRootObject()).setVisible(true);
                templateInstance.getContext().setDataStreamEnabled(true);
                OptionMonitor.this.unselectedPane.setVisible(false);
            }
            OptionMonitor.this.selectedProperty.addListener((observableValue, bl, bl2) -> {
                if (!bl2.booleanValue()) {
                    TemplateInstance templateInstance = OptionMonitor.this.getInstance();
                    ((Parent)templateInstance.getRootObject()).setVisible(false);
                    OptionMonitor.this.unselectedPane.setVisible(true);
                    if (OptionMonitor.this.isStopOnDeselect()) {
                        templateInstance.getContext().setDataStreamEnabled(false);
                    }
                } else {
                    TemplateInstance templateInstance = OptionMonitor.this.getInstance();
                    ((Parent)templateInstance.getRootObject()).setVisible(true);
                    OptionMonitor.this.unselectedPane.setVisible(false);
                    templateInstance.getContext().setDataStreamEnabled(true);
                }
            });
        }

        @Override
        public void onClose(Context context) {
            OptionMonitor.this.unselectedPane.setVisible(true);
        }
    }
}

