/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.generation.AbstractContainerElement;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationElement;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.BoundListDataObject;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;

public class ForEach
extends AbstractContainerElement {
    private List<SortColumn> sortNames;
    private final ObjectProperty<BoundListDataObject> inProperty = new SimpleObjectProperty((Object)this, "in");
    private final StringProperty rowAliasProperty = new SimpleStringProperty((Object)this, "rowAlias", "row");
    private final StringProperty sortByProperty = new SimpleStringProperty((Object)this, "sortBy");
    private final StringProperty idColumnNameProperty = new SimpleStringProperty((Object)this, "idColumnName");
    private final StringProperty parentIdColumnNameProperty = new SimpleStringProperty((Object)this, "parentIdColumnName");
    private final StringProperty perLevelIndentProperty = new SimpleStringProperty((Object)this, "perLevelIndent", "\t");
    private final StringProperty indentParameterNameProperty = new SimpleStringProperty((Object)this, "indentParameterName", "indent");
    private final StringProperty levelParameterNameProperty = new SimpleStringProperty((Object)this, "levelParameterName", "level");
    private final ObservableList<AbstractGenerationElement> emptyElements = FXCollections.observableArrayList();

    public BoundListDataObject getIn() {
        return (BoundListDataObject)this.inProperty.get();
    }

    public void setIn(BoundListDataObject boundListDataObject) {
        this.inProperty.set((Object)boundListDataObject);
    }

    public ObjectProperty<BoundListDataObject> inProperty() {
        return this.inProperty;
    }

    public String getRowAlias() {
        return (String)this.rowAliasProperty.get();
    }

    public void setRowAlias(String string) {
        this.rowAliasProperty.set((Object)string);
    }

    public StringProperty rowAliasProperty() {
        return this.rowAliasProperty;
    }

    public String getSortBy() {
        return (String)this.sortByProperty.get();
    }

    public void setSortBy(String string) {
        this.sortByProperty.set((Object)string);
    }

    public StringProperty sortByProperty() {
        return this.sortByProperty;
    }

    public String getIdColumnName() {
        return (String)this.idColumnNameProperty.get();
    }

    public void setIdColumnName(String string) {
        this.idColumnNameProperty.set((Object)string);
    }

    public StringProperty idColumnNameProperty() {
        return this.idColumnNameProperty;
    }

    public String getParentIdColumnName() {
        return (String)this.parentIdColumnNameProperty.get();
    }

    public void setParentIdColumnName(String string) {
        this.parentIdColumnNameProperty.set((Object)string);
    }

    public StringProperty parentIdColumnNameProperty() {
        return this.parentIdColumnNameProperty;
    }

    public String getPerLevelIndent() {
        return (String)this.perLevelIndentProperty.get();
    }

    public void setPerLevelIndent(String string) {
        this.perLevelIndentProperty.set((Object)string);
    }

    public StringProperty perLevelIndentProperty() {
        return this.perLevelIndentProperty;
    }

    public String getIndentParameterName() {
        return (String)this.indentParameterNameProperty.get();
    }

    public void setIndentParameterName(String string) {
        this.indentParameterNameProperty.set((Object)string);
    }

    public StringProperty indentParameterNameProperty() {
        return this.indentParameterNameProperty;
    }

    public String getLevelParameterName() {
        return (String)this.levelParameterNameProperty.get();
    }

    public void setILevelParameterName(String string) {
        this.levelParameterNameProperty.set((Object)string);
    }

    public StringProperty levelParameterNameProperty() {
        return this.levelParameterNameProperty;
    }

    public ObservableList<AbstractGenerationElement> getEmpty() {
        return this.emptyElements;
    }

    @Override
    boolean isSynchronous() {
        return false;
    }

    @Override
    void generate(Consumer<GenerationResult> consumer) {
        BoundListDataObject boundListDataObject = this.getIn();
        BooleanExpression booleanExpression = boundListDataObject.availableProperty();
        if (booleanExpression.get()) {
            this.aggregateRows(consumer);
        } else {
            booleanExpression.addListener(observable -> this.aggregateRows(consumer));
        }
    }

    private void aggregateRows(Consumer<GenerationResult> consumer) {
        ArrayList<DXRow> arrayList = new ArrayList<DXRow>((Collection<DXRow>)this.getIn().valueProperty());
        if (arrayList.isEmpty()) {
            this.aggregateGenerate((List<AbstractGenerationElement>)this.getEmpty(), this.getGenerationSettings(), this.getGenerationParameters(), consumer);
        } else {
            this.sortRows(arrayList);
            GenerationResult[] generationResultArray = new GenerationResult[arrayList.size()];
            int n = 0;
            int[] nArray = new int[]{generationResultArray.length};
            Map<Comparable<?>, DXRow> map = this.createRowMap(arrayList);
            for (DXRow dXRow : arrayList) {
                int n2 = n++;
                this.aggregateGenerate((List<AbstractGenerationElement>)this.getElements(), this.getGenerationSettings(), this.createRowGenerationParameters(map, dXRow), generationResult -> {
                    generationResultArray[n] = generationResult;
                    nArray[0] = nArray[0] - 1;
                    if (nArray[0] == 0) {
                        consumer.accept(this.aggregateGenerationResults(generationResultArray));
                    }
                });
            }
        }
    }

    private Map<String, Object> createRowGenerationParameters(Map<Comparable<?>, DXRow> map, DXRow dXRow) {
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.getGenerationParameters());
        if (map != null) {
            String string2;
            string = this.getParentIdColumnName();
            int n = 0;
            DXRow dXRow2 = this.getParent(map, string, dXRow);
            while (dXRow2 != null) {
                ++n;
                dXRow2 = this.getParent(map, string, dXRow2);
            }
            String string3 = this.getLevelParameterName();
            if (string3 != null) {
                hashMap.put(string3, n);
            }
            if ((string2 = this.getIndentParameterName()) != null) {
                hashMap.put(string2, this.calculateIndent(n));
            }
        }
        string = this.getRowAlias();
        hashMap.put(string, dXRow);
        return hashMap;
    }

    private void sortRows(List<DXRow> list) {
        List<SortColumn> list2;
        if (!list.isEmpty() && !(list2 = this.getSortColumns(list.get(0))).isEmpty()) {
            Collections.sort(list, (dXRow, dXRow2) -> {
                for (SortColumn sortColumn : list2) {
                    int n;
                    Comparable comparable = (Comparable)dXRow.get(sortColumn.columnName).get();
                    Comparable comparable2 = (Comparable)dXRow2.get(sortColumn.columnName).get();
                    if (comparable == null || comparable2 == null || (n = comparable.compareTo(comparable2)) == 0) continue;
                    return sortColumn.descending ? -n : n;
                }
                return 0;
            });
        }
    }

    private List<SortColumn> getSortColumns(DXRow dXRow) {
        if (this.sortNames == null) {
            String string = this.getSortBy();
            String[] stringArray = string == null || string.isEmpty() ? new String[]{} : this.getSortBy().split("\\s*\\.\\s*");
            this.sortNames = new ArrayList<SortColumn>();
            for (String string2 : stringArray) {
                boolean bl;
                String string3;
                if (string2.startsWith("+")) {
                    string3 = string2.substring(1);
                    bl = false;
                } else if (string2.startsWith("-")) {
                    string3 = string2.substring(1);
                    bl = true;
                } else {
                    string3 = string2;
                    bl = false;
                }
                if (dXRow.get(string3) == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "sort column name ''{0}'' not found", string3);
                    continue;
                }
                this.sortNames.add(new SortColumn(string3, bl));
            }
        }
        return this.sortNames;
    }

    private Map<Comparable<?>, DXRow> createRowMap(List<DXRow> list) {
        HashMap<Object, DXRow> hashMap = null;
        if (!list.isEmpty()) {
            String string = this.getIdColumnName();
            String string2 = this.getParentIdColumnName();
            if (string != null && string2 != null) {
                DXRow dXRow = list.get(0);
                if (dXRow.get(string) != null && dXRow.get(string2) != null) {
                    hashMap = new HashMap<Object, DXRow>();
                    for (DXRow dXRow2 : list) {
                        hashMap.put(dXRow2.get(string).get(), dXRow2);
                    }
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "either or both of columns ''{0}'' and ''{1}'' not found", new Object[]{string, string2});
                }
            }
        }
        return hashMap;
    }

    private DXRow getParent(Map<Comparable<?>, DXRow> map, String string, DXRow dXRow) {
        Comparable comparable;
        ObjectProperty<Comparable<?>> objectProperty = dXRow.get(string);
        if (objectProperty != null && (comparable = (Comparable)objectProperty.get()) != null) {
            return map.get(comparable);
        }
        return null;
    }

    private String calculateIndent(int n) {
        String string = this.getPerLevelIndent();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private class SortColumn {
        String columnName;
        boolean descending;

        SortColumn(String string, boolean bl) {
            this.columnName = string;
            this.descending = bl;
        }
    }
}

