/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import oracle.dbtools.raptor.metrics.panel.AbstractTemplate;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;
import oracle.dbtools.raptor.metrics.panel.GenerationSpecification;
import oracle.dbtools.raptor.metrics.panel.InstanceController;
import oracle.dbtools.raptor.metrics.panel.MapValues;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

public abstract class AbstractGenerationTemplate
extends AbstractTemplate<GenerationSpecification> {
    private InstanceController<GenerationSpecification> instanceController;

    protected String generateText(Map<String, Object> map) {
        String[] stringArray = new String[1];
        this.doGenerateText(map, true, generationResult -> {
            if (generationResult.isSuccessful()) {
                stringArray[0] = generationResult.getText();
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "generation failed: {0}", generationResult.getText());
                stringArray[0] = "";
            }
        });
        return stringArray[0];
    }

    protected void generateText(Map<String, Object> map, Consumer<GenerationResult> consumer) {
        this.doGenerateText(map, false, consumer);
    }

    protected void cancelGeneration() {
        this.doCloseGeneration();
    }

    private void doGenerateText(Map<String, Object> map, boolean bl, Consumer<GenerationResult> consumer) {
        this.instanceController = this.newInstance(map);
        if (this.instanceController != null) {
            TemplateInstance<GenerationSpecification> templateInstance = this.instanceController.getInstance();
            GenerationSpecification generationSpecification = templateInstance.getRootObject();
            if (bl && !generationSpecification.isSynchronous()) {
                consumer.accept(new GenerationResult(false, "synchronous generation expected"));
            } else {
                this.instanceController.openInstance();
                generationSpecification.generate(templateInstance.getContext(), new MapValues(map), generationResult -> {
                    if (this.doCloseGeneration()) {
                        consumer.accept((GenerationResult)generationResult);
                    }
                });
            }
        } else {
            consumer.accept(new GenerationResult(false, "unable to load generation"));
        }
    }

    private boolean doCloseGeneration() {
        if (this.instanceController != null) {
            Platform.runLater(() -> {
                if (this.instanceController != null) {
                    this.instanceController.closeInstance();
                    this.instanceController = null;
                }
            });
            return true;
        }
        return false;
    }
}

