/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlBaseItemMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlMapMapperEntry;

public class SqlMapSingleRowMapper
extends SqlBaseItemMapper<Map<String, Object>> {
    private List<SqlMapMapperEntry> entries;

    public SqlMapSingleRowMapper(SqlMapMapperEntry[] sqlMapMapperEntryArray) {
        this.entries = new ArrayList<SqlMapMapperEntry>(Arrays.asList(sqlMapMapperEntryArray));
    }

    @Override
    public Map<String, Object> mapOne(ResultSet resultSet) throws Exception {
        return this.map(resultSet);
    }

    @Override
    public Map<String, Object> map(ResultSet resultSet) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (resultSet.next()) {
            this.addEntryIfValid(resultSet, hashMap);
        }
        return hashMap;
    }

    private void addEntryIfValid(ResultSet resultSet, Map<String, Object> map) throws SQLException {
        for (SqlMapMapperEntry sqlMapMapperEntry : this.entries) {
            Object object = this.getValue(resultSet, sqlMapMapperEntry);
            map.put(sqlMapMapperEntry.getMapName(), object);
        }
    }

    private Object getValue(ResultSet resultSet, SqlMapMapperEntry sqlMapMapperEntry) throws SQLException {
        Object object = null;
        if (Integer.class.equals((Object)sqlMapMapperEntry.getDataType())) {
            object = resultSet.getInt(sqlMapMapperEntry.getResultSetName());
        } else if (Double.class.equals((Object)sqlMapMapperEntry.getDataType())) {
            object = resultSet.getDouble(sqlMapMapperEntry.getResultSetName());
        } else if (String.class.equals((Object)sqlMapMapperEntry.getDataType())) {
            object = resultSet.getString(sqlMapMapperEntry.getResultSetName());
        } else if (Object.class.equals((Object)sqlMapMapperEntry.getDataType())) {
            object = resultSet.getObject(sqlMapMapperEntry.getResultSetName());
        }
        return object;
    }
}

