/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.model.common.build.AlertEntry;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetModelViewerAlertsQuery
extends SqlBaseModelQuery<AlertEntry, OraclePreparedStatement> {
    public GetModelViewerAlertsQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlDefaultMapper<AlertEntry>(AlertEntry.class), modelDescriptor);
    }

    @Override
    public String getSQLCommand() {
        String string = "SELECT T1.PARTITION_NAME PARTITION_ID, NAME PARTITION_NAME, ERROR_TEXT MESSAGE FROM \n(SELECT * FROM {$ALERT_VIEW}) T1 LEFT OUTER JOIN \n(SELECT PARTITION_NAME, LISTAGG(COLUMN_VALUE, '_') WITHIN GROUP(ORDER BY PARTITION_NAME, POSITION) \nAS NAME FROM SYS.ALL_MINING_MODEL_PARTITIONS WHERE MODEL_NAME= :model \nGROUP BY PARTITION_NAME) T2 ON T1.PARTITION_NAME = T2.PARTITION_NAME\n";
        String string2 = "\"" + this.getSchema() + "\".\"" + ("DM$VW" + this.getModelName()).toUpperCase() + "\"";
        string2 = StringUtils.escapeSingleQuotesForSQL(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ALERT_VIEW", string2);
        String string3 = StringUtils.getReplacedString(string, hashMap);
        return string3;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        oraclePreparedStatement.setStringAtName("model", this.getModelName());
    }
}

