/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.utils;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.ORAData;

public class SqlUtils {
    private static final String FORMAT = "%s%d";
    private static final String VALUE = "{$VALUE}";
    private static final String LIKE_STARTS = "{$VALUE}%";
    private static final String LIKE_CONTAINS = "%{$VALUE}%";
    private static final String LIKE_ENDS = "%{$VALUE}";

    public static void setLikeParameter(OraclePreparedStatement oraclePreparedStatement, String string, String string2, LikeMode likeMode) throws SQLException {
        if (string2 != null) {
            String string3 = null;
            switch (likeMode) {
                case STARTS: {
                    string3 = StringUtils.getReplacedString(LIKE_STARTS, VALUE, string2);
                    break;
                }
                case CONTAINS: {
                    string3 = StringUtils.getReplacedString(LIKE_CONTAINS, VALUE, string2);
                    break;
                }
                case ENDS: {
                    string3 = StringUtils.getReplacedString(LIKE_ENDS, VALUE, string2);
                    break;
                }
                default: {
                    assert (false) : "LIKE mode is not supported.";
                    break;
                }
            }
            oraclePreparedStatement.setStringAtName(string, string3);
        }
    }

    public static void setStringParameterList(OraclePreparedStatement oraclePreparedStatement, String string, List<String> list) throws SQLException {
        int n = 0;
        for (String string2 : list) {
            oraclePreparedStatement.setStringAtName(String.format(FORMAT, string, n++), string2);
        }
    }

    public static void setIntParameterList(OraclePreparedStatement oraclePreparedStatement, String string, List<Integer> list) throws SQLException {
        int n = 0;
        for (Integer n2 : list) {
            oraclePreparedStatement.setIntAtName(String.format(FORMAT, string, n++), n2.intValue());
        }
    }

    public static void setLongParameterList(OraclePreparedStatement oraclePreparedStatement, String string, List<Long> list) throws SQLException {
        int n = 0;
        for (Long l : list) {
            oraclePreparedStatement.setLongAtName(String.format(FORMAT, string, n++), l.longValue());
        }
    }

    public static void setDoubleParameterList(OraclePreparedStatement oraclePreparedStatement, String string, List<Double> list) throws SQLException {
        int n = 0;
        for (Double d : list) {
            oraclePreparedStatement.setDoubleAtName(String.format(FORMAT, string, n++), d.doubleValue());
        }
    }

    public static void setBigDecimalParameterList(OraclePreparedStatement oraclePreparedStatement, String string, List<BigDecimal> list) throws SQLException {
        int n = 0;
        for (BigDecimal bigDecimal : list) {
            oraclePreparedStatement.setBigDecimalAtName(String.format(FORMAT, string, n++), bigDecimal);
        }
    }

    public static final void setIntOrNullAtName(OraclePreparedStatement oraclePreparedStatement, String string, Integer n) throws SQLException {
        boolean bl;
        boolean bl2 = bl = !SqlUtils.setIntAtName(oraclePreparedStatement, string, n);
        if (bl) {
            oraclePreparedStatement.setNullAtName(string, 4);
        }
    }

    public static final boolean setIntAtName(OraclePreparedStatement oraclePreparedStatement, String string, Integer n) throws SQLException {
        boolean bl;
        boolean bl2 = bl = n != null;
        if (bl) {
            oraclePreparedStatement.setIntAtName(string, n.intValue());
        }
        return bl;
    }

    public static final void setDoubleOrNullAtName(OraclePreparedStatement oraclePreparedStatement, String string, Double d) throws SQLException {
        boolean bl;
        boolean bl2 = bl = !SqlUtils.setDoubleAtName(oraclePreparedStatement, string, d);
        if (bl) {
            oraclePreparedStatement.setNullAtName(string, 8);
        }
    }

    public static final boolean setDoubleAtName(OraclePreparedStatement oraclePreparedStatement, String string, Double d) throws SQLException {
        boolean bl;
        boolean bl2 = bl = d != null;
        if (bl) {
            oraclePreparedStatement.setDoubleAtName(string, d.doubleValue());
        }
        return bl;
    }

    public static final void setStringOrNullAtName(OraclePreparedStatement oraclePreparedStatement, String string, String string2) throws SQLException {
        boolean bl;
        boolean bl2 = bl = !SqlUtils.setStringAtName(oraclePreparedStatement, string, string2);
        if (bl) {
            oraclePreparedStatement.setNullAtName(string, 12);
        }
    }

    public static final boolean setStringAtName(OraclePreparedStatement oraclePreparedStatement, String string, String string2) throws SQLException {
        boolean bl;
        boolean bl2 = bl = string2 != null;
        if (bl) {
            oraclePreparedStatement.setStringAtName(string, string2);
        }
        return bl;
    }

    public static final void setORADataOrNullAtName(OraclePreparedStatement oraclePreparedStatement, String string, int n, String string2, ORAData oRAData) throws SQLException {
        boolean bl;
        boolean bl2 = bl = !SqlUtils.setORADataAtName(oraclePreparedStatement, string, oRAData);
        if (bl) {
            oraclePreparedStatement.setNullAtName(string, n, string2);
        }
    }

    public static final boolean setORADataAtName(OraclePreparedStatement oraclePreparedStatement, String string, ORAData oRAData) throws SQLException {
        boolean bl = false;
        if (oRAData != null) {
            oraclePreparedStatement.setORADataAtName(string, oRAData);
            bl = true;
        }
        return bl;
    }

    public static enum LikeMode {
        STARTS,
        CONTAINS,
        ENDS;

    }
}

