/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.connection;

import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.ide.net.URIFactory;
import javax.xml.bind.DatatypeConverter;
import oracle.dbtools.raptor.onsd.connection.NSConnectionInfo;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

class Storage
extends HashStructureAdapter {
    private static final String KEY = "ONSD_CONNECTIONS";
    private static final String CONNECTIONS = "ConnectionsList";
    private static final String ENCODING = "UTF-8";

    static Storage getInstance() {
        return new Storage(Storage.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)KEY));
    }

    private Storage(HashStructure hashStructure) {
        super(hashStructure);
    }

    String[] listConnections(String string) {
        HashStructure hashStructure = this.getConnectionsHash(string, false);
        if (hashStructure != null) {
            Set set = hashStructure.keySet();
            return set.toArray(new String[0]);
        }
        return new String[0];
    }

    private HashStructure getConnectionsHash(String string, boolean bl) {
        HashStructure hashStructure = null;
        if (bl) {
            HashStructure hashStructure2 = this._hash.getOrCreateHashStructure(CONNECTIONS);
            hashStructure = hashStructure2.getOrCreateHashStructure(string);
        } else {
            HashStructure hashStructure3 = this._hash.getHashStructure(CONNECTIONS);
            if (hashStructure3 != null) {
                hashStructure = hashStructure3.getHashStructure(string);
            }
        }
        return hashStructure;
    }

    NSConnectionInfo getOnsdConnection(String string, String string2) {
        HashStructure hashStructure;
        NSConnectionInfo nSConnectionInfo = null;
        HashStructure hashStructure2 = this.getConnectionsHash(string, false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string2)) != null) {
            nSConnectionInfo = this.createConnectionInfo(string2, hashStructure);
        }
        return nSConnectionInfo;
    }

    protected NSConnectionInfo createConnectionInfo(String string, HashStructure hashStructure) {
        Object object;
        Boolean bl;
        NSConnectionInfo.TransportInfo transportInfo;
        HashStructure hashStructure2;
        String string2 = hashStructure.getString("Hosts");
        String string3 = hashStructure.getString("StoreName");
        String string4 = hashStructure.getString("User");
        char[] cArray = null;
        String string5 = hashStructure.getString("Password");
        if (string5 != null) {
            cArray = Wrapper.INSTANCE.decrypt(string5);
        }
        if ((hashStructure2 = hashStructure.getHashStructure("TransportDetails")) == null) {
            transportInfo = null;
        } else {
            bl = hashStructure2.getBoolean("TransportSSL");
            object = hashStructure2.getURL("TransportSSLKeyFile");
            transportInfo = new NSConnectionInfo.TransportInfo(bl, (URL)object);
        }
        bl = hashStructure.getHashStructure("SecurityDetails");
        if (bl == null) {
            object = null;
        } else {
            URL uRL = bl.getURL("SecurityPropFile");
            URL uRL2 = bl.getURL("SecurityWalletDir");
            URL uRL3 = bl.getURL("SecurityPWDFile");
            object = new NSConnectionInfo.SecurityInfo(uRL, uRL2, uRL3);
        }
        NSConnectionInfo nSConnectionInfo = new NSConnectionInfo(string, string2, string3, string4, cArray, transportInfo, (NSConnectionInfo.SecurityInfo)object);
        return nSConnectionInfo;
    }

    private static URI toURI(String string) {
        return string != null ? URIFactory.newURI((String)string) : null;
    }

    private static String toURL(URI uRI) {
        return uRI != null ? uRI.toString() : null;
    }

    void putOnsdConnection(String string, NSConnectionInfo nSConnectionInfo) {
        Object object;
        NSConnectionInfo.TransportInfo transportInfo;
        HashStructure hashStructure = this.getConnectionsHash(string, true);
        HashStructure hashStructure2 = HashStructure.newInstance();
        hashStructure2.putString("Hosts", nSConnectionInfo.getHosts());
        hashStructure2.putString("StoreName", nSConnectionInfo.getStoreName());
        hashStructure2.putString("User", nSConnectionInfo.getUsername());
        char[] cArray = nSConnectionInfo.getPassword();
        if (cArray != null) {
            hashStructure2.putString("Password", Wrapper.INSTANCE.encrypt(cArray));
        }
        if ((transportInfo = nSConnectionInfo.getTransportInfo()) != null) {
            object = HashStructure.newInstance();
            object.putBoolean("TransportSSL", transportInfo.getUseSSL().booleanValue());
            object.putURL("TransportSSLKeyFile", transportInfo.getKeyFile());
            hashStructure2.putHashStructure("TransportDetails", (HashStructure)object);
        }
        if ((object = nSConnectionInfo.getSecurityInfo()) != null) {
            HashStructure hashStructure3 = HashStructure.newInstance();
            hashStructure3.putURL("SecurityPropFile", ((NSConnectionInfo.SecurityInfo)object).getPropertyFile());
            hashStructure3.putURL("SecurityWalletDir", ((NSConnectionInfo.SecurityInfo)object).getWalletDir());
            hashStructure3.putURL("SecurityPWDFile", ((NSConnectionInfo.SecurityInfo)object).getPWDFile());
            hashStructure2.putHashStructure("SecurityDetails", hashStructure3);
        }
        hashStructure.putHashStructure(nSConnectionInfo.getName(), hashStructure2);
    }

    void removeOnsdConnection(String string, String string2) {
        HashStructure hashStructure = this.getConnectionsHash(string, false);
        if (hashStructure != null) {
            hashStructure.remove(string2);
        }
    }

    void migrateConnections() {
        HashStructure hashStructure = this.getConnectionsHash("OnsdType", false);
        if (hashStructure != null) {
            HashMap<String, NSConnectionInfo> hashMap = new HashMap<String, NSConnectionInfo>();
            for (String string : hashStructure.keySet()) {
                NSConnectionInfo nSConnectionInfo;
                HashStructure hashStructure2 = hashStructure.getHashStructure(string);
                if (hashStructure2 == null || (nSConnectionInfo = this.createConnectionInfo(string, hashStructure2)) == null) continue;
                hashMap.put(string, nSConnectionInfo);
            }
            NSConnections.migrateConnections(hashMap);
            this._hash.remove(CONNECTIONS);
        }
    }

    private static final class Wrapper {
        static final Wrapper INSTANCE;
        private static final int ITERATION_COUNT = 42;
        private Cipher m_encoder;
        private Cipher m_decoder;
        private byte[] salt = new byte[]{5, 19, -103, 66, -109, 114, -24, -83};
        private AlgorithmParameterSpec m_paramSpec;
        private SecretKey key;
        private Charset m_charset;
        private CharsetEncoder m_charEnc;
        private CharsetDecoder m_charDec;

        Wrapper(String string) {
            try {
                PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), this.salt, 42);
                this.key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
                this.m_paramSpec = new PBEParameterSpec(this.salt, 42);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            this.m_charset = Charset.forName(Storage.ENCODING);
        }

        String encrypt(char[] cArray) {
            byte[] byArray = null;
            try {
                if (this.m_encoder == null) {
                    this.m_encoder = Cipher.getInstance(this.key.getAlgorithm());
                    this.m_encoder.init(1, (Key)this.key, this.m_paramSpec);
                }
                if (this.m_charEnc == null) {
                    this.m_charEnc = this.m_charset.newEncoder();
                }
                byte[] byArray2 = this.m_charEnc.encode(CharBuffer.wrap(cArray)).array();
                byArray = this.m_encoder.doFinal(byArray2);
                return DatatypeConverter.printBase64Binary((byte[])byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        char[] decrypt(String string) {
            try {
                if (this.m_decoder == null) {
                    this.m_decoder = Cipher.getInstance(this.key.getAlgorithm());
                    this.m_decoder.init(2, (Key)this.key, this.m_paramSpec);
                }
                byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
                byte[] byArray2 = this.m_decoder.doFinal(byArray);
                if (this.m_charDec == null) {
                    this.m_charDec = this.m_charset.newDecoder();
                }
                CharBuffer charBuffer = this.m_charDec.decode(ByteBuffer.wrap(byArray2));
                return charBuffer.array();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        static {
            HashStructure hashStructure = Preferences.getPreferences().getProperties();
            String string = hashStructure.getString("db.system.id");
            if (string == null) {
                string = UUID.randomUUID().toString();
                hashStructure.putString("db.system.id", string);
            }
            INSTANCE = new Wrapper(string);
        }
    }
}

