/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnectionException;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;

public class OnsdConnection
extends BaseConnectionNode<NSConnection> {
    public static OnsdConnection findConnectionNode(URL uRL) {
        return (OnsdConnection)OnsdConnection.findConnectionNodeImpl((URL)uRL);
    }

    public static OnsdConnection findOrCreateConnectionNode(URL uRL) {
        return (OnsdConnection)OnsdConnection.findOrCreateConnectionNodeImpl((URL)uRL, OnsdConnection.class);
    }

    public String getQualifiedConnectionName() {
        return DBURLFormatHelper.getConnectionName((URL)this.getURL());
    }

    protected NSConnection openConnectionImpl() throws IOException {
        NSConnection nSConnection = null;
        try {
            nSConnection = NSConnections.getInstance().getConnection(this.getQualifiedConnectionName(), true);
            if (nSConnection == null) {
                throw new BaseConnectionNode.ExceptionWrapper((Throwable)new ConnectionCanceledException());
            }
        }
        catch (NSConnectionException nSConnectionException) {
            Throwable throwable = nSConnectionException.getCause();
            if (throwable != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new BaseConnectionNode.ExceptionWrapper(throwable);
            }
            throw new BaseConnectionNode.ExceptionWrapper((Throwable)nSConnectionException);
        }
        return nSConnection;
    }

    protected boolean closeConnectionImpl() {
        return NSConnections.getInstance().closeConnection(this.getQualifiedConnectionName());
    }

    public String getShortLabel() {
        return this.getQualifiedConnectionName();
    }

    public Icon getIcon() {
        if (this.isConnectionOpen()) {
            return OnsdBrowserResources.getIcon("ONSD_OPEN_ICON");
        }
        return OnsdBrowserResources.getIcon("ONSD_ICON");
    }

    public String getConnectionName() {
        return Connections.getConnectionName((String)this.getQualifiedConnectionName());
    }

    public String getStoreName() {
        return Connections.getStoreName((String)this.getQualifiedConnectionName());
    }
}

