/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.awt.Component;
import oracle.dbtools.raptor.onsd.navigator.OnsdConnection;
import oracle.dbtools.raptor.onsd.navigator.OnsdConnections;
import oracle.dbtools.raptor.onsd.navigator.OnsdController;
import oracle.dbtools.raptor.onsd.navigator.OnsdFolder;
import oracle.dbtools.raptor.onsd.navigator.OnsdObject;
import oracle.dbtools.raptor.onsd.navigator.OnsdTable;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.jdeveloper.JDeveloperMenuConstants;

public final class OnsdContextMenuListener
implements ContextMenuListener {
    private boolean onsdDDL = OnsdContextMenuListener.getSystemBoolean("sqldev.onsdDDL", false);

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            return;
        }
        boolean bl = elementArray.length > 1;
        Element element = elementArray[0];
        if (element instanceof OnsdConnections) {
            this.addMenuItem((MenuManager)contextMenu, OnsdController.NEW_ONSD_CONN_CMD_ID, 1.0f);
        } else if (element instanceof OnsdConnection) {
            if (!bl) {
                this.addMenuItem((MenuManager)contextMenu, OnsdController.CONNECT_CMD_ID, 1.0f, 1.0f);
                this.addMenuItem((MenuManager)contextMenu, OnsdController.DISCONNECT_CMD_ID, 1.1f, 1.0f);
                this.addMenuItem((MenuManager)contextMenu, 56, 1.1f, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
            this.addMenuItem((MenuManager)contextMenu, 20, 1.0f);
        } else if (element instanceof OnsdTable) {
            if (this.onsdDDL) {
                this.addMenuItem((MenuManager)contextMenu, OnsdController.DELETE_CMD_ID, 1.0f);
            }
        } else if (element instanceof OnsdObject) {
            if (!bl) {
                ((OnsdObject)element).register();
                this.addMenuItem((MenuManager)contextMenu, OnsdController.OPEN_OBJECT_CMD_ID, 1.0f, 1.0f);
            }
            if (((OnsdObject)element).getTypeName().equals("DEPLOYMENTS")) {
                this.addMenuItem((MenuManager)contextMenu, OnsdController.STATUS_CMD_ID, 1.0f, 1.0f);
                this.addMenuItem((MenuManager)contextMenu, OnsdController.LOG_CMD_ID, 1.0f, 1.0f);
                this.addMenuItem((MenuManager)contextMenu, OnsdController.DELETE_CMD_ID, 1.0f, 1.0f);
            }
        } else if (element instanceof OnsdFolder && !bl && this.onsdDDL) {
            this.addMenuItem((MenuManager)contextMenu, OnsdController.NEW_OBJECT_CMD_ID, 1.0f, 1.0f);
        }
    }

    private void addMenuItem(MenuManager menuManager, int n, float f) {
        this.addMenuItem(menuManager, n, Float.MAX_VALUE, f);
    }

    private void addMenuItem(MenuManager menuManager, int n, float f, float f2) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            menuManager.add((Component)menuManager.createMenuItem((ToggleAction)ideAction, f), f2);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static boolean getSystemBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                bl2 = Boolean.parseBoolean(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl2;
    }
}

