/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeSupport;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnectionEvent;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.connection.NSConnectionsListener;
import oracle.dbtools.raptor.onsd.navigator.OnsdConnection;
import oracle.dbtools.raptor.onsd.navigator.OnsdConnections;
import oracle.dbtools.raptor.onsd.navigator.OnsdController;
import oracle.dbtools.raptor.onsd.navigator.OnsdObject;
import oracle.ide.controller.Controller;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class OnsdSupport
extends DatabaseTypeSupport {
    public Controller createController(DBNavigatorWindow dBNavigatorWindow) {
        return OnsdController.getInstance();
    }

    public DatabaseTypeRoot getRoot() {
        return Holder.INSTANCE;
    }

    public void registerViewers(ViewableElement viewableElement) {
        if (viewableElement instanceof OnsdObject) {
            ((OnsdObject)viewableElement).register();
        }
    }

    protected String getID() {
        return "sqldev.onsd";
    }

    protected int getNewCommandID() {
        return OnsdController.NEW_ONSD_CONN_CMD_ID;
    }

    protected String getNewLabelForSubmenu() {
        return OnsdBrowserResources.getString("NEW_CONN_SUBMENU_TITLE");
    }

    protected <T> BaseConnectionNode<T> getConnectionNode(String string, boolean bl) {
        return null;
    }

    protected int getWeight() {
        return 10;
    }

    private static final class Holder {
        static OnsdConnections INSTANCE = new OnsdConnections();

        private Holder() {
        }

        static {
            NSConnections nSConnections = NSConnections.getInstance();
            for (String string : nSConnections.listConnections()) {
                OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, true);
                if (onsdConnection == null) continue;
                INSTANCE.add((Element)onsdConnection);
            }
            nSConnections.addListener(new NSConnectionsListener(){

                @Override
                public void connectionAdded(NSConnectionEvent nSConnectionEvent) {
                    String string = nSConnectionEvent.getConnectionName();
                    OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, true);
                    if (onsdConnection != null && INSTANCE.add((Element)onsdConnection)) {
                        UpdateMessage.fireChildAdded((Subject)INSTANCE, (Element)onsdConnection);
                    }
                }

                @Override
                public void connectionRemoved(NSConnectionEvent nSConnectionEvent) {
                    String string = nSConnectionEvent.getConnectionName();
                    OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, false);
                    if (onsdConnection != null && INSTANCE.remove((Element)onsdConnection)) {
                        UpdateMessage.fireChildRemoved((Subject)INSTANCE, (Element)onsdConnection);
                    }
                }

                @Override
                public void connectionModified(NSConnectionEvent nSConnectionEvent) {
                }

                @Override
                public void connectionOpened(NSConnectionEvent nSConnectionEvent) {
                    String string = nSConnectionEvent.getConnectionName();
                    OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, false);
                    if (onsdConnection != null && onsdConnection.openConnection()) {
                        UpdateMessage.fireObjectOpened((Subject)onsdConnection);
                    }
                }

                @Override
                public void connectionClosed(NSConnectionEvent nSConnectionEvent) {
                    String string = nSConnectionEvent.getConnectionName();
                    OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, false);
                    if (onsdConnection != null && onsdConnection.isConnectionOpen()) {
                        onsdConnection.closeConnection(false);
                        UpdateMessage.fireObjectClosed((Subject)onsdConnection);
                    }
                }
            });
        }
    }
}

