/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.oviewer;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.raptor.onsd.controls.display.DisplayOnsdIterator;
import oracle.dbtools.raptor.onsd.navigator.OnsdObject;
import oracle.dbtools.raptor.onsd.oviewer.BasicOnsdEditorAddin;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public class BasicOnsdEditor
extends AsynchronousViewerEditor
implements Controller {
    DisplayOnsdIterator _display = null;
    private JPanel _gui = null;
    private IdeAction _refreshAction;
    public static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_XML_Editor");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_EDITOR_CMD_ID) {
            this.updateContent(false);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        View view = context.getView();
        int n = ideAction.getCommandId();
        if (view == this && n == REFRESH_EDITOR_CMD_ID) {
            bl = true;
        }
        return bl;
    }

    private void refreshDetails(boolean bl) {
        this._display.refresh(bl);
    }

    protected JComponent createViewerUI() {
        if (this._gui == null) {
            if (this._display == null) {
                BasicOnsdEditorAddin basicOnsdEditorAddin = (BasicOnsdEditorAddin)this.getEditorAddin();
                try {
                    this._display = basicOnsdEditorAddin.getDisplayClass().newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
                this._display.setUriString(basicOnsdEditorAddin.getUriString());
                OnsdObject onsdObject = (OnsdObject)((ViewerNode)this.getContext().getNode()).getDBObject().getNode();
                this._display.setConnName(onsdObject.getConnectionName());
                this._display.setView((View)this);
                this._display.setToolbar(this.getToolbar());
            }
            this._gui = new JPanel();
            this._gui.setLayout(new BorderLayout());
            this._gui.add(this._display.getScrollableUI());
        }
        return this._gui;
    }

    protected void updateContent(boolean bl) {
        this.refreshDetails(bl);
    }

    protected void cleanUp() {
        this._gui = null;
    }

    public Object getPrintable() {
        return this._gui;
    }

    protected void updateContextImpl(Context context) {
        super.updateContextImpl(context);
    }
}

