/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.ModelUtil;

class DDLStatementWrapper
extends StatementWrapper {
    private final DDL m_ddl;
    private ExceptionHandler m_handler;

    public DDLStatementWrapper(Database database, DDL<? extends DDLType> dDL) {
        super(database, true, (String[])null);
        Collection<String> collection = dDL.getStatements();
        this.setStatement(collection.toArray(new String[dDL.size()]));
        this.m_ddl = dDL;
    }

    @Override
    protected Statement createStatment() throws SQLException {
        Statement statement = super.createStatment();
        try {
            statement.setEscapeProcessing(false);
        }
        catch (SQLException sQLException) {
            DBLog.getLogger(this).fine("setEscapeProcessing: " + sQLException.getMessage());
        }
        return statement;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.m_handler = exceptionHandler;
    }

    @Override
    public boolean execute() throws DBException {
        if (this.m_ddl == null || this.m_ddl.size() == 0) {
            return false;
        }
        return this.doExecute(new StatementWrapper.ExecutionRunnable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean runImpl() throws DBException {
                var1_1 = false;
                var2_2 = DDLStatementWrapper.access$000(DDLStatementWrapper.this);
                synchronized (var2_2) {
                    DDLStatementWrapper.access$100(DDLStatementWrapper.this, true);
                    try {
                        var1_1 = true;
                        var3_3 = DDLStatementWrapper.access$200(DDLStatementWrapper.this).getStatementsForExecution();
                        var4_4 = var3_3.values().iterator();
                        block7: while (true) {
                            if (var4_4.hasNext() == false) return var1_1;
                            var5_5 = var4_4.next();
                            if (var5_5 == null) continue;
                            var6_6 = var5_5.iterator();
                            while (true) {
                                if (var6_6.hasNext()) ** break;
                                continue block7;
                                var7_7 = var6_6.next();
                                var8_8 = var7_7.getStatement();
                                if (!ModelUtil.hasLength((String)var8_8)) continue;
                                try {
                                    var1_1 = DDLStatementWrapper.access$300(DDLStatementWrapper.this, var8_8) != false || var1_1 != false;
                                }
                                catch (SQLException var9_9) {
                                    if (DDLStatementWrapper.access$400(DDLStatementWrapper.this)) continue;
                                    var10_10 = DDLStatementWrapper.access$500(DDLStatementWrapper.this, var7_7.getObject(), var8_8, var9_9);
                                    if (DDLStatementWrapper.access$600(DDLStatementWrapper.this) == null) throw var10_10;
                                    DDLStatementWrapper.access$600(DDLStatementWrapper.this).handleException(var10_10);
                                }
                            }
                            break;
                        }
                    }
                    finally {
                        DDLStatementWrapper.this.close();
                        DDLStatementWrapper.access$700(DDLStatementWrapper.this, false);
                    }
                }
            }
        });
    }

    static /* synthetic */ Connection access$000(DDLStatementWrapper dDLStatementWrapper) {
        return dDLStatementWrapper.getConnection();
    }

    static /* synthetic */ void access$100(DDLStatementWrapper dDLStatementWrapper, boolean bl) {
        dDLStatementWrapper.setExecuting(bl);
    }

    static /* synthetic */ DDL access$200(DDLStatementWrapper dDLStatementWrapper) {
        return dDLStatementWrapper.m_ddl;
    }

    static /* synthetic */ boolean access$300(DDLStatementWrapper dDLStatementWrapper, String string) throws SQLException {
        return dDLStatementWrapper.executeImpl(string);
    }

    static /* synthetic */ boolean access$400(DDLStatementWrapper dDLStatementWrapper) {
        return dDLStatementWrapper.isIgnoreErrors();
    }

    static /* synthetic */ DBSQLException access$500(DDLStatementWrapper dDLStatementWrapper, DBObject dBObject, String string, SQLException sQLException) {
        return dDLStatementWrapper.createDBSQLException(dBObject, string, sQLException);
    }

    static /* synthetic */ ExceptionHandler access$600(DDLStatementWrapper dDLStatementWrapper) {
        return dDLStatementWrapper.m_handler;
    }

    static /* synthetic */ void access$700(DDLStatementWrapper dDLStatementWrapper, boolean bl) {
        dDLStatementWrapper.setExecuting(bl);
    }

    public static abstract class ExceptionHandler {
        public abstract void handleException(DBSQLException var1) throws DBException;
    }
}

