/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Arrays;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.ObjectTypeBundle;
import oracle.javatools.db.resource.PropertyBundle;

public class DisplayNames {
    private static final Collection<String> PROPERTY_SUFFIXES = Arrays.asList("Fragment", "Source", "ID");

    public static String getTypeDisplayName(String string) {
        try {
            return ObjectTypeBundle.get(DisplayNames.getTypeKey(string));
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getTypePluralName(String string) {
        try {
            return ObjectTypeBundle.get(DisplayNames.getTypeKey(string) + "_plural");
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static String getTypeKey(String string) {
        return string.replaceAll(" ", "_");
    }

    public static String getPropertyDisplayName(String string) {
        String string2 = DisplayNames.getPropertyDisplayName(string, PropertyBundle.getBundle());
        return string2 == null ? string : string2;
    }

    public static String getPropertyDisplayName(String string, ResourceBundle resourceBundle) {
        String string2 = Property.getLastProperty(string);
        try {
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            for (String string3 : PROPERTY_SUFFIXES) {
                if (!string2.endsWith(string3)) continue;
                try {
                    String string4 = string2.substring(0, string2.length() - string3.length());
                    return PropertyBundle.get(string4);
                }
                catch (MissingResourceException missingResourceException2) {
                }
            }
            return null;
        }
    }
}

