/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;

public class ArithmeticOperation
extends Operation {
    public ArithmeticOperation() {
        this(ArithmeticOperator.ADD, null);
    }

    public ArithmeticOperation(ArithmeticOperator arithmeticOperator, SQLFragment[] sQLFragmentArray) {
        this.setArguments(sQLFragmentArray);
        this.setOperator(arithmeticOperator);
        this.setFunctionFormat(false);
    }

    public ArithmeticOperator getOperator() {
        return (ArithmeticOperator)((Object)this.getProperty("operator"));
    }

    public void setOperator(ArithmeticOperator arithmeticOperator) {
        this.setProperty("operator", (Object)arithmeticOperator);
        this.setCommutative(arithmeticOperator == null ? false : arithmeticOperator.isCommutative());
    }

    @Override
    public String getSQLText() {
        String string = null;
        ArithmeticOperator arithmeticOperator = this.getOperator();
        if (ArithmeticOperator.NEGATE == arithmeticOperator) {
            string = this.getOperatorText() + this.getArguments()[0].getSQLText();
        } else if (arithmeticOperator != null) {
            StringBuilder stringBuilder = new StringBuilder();
            SQLFragment[] sQLFragmentArray = this.getArguments();
            int n = arithmeticOperator.m_precedence;
            for (int i = 0; i < sQLFragmentArray.length; ++i) {
                Object object;
                int n2;
                boolean bl = false;
                if (sQLFragmentArray[i] instanceof ArithmeticOperation && ((n2 = (object = ((ArithmeticOperation)sQLFragmentArray[i]).getOperator()) == null ? 1000 : ((ArithmeticOperator)object).m_precedence) < n || i > 0 && n2 == n && arithmeticOperator != object && (arithmeticOperator == ArithmeticOperator.SUBTRACT || arithmeticOperator == ArithmeticOperator.DIVIDE))) {
                    bl = true;
                }
                object = this.getTextOrNull(sQLFragmentArray[i]);
                if (bl) {
                    object = this.surroundWithBrackets((String)object, true);
                }
                stringBuilder.append((String)object);
                if (i >= sQLFragmentArray.length - 1) continue;
                stringBuilder.append(" ");
                stringBuilder.append(this.getOperatorText());
                stringBuilder.append(" ");
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String getOperatorText() {
        ArithmeticOperator arithmeticOperator = this.getOperator();
        return arithmeticOperator == null ? null : arithmeticOperator.getSQLText();
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        ArithmeticOperator arithmeticOperator;
        ArithmeticOperation arithmeticOperation = (ArithmeticOperation)abstractDBObject;
        boolean bl = super.equalsImpl(arithmeticOperation);
        if (!bl && (arithmeticOperator = this.getOperator()) != null && arithmeticOperator.isCommutative() && arithmeticOperator == arithmeticOperation.getOperator() && this.getArgumentCount() == 2 && arithmeticOperation.getArgumentCount() == 2) {
            bl = this.getArguments()[0].equals(arithmeticOperation.getArguments()[1]) && this.getArguments()[1].equals(arithmeticOperation.getArguments()[0]);
        }
        return bl;
    }

    @Override
    public DBObjectID getDataTypeID() {
        DBObjectID dBObjectID = null;
        if (this.getArguments()[0] instanceof SQLFragmentWithDatatype) {
            dBObjectID = ((SQLFragmentWithDatatype)this.getArguments()[0]).getDataTypeID();
        }
        if (dBObjectID == null && this.getArguments()[1] instanceof SQLFragmentWithDatatype) {
            dBObjectID = ((SQLFragmentWithDatatype)this.getArguments()[1]).getDataTypeID();
        }
        return dBObjectID;
    }

    public static ArithmeticOperator getArithmeticOperator(String string, int n) {
        ArithmeticOperator arithmeticOperator = null;
        for (ArithmeticOperator arithmeticOperator2 : ArithmeticOperator.values()) {
            if (!arithmeticOperator2.getSQLText().equals(string)) continue;
            arithmeticOperator = arithmeticOperator2;
            break;
        }
        if (arithmeticOperator == ArithmeticOperator.SUBTRACT && n == 1) {
            arithmeticOperator = ArithmeticOperator.NEGATE;
        } else if (arithmeticOperator == ArithmeticOperator.NEGATE && n == 2) {
            arithmeticOperator = ArithmeticOperator.SUBTRACT;
        }
        return arithmeticOperator;
    }

    public static enum ArithmeticOperator {
        ADD("+", true, 1, 10),
        SUBTRACT("-", false, 1, 11),
        MULTIPLY("*", true, 2, 12),
        DIVIDE("/", false, 2, 13),
        NEGATE("-", false, 3, 14);

        private final String m_sql;
        private final boolean m_commutative;
        private final int m_oldValue;
        private final int m_precedence;

        private ArithmeticOperator(String string2, boolean bl, int n2, int n3) {
            this.m_sql = string2;
            this.m_commutative = bl;
            this.m_precedence = n2;
            this.m_oldValue = n3;
        }

        public String getSQLText() {
            return this.m_sql;
        }

        public boolean isCommutative() {
            return this.m_commutative;
        }

        public static ArithmeticOperator migrate(String string) {
            ArithmeticOperator arithmeticOperator = null;
            if (string != null) {
                for (ArithmeticOperator arithmeticOperator2 : ArithmeticOperator.values()) {
                    if (!string.equals(String.valueOf(arithmeticOperator2.m_oldValue))) continue;
                    arithmeticOperator = arithmeticOperator2;
                    break;
                }
            }
            return arithmeticOperator;
        }
    }
}

