/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.help.CustomProtocolHandler;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.FindSupport;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ICEBrowser;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.library.Library;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.CustomProtocolRegistry;
import oracle.help.topicDisplay.SimpleTopicDisplayPanel;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.controls.WashedIcon;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.MiniSearchDialog;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.help.AbstractCustomProtocolHandler;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpExtArb;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevTOCNavigator;

public class HelpContentPanel
extends View
implements TopicDisplayListener,
ContextMenuListener {
    private Object _parent;
    private HTMLBrowser _browser;
    private TopicDisplay _topicDisplay;
    private SimpleTopicDisplayPanel _displayPanel;
    private boolean _helpSystemDependent;
    private boolean _syncTOCWithSelection;
    private Library _library;
    private IdeAction _backwardAction;
    private ToolButton _backwardBtn;
    private JMenuItem _backwardMenu;
    private IdeAction _forwardAction;
    private ToolButton _forwardBtn;
    private IdeAction _copyAction;
    private JMenuItem _forwardMenu;
    private IdeAction _printAction;
    private ToolButton _printBtn;
    private JMenuItem _printMenu;
    private IdeAction _findAction;
    private ToolButton _findBtn;
    private JMenuItem _findMenu;
    private JMenuItem _copyMenu;
    private JPanel _mainPanel;
    private Controller _controller;
    Toolbar _toolbar;
    private ContextMenu _contextMenu;
    private IdeAction _contextMenuAction;
    private IdeAction _exitAction;
    private IdeAction _selectAllAction;
    private JMenuItem _selectAllMenu;
    private IdeAction _addFavoriteAction;
    private ToolButton _addFavoriteBtn;
    private JMenuItem _addFavoriteMenu;
    private MenuToolButton _changeFontSizeBtn;
    private boolean _displayToolbar = true;
    private ChangeListener _changeListener;
    private ContextMenu _activeContextMenu;
    private IdeAction _increaseFontSizeAction;
    private JMenuItem _increaseFontSizeMenu;
    private IdeAction _decreaseFontSizeAction;
    private JMenuItem _decreaseFontSizeMenu;
    private IdeAction _closeTabAction;
    private JMenuItem _closeTabMenu;
    private MiniSearchDialog _findDialog;
    private SearchListener _findDialogSearchListener;
    private static String _findDialogSearchText;
    private ContainerListener _containerListener;
    private Component _keyListenerComponent;
    private KeyListener _keyListener;
    private URLListener _browserURLListener;
    private Component _mouseListenerComponent;
    private MouseListener _mouseListener;
    private static final List<Pair> _protocolRegistryList;
    private static final String VIEWID_STRING = "HelpSystemAddin.HelpContentPanel";
    private static final Class HTML_BROWSER_CLASS;
    private static final String TAB_ACTION = "oracle.jdevimpl.help.HelpContentPanel.TabAction";

    public HelpContentPanel(Library library, boolean syncTOCWithSelection, boolean displayedInModalDialog, Object parent) {
        super(VIEWID_STRING);
        this._library = library;
        this._helpSystemDependent = true;
        this._syncTOCWithSelection = syncTOCWithSelection;
        this._parent = parent;
        this._init();
    }

    public HelpContentPanel(Library library, boolean syncTOCWithSelection, Object parent) {
        this(library, syncTOCWithSelection, false, parent);
    }

    public HelpContentPanel(Library library, Object parent) {
        this(library, true, false, parent);
    }

    public HelpContentPanel(Object parent) {
        this(parent, false);
    }

    public HelpContentPanel(Object parent, boolean displayToolbar) {
        super(VIEWID_STRING);
        this._parent = parent;
        this._helpSystemDependent = false;
        this._displayToolbar = displayToolbar;
        this._init();
    }

    public HelpContentPanel(JEWTDialog parent) {
        super(VIEWID_STRING);
        this._parent = parent;
        this._helpSystemDependent = false;
        this._displayToolbar = false;
        this._init();
    }

    public void displayTopic(Topic topic) {
        try {
            this._displayPanel.displayTopic(topic);
        }
        catch (Exception e) {
            String topicId = null;
            if (topic.hasTarget() && topic.getTarget() instanceof IndirectTarget) {
                IndirectTarget iTarget = (IndirectTarget)topic.getTarget();
                topicId = iTarget.getTargetName();
            }
            Assert.println((String)("Failed to find URL for topic: " + topicId));
        }
    }

    public HTMLBrowser getBrowser() {
        return this._browser;
    }

    public TopicDisplay getTopicPanel() {
        return this._displayPanel;
    }

    void runFindDialog(Context context) {
        if (this._findDialog != null) {
            return;
        }
        this._findDialog = new MiniSearchDialog();
        this._findDialog.setPreferredLocation(MiniSearchDialog.Location.CENTERED);
        JPanel basePanel = this._findDialog.getBasePanel();
        JPanel jp = new JPanel(new GridLayout(1, 1));
        JCheckBox caseSensitiveCB = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)caseSensitiveCB, (String)HelpArb.getString(101));
        jp.add(caseSensitiveCB);
        basePanel.add((Component)jp, "Center");
        this._findDialog.setTitle(HelpArb.getString(100));
        final FindSupport findSupport = this._browser.getFindSupport();
        if (_findDialogSearchText != null) {
            this._findDialog.setSearchText(_findDialogSearchText);
        }
        this._findDialogSearchListener = new FindDialogSearchListener(findSupport, caseSensitiveCB);
        this._findDialog.addSearchListener(this._findDialogSearchListener);
        this._findDialog.setTypingDelay(SearchField.TypingDelay.SLOW);
        this._findDialog.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if ("miniSearchDialogDismissed" == e.getActionCommand()) {
                    HelpContentPanel helpContentPanel = HelpContentPanel.this;
                    synchronized (helpContentPanel) {
                        HelpContentPanel.this._findDialog.removeSearchListener(HelpContentPanel.this._findDialogSearchListener);
                        findSupport.setSearchString("");
                        HelpContentPanel.this._findDialogSearchListener = null;
                        HelpContentPanel.this._findDialog = null;
                    }
                }
            }
        });
        this._findDialog.show((JComponent)this._displayPanel);
    }

    public Controller getController() {
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._backwardMenu = this._contextMenu.createMenuItem((ToggleAction)this._backwardAction);
            this._forwardMenu = this._contextMenu.createMenuItem((ToggleAction)this._forwardAction);
            if (this._printAction != null) {
                this._printMenu = this._contextMenu.createMenuItem((ToggleAction)this._printAction);
            }
            this._findMenu = this._contextMenu.createMenuItem((ToggleAction)this._findAction);
            this._copyMenu = this._contextMenu.createMenuItem((ToggleAction)this._copyAction);
            this._selectAllMenu = this._contextMenu.createMenuItem((ToggleAction)this._selectAllAction);
            if (HelpSystemAddin.isNavigatorSupported(1)) {
                this._addFavoriteMenu = this._contextMenu.createMenuItem((ToggleAction)this._addFavoriteAction);
            }
            this._increaseFontSizeMenu = this._contextMenu.createMenuItem((ToggleAction)this._increaseFontSizeAction);
            this._decreaseFontSizeMenu = this._contextMenu.createMenuItem((ToggleAction)this._decreaseFontSizeAction);
            this._closeTabMenu = this._contextMenu.createMenuItem((ToggleAction)this._closeTabAction);
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    public Component getGUI() {
        return this._mainPanel;
    }

    public void dispose() {
        if (this._displayPanel != null) {
            this.closeFindDialog();
        }
        if (this._keyListenerComponent != null && this._keyListener != null) {
            this._keyListenerComponent.removeKeyListener(this._keyListener);
        }
        if (this._mouseListenerComponent != null && this._mouseListener != null) {
            this._mouseListenerComponent.removeMouseListener(this._mouseListener);
        }
        if (this._browser != null) {
            this._browser.removeURLListener(this._browserURLListener);
        }
        if (this._topicDisplay != null) {
            this._topicDisplay.removeDisplayListener((TopicDisplayListener)this);
            this._topicDisplay.dispose();
        }
        if (this._toolbar != null) {
            this._toolbar.dispose();
        }
        if (this._changeListener != null) {
            KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
            kso.removeChangeListener(this._changeListener);
        }
        if (this._toolbar != null) {
            this._toolbar.removeAll();
            this._toolbar = null;
        }
        this._browser = null;
        this._displayPanel = null;
        this._topicDisplay = null;
        this._browserURLListener = null;
        this._keyListener = null;
        this._keyListenerComponent = null;
        this._parent = null;
        this._changeListener = null;
        this._mouseListener = null;
        this._mouseListenerComponent = null;
        if (this._controller != null) {
            this.removeControllerFromAction(this._backwardAction);
            this.removeControllerFromAction(this._forwardAction);
            this.removeControllerFromAction(this._copyAction);
            this.removeControllerFromAction(this._findAction);
            if (this._printAction != null) {
                this.removeControllerFromAction(this._printAction);
            }
            this.removeControllerFromAction(this._exitAction);
            this.removeControllerFromAction(this._contextMenuAction);
            this.removeControllerFromAction(this._selectAllAction);
            if (HelpSystemAddin.isNavigatorSupported(1)) {
                this.removeControllerFromAction(this._addFavoriteAction);
            }
            this.removeControllerFromAction(this._increaseFontSizeAction);
            this.removeControllerFromAction(this._decreaseFontSizeAction);
            this.removeControllerFromAction(this._closeTabAction);
            this.removeControllerFromAction(IdeAction.find((int)22));
        }
        if (this._mainPanel != null) {
            this._mainPanel.getActionMap().clear();
            this._mainPanel.removeAll();
        }
        if (this._changeFontSizeBtn != null) {
            this._changeFontSizeBtn.removeAllPopupItems();
        }
    }

    void closeFindDialog() {
        if (this._findDialog != null && this._findDialog.ghostPalette() != null) {
            this._findDialog.ghostPalette().hidePanel();
            if (this._findDialogSearchListener != null) {
                this._findDialog.removeSearchListener(this._findDialogSearchListener);
            }
            this._findDialog = null;
        }
    }

    public boolean canGoBackward() {
        return this._displayPanel != null && this._displayPanel.canGoBack();
    }

    public boolean canGoForward() {
        return this._displayPanel != null && this._displayPanel.canGoForward();
    }

    public void goBackward() {
        this._displayPanel.goBack();
    }

    public void goForward() {
        this._displayPanel.goForward();
    }

    public boolean isTextSelected() {
        return this._browser.getSelectedText() != null;
    }

    public void copy() {
        JTextArea t = new JTextArea();
        t.setText(this._browser.getSelectedText());
        t.selectAll();
        t.copy();
    }

    public static Class getHTMLBrowserClass() {
        return HTML_BROWSER_CLASS;
    }

    public static HTMLBrowser createHTMLBrowser() {
        HTMLBrowser browser = null;
        try {
            browser = (HTMLBrowser)HelpContentPanel.getHTMLBrowserClass().newInstance();
            browser.setLocale(StaticLocaleContext.getLocale());
            if (StaticLocaleContext.getEncoding() != null) {
                browser.setCharset(StaticLocaleContext.getEncoding());
            }
        }
        catch (Exception e) {
            Assert.println((String)("Failed to create instance of " + HelpContentPanel.getHTMLBrowserClass().toString()));
            Assert.println((String)"Cannot create Topic Display");
        }
        return browser;
    }

    public Object getParent() {
        return this._parent;
    }

    void setParent(Object parent) {
        this._parent = parent;
    }

    Component getFindButton() {
        return this._findBtn;
    }

    public void syncTOCToURL(final URL url) {
        JDevTOCNavigator tocNavigator;
        HelpCenterWindow helpCenterWindow = HelpCenterWindow.peekInstance();
        if (helpCenterWindow == null) {
            return;
        }
        if (this._syncTOCWithSelection && (tocNavigator = HelpCenterWindow.getTOCNavigator()) != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    tocNavigator.selectMatchingTopic(url);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void menuWillShow(ContextMenu popup) {
        float section = MenuConstants.SECTION_DYNAMIC_CTXT_MENU;
        this._contextMenu.add((Component)this._backwardMenu, section);
        this._contextMenu.add((Component)this._forwardMenu, section);
        this._contextMenu.add((Component)this._copyMenu, section += 0.001f);
        this._contextMenu.add((Component)this._selectAllMenu, section);
        this._contextMenu.add((Component)this._findMenu, section += 0.001f);
        section += 0.001f;
        if (this._printMenu != null) {
            this._contextMenu.add((Component)this._printMenu, section);
            section += 0.001f;
        }
        this._contextMenu.add((Component)this._decreaseFontSizeMenu, section);
        this._contextMenu.add((Component)this._increaseFontSizeMenu, section);
        this._contextMenu.add((Component)this._closeTabMenu, section += 0.001f);
        section += 0.001f;
        if (HelpSystemAddin.isNavigatorSupported(1)) {
            this._contextMenu.add((Component)this._addFavoriteMenu, section);
        }
        if (this.canGoBackward()) {
            this._backwardMenu.setEnabled(true);
        } else {
            this._backwardMenu.setEnabled(false);
        }
        if (this.canGoForward()) {
            this._forwardMenu.setEnabled(true);
        } else {
            this._forwardMenu.setEnabled(false);
        }
        if (this._browser.getSelectedText() != null) {
            this._copyMenu.setEnabled(true);
        } else {
            this._copyMenu.setEnabled(false);
        }
        this._activeContextMenu = popup;
    }

    public void menuWillHide(ContextMenu popup) {
        this._activeContextMenu = null;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    ContextMenu getActiveContextMenu() {
        return this._activeContextMenu;
    }

    private void _createKeyMappings() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        final KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        final KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        final MultiInputMap imap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
        InputMap inputMap = Ide.getIdeInputMap();
        imap.setParent(inputMap);
        this._mainPanel.setInputMap(1, (InputMap)imap);
        this.loadMyMap(imap, this._mainPanel.getActionMap(), kso);
        this._changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MultiMapAdapter.fillLocalMap((MultiInputMap)imap, (KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
                HelpContentPanel.this.loadMyMap(imap, HelpContentPanel.this._mainPanel.getActionMap(), kso);
                HelpContentPanel.this._setButtonTooltips();
            }
        };
        kso.addChangeListener(this._changeListener);
        this._setButtonTooltips();
        JRootPane rootPane = null;
        if (this._parent instanceof JDialog) {
            rootPane = ((JDialog)this._parent).getRootPane();
        }
        if (rootPane != null) {
            this._contextMenuAction = IdeAction.newLocalAction((int)50, (View)this);
            this._contextMenuAction.addController(this._controller);
            this._exitAction = IdeAction.newLocalAction((int)4, (View)this);
            this._exitAction.addController(this._controller);
            MultiInputMap myInputMap = new MultiInputMap(true);
            ActionMap myActionMap = new ActionMap();
            this.loadMyMap(myInputMap, myActionMap, kso);
            ActionMap amMe = rootPane.getActionMap();
            amMe.setParent(myActionMap);
            InputMap imMe = rootPane.getInputMap(1);
            imMe.setParent((InputMap)myInputMap);
            IdeAction.find((int)23).setEnabled(true);
            IdeAction.find((int)16).setEnabled(true);
            IdeAction.find((int)22).setEnabled(true);
            IdeAction.find((int)50).setEnabled(true);
        }
    }

    private void loadMyMap(MultiInputMap myMap, ActionMap aMap, KeyStrokeOptions kso) {
        this.updateMyMapWithAction(kso, aMap, myMap, 23, this._findAction);
        this._findAction.setEnabled(true);
        if (this._printAction != null) {
            this.updateMyMapWithAction(kso, aMap, myMap, 16, this._printAction);
            this._printAction.setEnabled(true);
        }
        this.updateMyMapWithAction(kso, aMap, myMap, 22, this._selectAllAction);
        this._selectAllAction.setEnabled(true);
        if (this._contextMenuAction != null) {
            this.updateMyMapWithAction(kso, aMap, myMap, 50, this._contextMenuAction);
            this._contextMenuAction.setEnabled(true);
            this.updateMyMapWithAction(kso, aMap, myMap, 4, this._exitAction);
            this._exitAction.setEnabled(true);
        }
        this.updateMyMapWithAction(kso, aMap, myMap, HelpSystemConstants.FORWARD_CMD_ID, this._forwardAction);
        this.updateMyMapWithAction(kso, aMap, myMap, HelpSystemConstants.BACKWARD_CMD_ID, this._backwardAction);
    }

    private void updateMyMapWithAction(KeyStrokeOptions kso, ActionMap aMap, MultiInputMap myMap, int cmdId, IdeAction action) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        List kList = this.getKeyStrokesFor(kso, cmdId, ksc);
        if (kList != Collections.EMPTY_LIST) {
            int numKeys = kList.size();
            Integer integer = new Integer(cmdId);
            for (int i = 0; i < numKeys; ++i) {
                aMap.put(integer, (Action)action);
                myMap.put((KeyStrokes)kList.get(i), (Object)integer);
            }
        }
    }

    private List getKeyStrokesFor(KeyStrokeOptions kso, int cmdId, KeyStrokeContext ksc) {
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        List kList = ksm.getKeyStrokesFor(cmdId);
        if (kList == Collections.EMPTY_LIST) {
            ksm = kso.getLocalKeyMap(ksc);
            kList = ksm.getKeyStrokesFor(cmdId);
        }
        return kList;
    }

    private void _setButtonTooltips() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap localKeyMap = kso.getLocalKeyMap(ksc);
        KeyStrokeMap globalKeyMap = kso.getGlobalKeyMap();
        this._setTooltipForButton(this._forwardBtn, localKeyMap, globalKeyMap);
        this._setTooltipForButton(this._backwardBtn, localKeyMap, globalKeyMap);
    }

    private void _setTooltipForButton(ToolButton button, KeyStrokeMap localKeyMap, KeyStrokeMap globalKeyMap) {
        String acceleratorTip;
        IdeAction action = (IdeAction)button.getAction();
        String tip = (String)action.getValue("ShortDescription");
        if (tip == null || tip.length() == 0) {
            tip = (String)action.getValue("Name");
        }
        if ((acceleratorTip = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)localKeyMap, (int)action.getCommandId())) == null || acceleratorTip.length() == 0) {
            acceleratorTip = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)globalKeyMap, (int)action.getCommandId());
        }
        if (acceleratorTip != null && acceleratorTip.length() != 0) {
            tip = tip + " (" + acceleratorTip + ")";
        }
        button.setToolTipText(tip);
    }

    private void _init() {
        this._mainPanel = new JPanel(new BorderLayout());
        this._controller = new HelpTopicPanelController();
        this._browser = HelpContentPanel.createHTMLBrowser();
        if (this._browser != null) {
            this._browserURLListener = new URLListener(){

                public void urlChanged(URLEvent event) {
                    Object obj = HelpContentPanel.this.getParent();
                    if (obj != null && obj instanceof HelpTopicEditor) {
                        HelpCenterWindow.updateTabLabelForEditor((HelpTopicEditor)((Object)obj));
                    }
                }

                public void anchorChanged(URLEvent event) {
                }
            };
            this._browser.addURLListener(this._browserURLListener);
            this._registerProtocolHandlers();
        }
        this._topicDisplay = this._helpSystemDependent ? new BrowserTopicDisplay(this._browser, this._library) : new BrowserTopicDisplay(this._browser);
        this._topicDisplay.addDisplayListener((TopicDisplayListener)this);
        this._displayPanel = new SimpleTopicDisplayPanel(this._topicDisplay, null, null);
        JPanel dpanel = this._topicDisplay.getDisplayContainer();
        if (dpanel instanceof Container) {
            JPanel container = dpanel;
            if (container.getComponentCount() > 0) {
                this.addKeyListenerHack();
            } else {
                this._containerListener = new ContainerAdapter(){

                    @Override
                    public void componentAdded(ContainerEvent e) {
                        HelpContentPanel.this.addKeyListenerHack();
                        e.getContainer().removeContainerListener(HelpContentPanel.this._containerListener);
                        HelpContentPanel.this._containerListener = null;
                    }
                };
                container.addContainerListener(this._containerListener);
            }
        }
        this._displayPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        if (this._displayToolbar) {
            this._backwardAction = IdeAction.newLocalAction((int)HelpSystemConstants.BACKWARD_CMD_ID, (View)this);
            this._backwardAction.addController(this._controller);
            this._backwardBtn = new ToolButton((Action)this._backwardAction);
            this._backwardBtn.setFocusable(true);
            this._forwardAction = IdeAction.newLocalAction((int)HelpSystemConstants.FORWARD_CMD_ID, (View)this);
            this._forwardAction.addController(this._controller);
            this._forwardBtn = new ToolButton((Action)this._forwardAction);
            this._forwardBtn.setFocusable(true);
            if (IdeAction.find((String)"Ide.PRINT_CMD_ID") != null) {
                this._printAction = IdeAction.newLocalAction((int)16, (View)this);
                this._printAction.addController(this._controller);
                this._printBtn = new ToolButton((Action)this._printAction);
                this._printBtn.setFocusable(true);
            }
            this._findAction = IdeAction.newLocalAction((int)23, (View)this);
            this._findAction.addController(this._controller);
            this._findBtn = new ToolButton((Action)this._findAction);
            this._findBtn.setFocusable(true);
            this._copyAction = IdeAction.newLocalAction((int)18, (View)this);
            this._copyAction.addController(this._controller);
            String label = HelpExtArb.get("DECREASE_HELP_FONT_SIZE");
            IdeAction baseAction = IdeAction.get((int)HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID, (String)"oracle.jdevimpl.help.HelpContentPanel.DecreaseFontSizeCmd", (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
            this._decreaseFontSizeAction = IdeAction.newLocalAction((int)HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID, (View)this);
            this._decreaseFontSizeAction.addController(this._controller);
            this._decreaseFontSizeAction.setEnabled(true);
            label = HelpExtArb.get("INCREASE_HELP_FONT_SIZE");
            baseAction = IdeAction.get((int)HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID, (String)"oracle.jdevimpl.help.HelpContentPanel.IncreaseFontSizeCmd", (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
            this._increaseFontSizeAction = IdeAction.newLocalAction((int)HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID, (View)this);
            this._increaseFontSizeAction.addController(this._controller);
            this._increaseFontSizeAction.setEnabled(true);
            this._changeFontSizeBtn = new MenuToolButton((ToggleAction)((IdeAction)null));
            this._changeFontSizeBtn.setIcon(OracleIcons.getIcon((String)"fontsize.png"));
            this._changeFontSizeBtn.setToolTipText(HelpArb.getString(66));
            this._changeFontSizeBtn.setFocusable(true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Action[] actions = HelpContentPanel.this._changeFontSizeBtn.getActions();
                    if (actions[0] == null) {
                        HelpContentPanel.this._changeFontSizeBtn.addPopupItem((ToggleAction)HelpContentPanel.this._increaseFontSizeAction);
                        HelpContentPanel.this._changeFontSizeBtn.addPopupItem((ToggleAction)HelpContentPanel.this._decreaseFontSizeAction);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
            label = HelpArb.getString(67);
            baseAction = IdeAction.get((int)HelpSystemConstants.CLOSE_HELP_TAB_CMD_ID, (String)"oracle.jdevimpl.help.HelpContentPanel.CloseTabCmd", (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
            this._closeTabAction = IdeAction.newLocalAction((int)HelpSystemConstants.CLOSE_HELP_TAB_CMD_ID, (View)this);
            this._closeTabAction.addController(this._controller);
            this._closeTabAction.setEnabled(true);
            if (HelpSystemAddin.isNavigatorSupported(1)) {
                this._addFavoriteAction = IdeAction.newLocalAction((int)HelpSystemConstants.ADD_FAVORITE_CMD_ID, (View)this);
                this._addFavoriteAction.addController(this._controller);
                this._addFavoriteBtn = new ToolButton((Action)this._addFavoriteAction);
                this._addFavoriteBtn.setFocusable(true);
            }
            this._selectAllAction = IdeAction.newLocalAction((int)22, (View)this);
            this._selectAllAction.addController(this._controller);
            IdeAction.find((int)22).addController(this._controller);
            this._createKeyMappings();
            this._toolbar = new HelpNavigatorToolbar();
            this._toolbar.add((Component)this._backwardBtn);
            this._toolbar.add((Component)this._forwardBtn);
            if (this._printBtn != null) {
                this._toolbar.add((Component)this._printBtn);
            }
            this._toolbar.add((Component)this._changeFontSizeBtn);
            if (HelpSystemAddin.isNavigatorSupported(1)) {
                this._toolbar.add((Component)this._addFavoriteBtn);
            }
            this._toolbar.add((Component)this._findBtn);
            this.installMouseListener();
            this._mainPanel.add((Component)this._toolbar, "North");
        }
        this._mainPanel.add((Component)this._displayPanel, "Center");
    }

    private void addKeyListenerHack() {
        this._keyListenerComponent = GraphicsUtils.getFocusableComponentOrChild((Component)this._displayPanel, (boolean)true);
        if (this._keyListenerComponent != null && this._keyListenerComponent.getClass().getName().contains("DocPanel")) {
            this._keyListener = new MyKeyListener();
            this._keyListenerComponent.addKeyListener(this._keyListener);
        }
    }

    private JScrollBar getScrollbarForAction(int orientation, Object source) {
        Component cparent = (Component)source;
        boolean keepgoing = true;
        while (keepgoing && cparent != null) {
            if (cparent.getClass().getName().contains("PanePanel")) {
                keepgoing = false;
                continue;
            }
            cparent = cparent.getParent();
        }
        if (cparent != null && cparent instanceof Container) {
            Component[] comps;
            for (Component c : comps = ((Container)cparent).getComponents()) {
                int or;
                if (!(c instanceof JScrollBar) || (or = ((JScrollBar)c).getOrientation()) != orientation) continue;
                return (JScrollBar)c;
            }
        }
        return null;
    }

    private void _registerProtocolHandlers() {
        CustomProtocolRegistry cpr = new CustomProtocolRegistry(this._browser);
        for (Pair pair : _protocolRegistryList) {
            cpr.registerCustomProtocolHandler((String)pair.getFirst(), (CustomProtocolHandler)pair.getSecond());
        }
    }

    private void removeControllerFromAction(IdeAction action) {
        if (action != null) {
            action.removeController(this._controller);
        }
    }

    void changeFontSize(boolean increase) {
        if (this._displayPanel != null) {
            if (increase) {
                this._displayPanel.increaseFontSize();
            } else {
                this._displayPanel.decreaseFontSize();
            }
        }
    }

    public void topicDisplayChanged(TopicDisplayEvent e) {
        if (e.getID() == 2000 && (e.getChangeType() == 0 || e.getChangeType() == 2)) {
            if (this._parent instanceof HelpTopicEditor) {
                ((HelpTopicEditor)((Object)this._parent)).getHelpTopicDocument().setURL(e.getURL());
            }
            this.updateActions();
            if (e.getChangeType() == 0) {
                this.syncTOCToURL(e.getURL());
            }
            if (JDevHelpSystemImpl.isDocWriter()) {
                JDevHelpSystemImpl.printTopicForDebugging(null, null, e.getURL());
            }
        }
    }

    private void updateActions() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (HelpContentPanel.this._displayPanel == null) {
                    return;
                }
                if (HelpContentPanel.this._printAction != null) {
                    HelpContentPanel.this._printAction.setEnabled(true);
                }
                if (HelpContentPanel.this._findAction != null) {
                    HelpContentPanel.this._findAction.setEnabled(true);
                }
                if (HelpContentPanel.this._selectAllAction != null) {
                    HelpContentPanel.this._selectAllAction.setEnabled(true);
                }
                if (HelpContentPanel.this._forwardAction != null) {
                    HelpContentPanel.this._forwardAction.setEnabled(HelpContentPanel.this.canGoForward());
                }
                if (HelpContentPanel.this._backwardAction != null) {
                    HelpContentPanel.this._backwardAction.setEnabled(HelpContentPanel.this.canGoBackward());
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void installMouseListener() {
        if (this._mouseListener == null) {
            this._mouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    HelpContentPanel.this.triggerPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    HelpContentPanel.this.triggerPopup(e);
                }
            };
        }
        this._mouseListenerComponent = GraphicsUtils.getFocusableComponentOrChild((Component)this._displayPanel, (boolean)true);
        if (this._mouseListenerComponent != null) {
            this._mouseListenerComponent.addMouseListener(this._mouseListener);
        }
    }

    protected void triggerPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Component component = e.getComponent();
            component.requestFocus();
            ContextMenu menu = this.getContextMenu();
            if (menu == null) {
                return;
            }
            Context context = this.getContext(e);
            menu.show(context);
        }
    }

    static {
        _protocolRegistryList = new ArrayList<Pair>(12);
        _protocolRegistryList.add(new Pair((Object)"external", (Object)new ExternalBrowserHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevIdeSettings", (Object)new IdeSettingsHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevInvokableWizard", (Object)new InvokableWizardHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevInvokableAction", (Object)new InvokableActionHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevProjectSettings", (Object)new IdeProjectSettingsHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevLoadIntoEditor", (Object)new LoadIntoEditorHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevFileReopen", (Object)new FileReopenHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevShowTopic", (Object)new InitAndInvokeHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevShowHelpInWindow", (Object)new ShowHelpInWindowHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevInvokeBrowserOnFile", (Object)new BrowserOnFileHandler()));
        _protocolRegistryList.add(new Pair((Object)"jdevExternal", (Object)new ExternalBrowserMacroHandler()));
        HTML_BROWSER_CLASS = ICEBrowser.class;
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ActionListener al;
            int keycode = e.getKeyCode();
            JComponent sbar = null;
            switch (keycode) {
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    sbar = HelpContentPanel.this.getScrollbarForAction(1, e.getSource());
                    break;
                }
                case 35: 
                case 36: 
                case 37: 
                case 39: {
                    sbar = HelpContentPanel.this.getScrollbarForAction(0, e.getSource());
                }
            }
            if (sbar != null && (al = sbar.getActionForKeyStroke(KeyStroke.getKeyStrokeForEvent(e))) != null) {
                al.actionPerformed(new ActionEvent(sbar, 1001, null));
            }
        }
    }

    private class FindDialogSearchListener
    implements SearchListener {
        private FindSupport _findSupport;
        private JCheckBox _caseSensitiveCB;
        private boolean _hits = false;
        private Icon _prv;
        private Icon _nxt;
        private String _searchText;

        public FindDialogSearchListener(FindSupport findSupport, JCheckBox checkbox) {
            this._findSupport = findSupport;
            this._caseSensitiveCB = checkbox;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void searchPerformed(SearchEvent se) {
            if (this._prv == null) {
                this.getOrigIcons(se);
            }
            HelpContentPanel helpContentPanel = HelpContentPanel.this;
            synchronized (helpContentPanel) {
                if (HelpContentPanel.this._findDialog == null) {
                    return;
                }
                HelpContentPanel.this._findDialog.setMessage("");
                String searchText = se.getSearchText();
                if (!ModelUtil.hasLength((String)searchText)) {
                    HelpContentPanel.this._findDialog.setMessage(HelpArb.getString(102));
                    return;
                }
                if (this._searchText == null || !this._searchText.equals(searchText)) {
                    this._hits = false;
                    this._searchText = searchText;
                    _findDialogSearchText = searchText;
                }
                this._findSupport.setCaseSensitive(this._caseSensitiveCB.isSelected());
                if (this._findSupport.getSearchString() == null || !this._findSupport.getSearchString().equals(searchText)) {
                    this._findSupport.setSearchString(searchText);
                }
                if (se.getDirection() == SearchEvent.Direction.BACKWARD) {
                    boolean foundPrevious = this._findSupport.findPrevious();
                    if (!foundPrevious) {
                        HelpContentPanel.this._findDialog.setMessage(HelpArb.getString(103));
                        this.handleButtons(se, false, false);
                    } else {
                        this.handleButtons(se, false, true);
                    }
                } else {
                    boolean foundNext = this._findSupport.findNext();
                    if (!foundNext) {
                        HelpContentPanel.this._findDialog.setMessage(HelpArb.getString(103));
                        this.handleButtons(se, true, false);
                    } else {
                        this.handleButtons(se, true, true);
                    }
                }
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        private void handleButtons(SearchEvent se, boolean forward, boolean enable) {
            if (forward && enable) {
                this._hits = true;
            }
            if (se.getSource() instanceof SearchField) {
                SearchField sfield = (SearchField)se.getSource();
                JButton button = sfield.getNextButton();
                if (forward) {
                    this.handleNxtButton(button, enable || this._hits);
                    if (!enable && !this._hits) {
                        this.handlePrvButton(sfield.getPreviousButton(), false);
                    } else {
                        this.handlePrvButton(sfield.getPreviousButton(), true);
                    }
                }
            }
        }

        private void handlePrvButton(JButton button, boolean enable) {
            if (enable) {
                button.setIcon(this._prv);
                button.setEnabled(true);
            } else {
                button.setIcon((Icon)new WashedIcon(this._prv, 0.5f));
                button.setEnabled(false);
            }
            button.invalidate();
            button.repaint();
        }

        private void handleNxtButton(JButton button, boolean enable) {
            if (enable) {
                button.setIcon(this._nxt);
                button.setEnabled(true);
            } else {
                button.setIcon((Icon)new WashedIcon(this._nxt, 0.5f));
                button.setEnabled(false);
            }
            button.invalidate();
            button.repaint();
        }

        private void getOrigIcons(SearchEvent se) {
            if (se.getSource() instanceof SearchField) {
                SearchField sfield = (SearchField)se.getSource();
                this._prv = sfield.getPreviousButton().getIcon();
                this._nxt = sfield.getNextButton().getIcon();
            }
        }
    }

    private static class URLDisplayWrapper {
        private URL _url;

        public URLDisplayWrapper(URL url) {
            this._url = url;
        }

        public URL getURL() {
            return this._url;
        }

        public String toString() {
            return URLFileSystem.getPlatformPathName((URL)this._url);
        }
    }

    private static final class BrowserOnFileHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokeBrowserOnFile";

        private BrowserOnFileHandler() {
        }

        public void handleValue(String value) {
            try {
                File ideHome = new File(Ide.getProductHomeDirectory());
                File file = new File(ideHome, value);
                URL fileURL = URLFactory.newFileURL((File)file);
                BrowserRunner.getBrowserRunner().runBrowserOnURL(fileURL, null, null);
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex, (String)HelpArb.format(51, value));
            }
        }
    }

    private static final class FileReopenHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevFileReopen";

        private FileReopenHandler() {
        }

        public void handleValue(String value) {
            FileOpenHistory fileOpenHistory = FileOpenHistory.getInstance();
            String[] openedFiles = fileOpenHistory.getFileHistory();
            URLDisplayWrapper selectedFile = null;
            if (openedFiles == null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(44), HelpArb.getString(43), 1);
            } else {
                Object[] urls = new URLDisplayWrapper[openedFiles.length];
                for (int i = 0; i < openedFiles.length; ++i) {
                    URLDisplayWrapper urlDisplay;
                    urls[i] = urlDisplay = new URLDisplayWrapper(URL2String.toURL((String)openedFiles[i]));
                }
                selectedFile = (URLDisplayWrapper)JOptionPane.showInputDialog((Component)Ide.getMainWindow(), HelpArb.getString(43), HelpArb.getString(42), 3, null, urls, urls[0]);
                if (selectedFile != null) {
                    URL selectedURL = selectedFile.getURL();
                    final IdeAction action = FileOpenHistory.getNewReopenAction((URL)selectedURL);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                action.performAction();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    IdeUtil.invokeAfterRepaint((Runnable)runnable);
                }
            }
        }
    }

    private static final class ShowHelpInWindowHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowHelpInWindow";

        private ShowHelpInWindowHandler() {
        }

        public void handleValue(String value) {
            HelpSystem helpSys = HelpSystem.getHelpSystem();
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl) {
                JDevHelpSystemImpl helpSysImpl = (JDevHelpSystemImpl)helpSys;
                Library library = helpSysImpl.getLibrary();
                Topic topic = helpSysImpl.getTopicForString(value);
                if (topic != null && library != null) {
                    Context ctx = HelpUtils.createContext(topic);
                    HelpUtils.createHelpTopicEditor(ctx, topic);
                }
            }
        }
    }

    private static final class InitAndInvokeHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowTopic";

        private InitAndInvokeHandler() {
        }

        public void handleValue(String value) {
            JDevHelpSystemImpl helpSysImpl;
            Library library;
            HelpSystem helpSys = HelpSystem.getHelpSystem();
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl && (library = (helpSysImpl = (JDevHelpSystemImpl)helpSys).getLibrary()) != null) {
                helpSysImpl.goTo(value);
            }
        }
    }

    private static final class LoadIntoEditorHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevLoadIntoEditor";

        private LoadIntoEditorHandler() {
        }

        public void handleValue(String value) {
            EditorManager editorMgr;
            URL url;
            JDevHelpSystemImpl helpSysImpl;
            Library library;
            HelpSystem helpSys = HelpSystem.getHelpSystem();
            if (helpSys != null && helpSys instanceof JDevHelpSystemImpl && (library = (helpSysImpl = (JDevHelpSystemImpl)helpSys).getLibrary()) != null && (url = library.mapIDToURL(value)) != null && (editorMgr = EditorManager.getEditorManager()) != null) {
                editorMgr.openDefaultEditorInFrame(url);
            }
        }
    }

    private static final class InvokableActionHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokableAction";

        private InvokableActionHandler() {
        }

        @Override
        public void handleValue(String value) {
            HelpUtils.invokeAction(value, null);
        }
    }

    private static final class InvokableWizardHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokableWizard";

        private InvokableWizardHandler() {
        }

        @Override
        public void handleValue(String value) {
            HelpUtils.invokeWizard(value, null);
        }
    }

    private static final class IdeProjectSettingsHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevProjectSettings";

        private IdeProjectSettingsHandler() {
        }

        @Override
        public void handleValue(String value) {
            Context context = null;
            Project project = null;
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
                project = context.getProject();
            }
            if (project == null) {
                project = Ide.getActiveProject();
            }
            if (project == null) {
                return;
            }
            if (value.equals("main")) {
                ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
            } else {
                String[] selectionPath = this.parseString(value);
                if (selectionPath != null) {
                    ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)project, (String[])selectionPath);
                } else {
                    ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
                }
            }
        }

        private String[] parseString(String value) {
            List stringList = AbstractCustomProtocolHandler.parseInputString(value);
            return AbstractCustomProtocolHandler.parseTranslatableTextList(stringList);
        }
    }

    private static final class IdeSettingsHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevIdeSettings";

        private IdeSettingsHandler() {
        }

        @Override
        public void handleValue(String value) {
            if (value.equals("main")) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow());
            } else {
                String[] selectionPath = this.parseString(value);
                if (selectionPath != null) {
                    Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), selectionPath);
                } else {
                    Ide.getSettings().showDialog((Frame)Ide.getMainWindow());
                }
            }
        }

        private String[] parseString(String value) {
            List stringList = AbstractCustomProtocolHandler.parseInputString(value);
            return AbstractCustomProtocolHandler.parseTranslatableTextList(stringList);
        }
    }

    private static class ExternalBrowserMacroHandler
    extends ExternalBrowserHandler {
        public static final String PROTOCOL_NAME = "jdevExternal";

        private ExternalBrowserMacroHandler() {
        }

        @Override
        public void handleValue(String value) {
            String newValue = oracle.ide.help.HelpUtils.substituteMacros((String)value);
            super.handleValue(newValue);
        }
    }

    private static class ExternalBrowserHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "external";

        private ExternalBrowserHandler() {
        }

        public void handleValue(String value) {
            try {
                BrowserRunner.getBrowserRunner().runBrowserOnURL(new URL(value), null, null);
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex, (String)HelpArb.format(51, value));
            }
        }
    }

    private class HelpTopicPanelController
    implements Controller {
        private HelpTopicPanelController() {
        }

        public boolean update(IdeAction action, Context context) {
            View view;
            if (context != null && ((view = context.getView()) instanceof HelpContentPanel || view instanceof HelpTopicEditor || view instanceof HelpCenterWindow.HelpCenterView)) {
                int cmdId = action.getCommandId();
                if (cmdId == 23) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 50) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == HelpSystemConstants.FORWARD_CMD_ID) {
                    if (HelpContentPanel.this.canGoForward()) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                    return true;
                }
                if (cmdId == HelpSystemConstants.BACKWARD_CMD_ID) {
                    if (HelpContentPanel.this.canGoBackward()) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                    return true;
                }
                if (cmdId == 16) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 18) {
                    action.setEnabled(HelpContentPanel.this.isTextSelected());
                    return true;
                }
                if (cmdId == HelpSystemConstants.ADD_FAVORITE_CMD_ID) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == 22) {
                    action.setEnabled(true);
                    return true;
                }
                if (cmdId == HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID || cmdId == HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID || cmdId == HelpSystemConstants.CLOSE_HELP_TAB_CMD_ID) {
                    action.setEnabled(true);
                    return true;
                }
                action.setEnabled(false);
            }
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (!(context.getView() instanceof HelpContentPanel || context.getView() instanceof HelpTopicEditor || context.getView() instanceof HelpWindow || context.getView() instanceof HelpCenterWindow.HelpCenterView)) {
                return false;
            }
            if (cmdId == HelpSystemConstants.FORWARD_CMD_ID) {
                HelpContentPanel.this.goForward();
                return true;
            }
            if (cmdId == HelpSystemConstants.BACKWARD_CMD_ID) {
                HelpContentPanel.this.goBackward();
                return true;
            }
            if (cmdId == 23) {
                HelpContentPanel.this.runFindDialog(context);
                return true;
            }
            if (cmdId == 18) {
                HelpContentPanel.this.copy();
                return true;
            }
            if (cmdId == HelpSystemConstants.ADD_FAVORITE_CMD_ID) {
                HelpSystem helpSys = HelpSystem.getHelpSystem();
                if (helpSys != null && helpSys instanceof JDevHelpSystemImpl) {
                    FavoritesModel favoritesModel = ((JDevHelpSystemImpl)helpSys).getFavoritesModel();
                    if (favoritesModel != null) {
                        Object parent = null;
                        if (HelpContentPanel.this._parent != null && HelpContentPanel.this._parent instanceof HelpTopicEditor) {
                            HelpTopicEditor hte = (HelpTopicEditor)((Object)HelpContentPanel.this._parent);
                            parent = hte.getParent() != null && hte.getParent() instanceof HelpCenterWindow ? HelpCenterWindow.getInstance().getWindow() : Ide.getMainWindow();
                        }
                        String urlString = HelpContentPanel.this._topicDisplay.getCurrentURL().toString();
                        String topicTitle = HelpContentPanel.this._topicDisplay.getCurrentPageTitle();
                        HelpUtils.addFavoriteItem(favoritesModel, topicTitle, urlString, (Window)parent);
                    } else {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(38), HelpArb.getString(37), 0);
                    }
                }
                return true;
            }
            if (cmdId == 22) {
                HelpContentPanel hcp = null;
                hcp = context.getView() instanceof HelpTopicEditor ? ((HelpTopicEditor)context.getView()).getHelpContentPanel() : (HelpContentPanel)context.getView();
                hcp.getBrowser().selectAll();
                return true;
            }
            if (cmdId == 4 && action.isLocalAction()) {
                HelpContentPanel hcp = (HelpContentPanel)context.getView();
                Object parent = hcp.getParent();
                Window window = null;
                if (parent instanceof JDialog) {
                    window = (Window)parent;
                }
                window.setVisible(false);
                window.dispose();
                return true;
            }
            if (cmdId == HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID) {
                HelpContentPanel.this.changeFontSize(true);
                return true;
            }
            if (cmdId == HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID) {
                HelpContentPanel.this.changeFontSize(false);
                return true;
            }
            if (cmdId == HelpSystemConstants.CLOSE_HELP_TAB_CMD_ID) {
                Object parentObj = HelpContentPanel.this.getParent();
                if (parentObj instanceof HelpTopicEditor) {
                    HelpTopicEditor hte = (HelpTopicEditor)((Object)parentObj);
                    HelpCenterWindow.remove(hte);
                }
                return true;
            }
            if (cmdId == 50) {
                int yPos;
                int xPos;
                JPanel comp = HelpContentPanel.this._mainPanel;
                Container parent = comp.getParent();
                if (comp.getParent() instanceof JViewport) {
                    JViewport viewport = (JViewport)parent;
                    Point ptViewPosition = viewport.getViewPosition();
                    xPos = ptViewPosition.x;
                    yPos = ptViewPosition.y;
                } else {
                    xPos = ((Component)comp).getX();
                    yPos = ((Component)comp).getY();
                }
                MouseEvent event = new MouseEvent(comp, 502, System.currentTimeMillis(), 0, xPos, yPos, 1, true);
                Context cmContext = HelpContentPanel.this.getContext(event);
                cmContext.setEvent((EventObject)event);
                ContextMenu cm = HelpContentPanel.this.getContextMenu();
                cm.show(cmContext);
                return true;
            }
            return false;
        }
    }
}

