/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy.context;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.proxy.ProxyContext;
import oracle.dbtools.raptor.proxy.ProxyUtils;
import oracle.dbtools.raptor.proxy.stmtlogging.StmtLogPaneHandler;
import oracle.dbtools.raptor.proxy.stmtlogging.StmtLogRecord;

public class ProxyStmtContext
extends ProxyContext {
    private static Long lastSeq = 0L;
    protected StatementDetails currentDetails = null;
    protected static boolean logging = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextSeq() {
        Long l = lastSeq;
        synchronized (l) {
            lastSeq = lastSeq + 1L;
            return lastSeq;
        }
    }

    public static void setLogging(boolean bl) {
        logging = bl;
    }

    public ProxyStmtContext(String string) {
        super(string);
    }

    private StatementDetails getCurrentDetails() {
        if (this.currentDetails == null) {
            this.currentDetails = new StatementDetails(this.getConnectionName(), this.getPath());
        }
        return this.currentDetails;
    }

    private void publish(StatementDetails statementDetails) {
        if (this.getSignificantCaller() == null) {
            StackTraceElement stackTraceElement = this.getSignificantCaller();
            statementDetails.setSignificantCaller(stackTraceElement != null ? stackTraceElement.toString() : null);
        }
        if (logging) {
            StmtLogPaneHandler.getInstance().publish(statementDetails);
        }
    }

    public void recordExecute(Object object, long l) {
        StatementDetails statementDetails = new StatementDetails(ProxyStmtContext.nextSeq(), this.getCurrentDetails());
        this.recordResult(statementDetails, object);
        this.recordElapsed(statementDetails, l);
        this.publish(statementDetails);
    }

    public void recordExecute(Throwable throwable, long l) {
        StatementDetails statementDetails = new StatementDetails(ProxyStmtContext.nextSeq(), this.getCurrentDetails());
        this.recordException(statementDetails, throwable);
        this.recordElapsed(statementDetails, l);
        this.publish(statementDetails);
    }

    public void recordSql(String string) {
        StackTraceElement stackTraceElement = this.getSignificantCaller();
        this.getCurrentDetails().setSignificantCaller(stackTraceElement != null ? stackTraceElement.toString() : null);
        this.getCurrentDetails().setArgs(null);
        this.getCurrentDetails().setSql(string);
    }

    public void recordArg(Object object, Object object2) {
        this.getCurrentDetails().setArg(object, object2 != null ? this.formatArg(object2) : null);
    }

    public void recordArgs(Map<Object, Object> map) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (map != null) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object object = entry.getKey();
                Object object2 = entry.getValue();
                String string = object2 != null ? this.formatArg(object2) : null;
                hashMap.put(object, string);
            }
        }
        this.getCurrentDetails().setArgs(hashMap);
    }

    protected void recordElapsed(StatementDetails statementDetails, long l) {
        statementDetails.setElapsed(l);
    }

    protected void recordResult(StatementDetails statementDetails, Object object) {
        statementDetails.setResult(object != null ? this.formatArg(object) : null);
    }

    protected void recordException(StatementDetails statementDetails, Throwable throwable) {
        statementDetails.setExceptionMessage(throwable != null ? throwable.toString() : null);
    }

    protected String formatArg(Object object) {
        return ProxyUtils.formatArg(object);
    }

    private static class StatementDetails
    implements StmtLogRecord {
        private long seq;
        private String connName;
        private String caller;
        private String path;
        private String sql;
        private Map<Object, String> parameters;
        private String result;
        private String message;
        private long elapsed;

        private StatementDetails(String string, String string2) {
            this.seq = 0L;
            this.connName = string;
            this.path = string2;
            this.caller = null;
            this.sql = null;
            this.parameters = this.newArgMap();
            this.result = null;
            this.message = null;
            this.elapsed = 0L;
        }

        private StatementDetails(long l, StatementDetails statementDetails) {
            this.seq = l;
            this.connName = statementDetails.connName;
            this.path = statementDetails.path;
            this.caller = statementDetails.caller;
            this.sql = statementDetails.sql;
            this.parameters = this.newArgMap(statementDetails.parameters);
            this.result = null;
            this.message = null;
            this.elapsed = 0L;
        }

        private HashMap newArgMap() {
            return new HashMap<Object, String>(){

                @Override
                public String toString() {
                    return ProxyUtils.formatArgMap(this);
                }
            };
        }

        private HashMap newArgMap(Map<Object, String> map) {
            return new HashMap<Object, String>(map){

                @Override
                public String toString() {
                    return ProxyUtils.formatArgMap(this);
                }
            };
        }

        @Override
        public String getConnectionName() {
            return this.connName;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public void setSignificantCaller(String string) {
            this.caller = string;
        }

        @Override
        public String getSignificantCaller() {
            return this.caller;
        }

        @Override
        public long getSeq() {
            return this.seq;
        }

        protected void setSql(String string) {
            this.sql = string;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        protected void setArgs(Map<Object, String> hashMap) {
            this.parameters = hashMap == null ? this.newArgMap() : hashMap;
        }

        protected void setArg(Object object, String string) {
            this.parameters.put(object, string);
        }

        @Override
        public Map<Object, String> getArgs() {
            return this.parameters;
        }

        protected void setResult(String string) {
            this.result = string;
        }

        protected void setExceptionMessage(String string) {
            this.message = string;
        }

        public void setElapsed(long l) {
            this.elapsed = l;
        }

        @Override
        public long getElapsed() {
            return this.elapsed;
        }
    }
}

