/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.ext;

import antlr.LLkParser;
import antlr.MismatchedTokenException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import java.util.ArrayList;
import java.util.LinkedList;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtToken;
import oracle.dbtools.migration.parser.filter.FaultTolleranceFilter;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.internalapi.StartLineVisitor;
import oracle.dbtools.migration.translation.api.TranslationLimitation;
import oracle.dbtools.migration.translation.util.ASTUtil;

public abstract class RosettaRecognizer
extends LLkParser {
    String m_lastException = null;
    private int m_keywordTokenType = -1;
    private ArrayList<String> m_reservedWords;
    private final int m_lastStartIndex = -1;
    private TranslationHelper m_helper = new TranslationHelper();
    private Token m_firstToken = null;
    private Token m_lastToken = null;

    public RosettaRecognizer() {
        this(2);
    }

    public RosettaRecognizer(int n) {
        super(n);
    }

    public RosettaRecognizer(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
    }

    public RosettaRecognizer(TokenStream tokenStream, int n) {
        super(tokenStream, n);
    }

    public RosettaRecognizer(ParserSharedInputState parserSharedInputState, int n) {
        super(parserSharedInputState, n);
    }

    public abstract void start() throws RecognitionException, TokenStreamException;

    public void match(int n) throws MismatchedTokenException, TokenStreamException {
        if (this.LA(1) != n) {
            int n2 = this.LA(1);
            this.convertKeywordToIdentifier(1);
            if (this.LA(1) != n) {
                this.LT(1).setType(n2);
                throw new MismatchedTokenException(this.tokenNames, this.LT(1), n, false, this.getFilename());
            }
            this.consume();
        } else {
            this.consume();
        }
    }

    public void match(BitSet bitSet) throws MismatchedTokenException, TokenStreamException {
        if (!bitSet.member(this.LA(1))) {
            int n = this.LA(1);
            this.convertKeywordToIdentifier(1);
            if (!bitSet.member(this.LA(1))) {
                this.LT(1).setType(n);
                throw new MismatchedTokenException(this.tokenNames, this.LT(1), bitSet, false, this.getFilename());
            }
            this.consume();
        } else {
            this.consume();
        }
    }

    private void loadReservedWords() {
        String string = "\"";
        String[] stringArray = this.getTokenNames();
        this.m_reservedWords = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            if (!string2.startsWith(string) || !string2.endsWith(string)) continue;
            this.m_reservedWords.add(string2.substring(1, string2.length() - 1).toLowerCase());
        }
    }

    public void setKeywordIdType(int n) {
        this.m_keywordTokenType = n;
    }

    public void convertKeywordToIdentifier(int n) throws TokenStreamException {
    }

    public void recover(RecognitionException recognitionException, BitSet bitSet) throws TokenStreamException {
        boolean bl;
        FaultTolleranceFilter faultTolleranceFilter;
        String string = null;
        if (recognitionException != null) {
            string = recognitionException.toString();
        }
        if ((faultTolleranceFilter = this.getFaultTolleranceFilter()) == null) {
            return;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Token token = null;
        int n = this.LA(1);
        boolean bl2 = faultTolleranceFilter.getLexer().isLiteralToken(n);
        boolean bl3 = bl = bl2 && bitSet.member(n);
        if (string != null && this.m_lastException != null && this.m_lastException.equals(string)) {
            bl = false;
        }
        this.m_lastException = string;
        while (n != 1 && !bl) {
            token = this.LT(1);
            arrayList.add(token);
            this.consume();
            n = this.LA(1);
            bl2 = faultTolleranceFilter.getLexer().isLiteralToken(n);
            bl = bl2 && bitSet.member(n);
        }
        if (token == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProblemStatement() + " --SQLDEV: NOT RECOGNIZED");
        ExtToken extToken = new ExtToken(1199, stringBuffer.toString());
        extToken.setText(stringBuffer.toString());
        extToken.setLine(this.getFirstToken().getLine());
        extToken.setColumn(this.getFirstToken().getColumn());
        extToken.setCharPosition(this.getFirstToken().getCharPosition());
        faultTolleranceFilter.getCommentFilter().processCommentToken(extToken);
        this.reportLimitation(this.getFirstToken(), this.getLastToken());
    }

    public void consume() throws TokenStreamException {
        super.consume();
    }

    private void reportLimitation(Token token, Token token2) {
        this.getHelper().getLimitationManager().handleLimitation(token, token2, TranslationLimitation.Type.RECOVERY);
    }

    protected FaultTolleranceFilter getFaultTolleranceFilter() {
        TokenStream tokenStream = this.inputState.getInput().getInput();
        if (tokenStream instanceof FaultTolleranceFilter) {
            return (FaultTolleranceFilter)tokenStream;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProblemStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.m_firstToken = this.getFaultTolleranceFilter().getTokenBuffer().getFirst();
            this.m_lastToken = this.getFaultTolleranceFilter().getTokenBuffer().getLast();
            LinkedList<Token> linkedList = this.getFaultTolleranceFilter().getTokenBuffer();
            linkedList.removeLast();
            for (Token token : linkedList) {
                stringBuffer.append(token.getText());
                stringBuffer.append(" ");
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (this.getFaultTolleranceFilter() != null) {
                this.getFaultTolleranceFilter().clearTokenBuffer();
            }
        }
        return stringBuffer.toString();
    }

    private Token getFirstToken() {
        return this.m_firstToken;
    }

    private Token getLastToken() {
        return this.m_lastToken;
    }

    public TranslationHelper getHelper() {
        if (this.m_helper != null && this.m_helper.getLimitationManager() == null) {
            this.m_helper.defaultInit();
        }
        return this.m_helper;
    }

    public void setHelper(TranslationHelper translationHelper) {
        this.m_helper = translationHelper;
    }

    public void reportError(RecognitionException recognitionException) {
        String string = "";
        if (this.getHelper() != null && this.getHelper().getSourceDBObject() != null && this.getHelper().getSourceDBObject().getFullName() != null) {
            string = this.getHelper().getSourceDBObject().getFullName();
        }
        string = string + " [ " + recognitionException.toString() + " ]";
        this.getHelper().addError(string);
        System.out.println(string);
    }

    public void reportError(String string) {
        if (this.getFilename() == null) {
            // empty if block
        }
    }

    public void reportWarning(String string) {
        if (this.getFilename() == null) {
            // empty if block
        }
    }

    public int getSourceStartLine(AST aST) {
        int n = aST.getSourceStartLine();
        n = ASTUtil.walkAntlrTree((ExtAST)aST, new StartLineVisitor()).getValueInt();
        return n;
    }

    public int getSourceStartCol(AST aST) {
        int n = aST.getSourceStartCol();
        try {
            String[] stringArray = ASTUtil.walkAntlrTree((ExtAST)aST, new StartLineVisitor()).getValueStr().split(":");
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }
}

