/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.parser.defaults.DefaultTriggerContext;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.plugin.ITriggerContext;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.SQLStatement;
import oracle.dbtools.migration.translation.api.components.Trigger;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;

public class TriggerHelper {
    protected static final String REF_OLD = ":OLD";
    protected static final String REF_NEW = ":NEW";
    private boolean hasInserted = false;
    private boolean hasDeleted = false;
    private boolean useCompoundTrigger = false;
    private ITriggerContext m_context;
    private CodeBlockManager m_codeBlockMgr;
    private Hashtable<String, Trigger> m_triggerMap;
    private Trigger m_currentTrigger;
    private TranslationHelper m_translationHelper;

    public TriggerHelper(CodeBlockManager codeBlockManager, TranslationHelper translationHelper) {
        this.m_codeBlockMgr = codeBlockManager;
        this.m_triggerMap = new Hashtable();
        this.m_context = new DefaultTriggerContext();
        this.m_translationHelper = translationHelper;
    }

    public boolean useCompoundTrigger() {
        TranslationPreferences translationPreferences = this.m_translationHelper.getTranslationContext().getTranslationPreferences(null);
        boolean bl = false;
        bl = translationPreferences != null ? translationPreferences.getUseCompoundTrigger() : false;
        return (this.hasInserted || this.hasDeleted) && bl;
    }

    public void setInsertedUsed() {
        this.hasInserted = true;
    }

    public void setDeletedUsed() {
        this.hasDeleted = true;
    }

    public void setTriggerContext(ITriggerContext iTriggerContext) {
        this.m_context = iTriggerContext;
    }

    public void pushTrigger(AST aST) {
        Block block = this.m_codeBlockMgr.findEnclosingBlock(aST, "CREATEOBJBLOCK");
        String string = this.getKey(aST);
        if (!this.m_triggerMap.containsKey(string)) {
            this.m_currentTrigger = new Trigger(aST, block);
            this.m_triggerMap.put(string, this.m_currentTrigger);
        } else {
            this.m_currentTrigger = this.m_triggerMap.get(string);
        }
    }

    public void popTrigger() {
        this.m_currentTrigger = null;
    }

    public boolean hasCurrentTrigger() {
        return this.m_currentTrigger != null;
    }

    public void addDeleteTriggerEvent() {
        if (!this.hasCurrentTrigger()) {
            return;
        }
        this.m_currentTrigger.addTriggerEvent("DELETE");
    }

    public void addInsertTriggerEvent() {
        if (!this.hasCurrentTrigger()) {
            return;
        }
        this.m_currentTrigger.addTriggerEvent("INSERT");
    }

    public void addUpdateTriggerEvent() {
        if (!this.hasCurrentTrigger()) {
            return;
        }
        this.m_currentTrigger.addTriggerEvent("UPDATE");
    }

    public void addDMLStatement(AST aST) {
        if (!this.hasCurrentTrigger()) {
            return;
        }
        this.m_currentTrigger.addDMLStatement(aST);
    }

    public void addTableRef(AST aST, String string, String string2) {
        if (!this.hasCurrentTrigger()) {
            return;
        }
        Block block = this.m_codeBlockMgr.findEnclosingDMLBlock(aST);
        if (block == null) {
            return;
        }
        SQLStatement sQLStatement = this.m_currentTrigger.getDMLStatement(block.getAST());
        if (sQLStatement == null) {
            return;
        }
        sQLStatement.addTableReference(string, string2);
    }

    public ArrayList<String> getColumnNamesOfTargetTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_currentTrigger != null) {
            String string = this.m_currentTrigger.getTargetObjectName();
            if (this.m_translationHelper.getSourceDBObject() != null) {
                TranslationDBObjectReference translationDBObjectReference;
                TranslationDBObjectReference translationDBObjectReference2 = translationDBObjectReference = this.m_translationHelper.getSourceDBObject().getDBObjectReference();
                translationDBObjectReference2.setObjName(string);
                translationDBObjectReference2.setType(TranslationObjectType.TABLE_TYPE);
                Object object = translationDBObjectReference2.getOMWBObj();
                translationDBObjectReference2.setOMWBObj(null);
                try {
                    this.m_translationHelper.getTranslationContext().completeSourceObject(translationDBObjectReference2, object);
                }
                catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
                    // empty catch block
                }
                TranslationDBObjectReference translationDBObjectReference3 = null;
                try {
                    translationDBObjectReference3 = this.m_translationHelper.getTranslationContext().getTargetDBObjectReference(translationDBObjectReference2, this.m_translationHelper.getSourceDBObject());
                }
                catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
                    // empty catch block
                }
                ArrayList<TranslationColumn> arrayList2 = null;
                try {
                    arrayList2 = this.m_translationHelper.getTranslationContext().getTargetColumns(translationDBObjectReference2);
                }
                catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
                    // empty catch block
                }
                if (arrayList2 != null) {
                    for (TranslationColumn translationColumn : arrayList2) {
                        arrayList.add(translationColumn.getColumnName());
                    }
                }
            } else {
                arrayList.add("<TODO:unknownColumnNames>");
            }
        } else {
            arrayList.add("<TODO:unknownColumnNames>");
        }
        return arrayList;
    }

    public void setTriggerTargetName(AST aST, String string) {
        Trigger trigger = this.m_triggerMap.get(this.getKey(aST));
        if (trigger == null) {
            return;
        }
        trigger.setTargetObjectName(string);
    }

    public boolean isPartOfTriggerDefinition(AST aST) {
        return false;
    }

    public String getDeletedName() {
        return this.getCompoundTableName("DELETED_");
    }

    public String getInsertedName() {
        return this.getCompoundTableName("INSERTED_");
    }

    public String getCompoundTableName(String string) {
        String string2 = this.m_currentTrigger.getTargetObjectName();
        if (string2.indexOf(".") != -1) {
            int n = string2.lastIndexOf(46);
            String string3 = string2.substring(0, n - 1);
            String string4 = string2.substring(n + 1);
            return string3 + "." + string + string4;
        }
        return string + string2;
    }

    public boolean isTriggerTargetObject(AST aST, Object object) {
        if (object == null) {
            return false;
        }
        Trigger trigger = this.getTrigger(aST);
        if (trigger == null) {
            return false;
        }
        return object.toString().equalsIgnoreCase(trigger.getTargetObjectName());
    }

    public Trigger getTrigger(AST aST) {
        Trigger trigger = this.m_triggerMap.get(this.getKey(aST));
        if (trigger != null) {
            return trigger;
        }
        Block block = null;
        Block block2 = this.m_codeBlockMgr.findEnclosingBlock(aST, "STMTBLOCK");
        if (block2 != null) {
            block = block2.getEnclosingBlockByType("CREATEOBJBLOCK");
        }
        if (block != null && block.getAST() != null) {
            trigger = this.m_triggerMap.get(this.getKey(block.getAST()));
        }
        return trigger;
    }

    public void reinit() {
        this.m_triggerMap.clear();
        this.m_currentTrigger = null;
    }

    public String[] getAllColumnNames(AST aST, ITranslationContext iTranslationContext) {
        return this.getAllColumnNames(aST, iTranslationContext, null);
    }

    public String[] getAllColumnNames(AST aST, ITranslationContext iTranslationContext, String string) {
        Object object;
        Object object2;
        Object object3;
        SQLStatement sQLStatement = null;
        Trigger trigger = null;
        String string2 = "";
        String string3 = null;
        String[] stringArray = new String[]{string};
        ArrayList arrayList = null;
        trigger = this.getTrigger(aST);
        if (trigger == null) {
            return stringArray;
        }
        sQLStatement = this.getDMLStatement(trigger, aST);
        if (sQLStatement == null) {
            return stringArray;
        }
        if (string != null) {
            if (string.indexOf(".") == -1) {
                return stringArray;
            }
            string3 = string.substring(string.lastIndexOf(".", string.lastIndexOf(".") - 1) + 1, string.lastIndexOf("."));
            object3 = sQLStatement.getTableNameForAlias(string3);
            Object object4 = object3 = object3 == null ? string3 : object3;
            if (!this.m_context.isTargetObjectCollation(trigger, (String)object3)) {
                return stringArray;
            }
        }
        if (iTranslationContext == null) {
            return stringArray;
        }
        object3 = null;
        try {
            object2 = new TranslationDBObjectReference(null, null, null, trigger.getTargetObjectName(), null, TranslationObjectType.TABLE_TYPE);
            object = this.getTranslationHelper().getSourceDBObject();
            if (object != null) {
                ((TranslationDBObjectReference)object2).setOMWBObj(((TranslationDBObjectReference)object).getOMWBObj());
            }
            object3 = iTranslationContext.getTargetColumns((TranslationDBObjectReference)object2);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (object3 == null) {
            return stringArray;
        }
        arrayList = new ArrayList();
        arrayList.addAll(object3);
        if (arrayList.size() == 0) {
            return stringArray;
        }
        stringArray = new String[arrayList.size()];
        object2 = this.getColumnNamesOfTargetTable();
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            String string4 = (String)object.next();
            if (!string4.toUpperCase().equals(string.toUpperCase())) continue;
            string2 = this.getColumnPrefix(trigger, sQLStatement, string3);
            break;
        }
        if (string2 != null) {
            string2 = string2.trim().length() > 0 ? string2 + "." : " ";
            int n = 0;
            for (TranslationColumn translationColumn : arrayList) {
                stringArray[n++] = string2 + translationColumn.getColumnName();
            }
        }
        return stringArray;
    }

    public String getColumnName(AST aST, String string, String string2) {
        Object object;
        Trigger trigger = null;
        SQLStatement sQLStatement = null;
        trigger = this.getTrigger(aST);
        if (trigger == null) {
            return string2;
        }
        String string3 = "";
        sQLStatement = this.getDMLStatement(trigger, aST);
        if (string != null && sQLStatement != null && !this.useCompoundTrigger() && (object = sQLStatement.getTableNameForAlias(string)) != null && (((String)object).equalsIgnoreCase("INSERTED") || ((String)object).equalsIgnoreCase("DELETED"))) {
            string = ((String)object).toUpperCase();
        }
        if (sQLStatement != null) {
            object = this.getColumnNamesOfTargetTable();
            if (string != null && string.equalsIgnoreCase("INSERTED")) {
                string3 = ":NEW.";
            } else if (string != null && string.equalsIgnoreCase("DELETED")) {
                string3 = ":OLD.";
            } else if (string != null) {
                string3 = string + ".";
            } else if (sQLStatement != null && sQLStatement.getTableNames().length == 1 && sQLStatement.getTableNames()[0].equalsIgnoreCase("INSERTED")) {
                string3 = ":NEW.";
            } else if (sQLStatement != null && sQLStatement.getTableNames().length == 1 && sQLStatement.getTableNames()[0].equalsIgnoreCase("DELETED")) {
                string3 = ":OLD.";
            } else if (object != null && ((ArrayList)object).size() > 0) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (!string4.toUpperCase().equals(string2.toUpperCase())) continue;
                    string3 = this.getColumnPrefix(trigger, sQLStatement, string);
                    string3 = string3.trim().length() > 0 ? string3 + "." : (string != null ? string + "." : "");
                    break;
                }
            }
        } else {
            string3 = this.getTriggerTableRefPrefix(trigger, null);
            String string5 = string3 = string3 != null ? string3 + "." : "";
        }
        if (this.useCompoundTrigger()) {
            if (string3.equalsIgnoreCase(":OLD.")) {
                string3 = this.getDeletedName() + ".";
            } else if (string3.equalsIgnoreCase(":NEW.")) {
                string3 = this.getInsertedName() + ".";
            }
        }
        return string3 + string2;
    }

    private String getColumnPrefix(Trigger trigger, SQLStatement sQLStatement, String string) {
        String string2 = null;
        if (string == null) {
            for (String string3 : sQLStatement.getTableNames()) {
                string2 = this.getTriggerTableRefPrefix(trigger, string3);
                if (string2 == null) continue;
                return string2;
            }
        } else {
            string2 = this.getTriggerTableRefPrefix(trigger, string);
            if (string2 != null) {
                return string2;
            }
            String string4 = sQLStatement.getTableNameForAlias(string);
            if (string4 != null && (string2 = this.getTriggerTableRefPrefix(trigger, string4)) != null) {
                return string2;
            }
        }
        return string != null ? string : "";
    }

    private String getTriggerTableRefPrefix(Trigger trigger, String string) {
        if (this.m_context.isCollationForOldValues(trigger, string)) {
            return REF_OLD;
        }
        if (this.m_context.isCollationForNewValues(trigger, string)) {
            return REF_NEW;
        }
        if (string == null) {
            return !trigger.hasUpdateTriggerEvent() && !trigger.hasInsertTriggerEvent() ? REF_OLD : REF_NEW;
        }
        return null;
    }

    private SQLStatement getDMLStatement(Trigger trigger, AST aST) {
        SQLStatement sQLStatement = null;
        Block block = this.m_codeBlockMgr.findEnclosingDMLBlock(aST);
        if (block != null && block.getAST() != null) {
            sQLStatement = trigger.getDMLStatement(block.getAST());
        }
        return sQLStatement;
    }

    private String getKey(AST aST) {
        return aST.getSourceStartLine() + ":" + aST.getSourceStartCol();
    }

    private TranslationHelper getTranslationHelper() {
        return this.m_translationHelper;
    }
}

