/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.AbstractDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.editors.DBObjectOverviewEditor;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.ideimpl.db.panels.TraversableProxy;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.ideimpl.db.validate.ModalValidationManager;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;

public class BaseDBEditorFactory
extends AbstractDBEditorFactory {
    private static final String CREATE_CONTEXT_PROP = "BaseDBEditorFactory.CREATE_CONTEXT";
    private final Map<String, PanelLibrary> m_libraries = new HashMap<String, PanelLibrary>();
    private final Map<String, Class<? extends PanelLibrary>> m_libraryClasses = new HashMap<String, Class<? extends PanelLibrary>>();

    protected BaseDBEditorFactory() {
    }

    @Deprecated
    public PanelLibrary getPanelLibrary(String string) {
        return this.getPanelLibrary(null, string);
    }

    @Override
    public PanelLibrary getPanelLibrary(DBObjectProvider dBObjectProvider, String string) {
        PanelLibrary panelLibrary = this.m_libraries.get(string);
        if (panelLibrary == null && (panelLibrary = this.createLibrary(string)) != null) {
            this.initializeLibrary(panelLibrary);
            this.m_libraries.put(string, panelLibrary);
        }
        return panelLibrary;
    }

    protected PanelLibrary createLibrary(String string) {
        PanelLibrary panelLibrary = null;
        Class<? extends PanelLibrary> clazz = this.m_libraryClasses.get(string);
        if (clazz != null) {
            try {
                panelLibrary = clazz.newInstance();
            }
            catch (Exception exception) {
                DBLog.logStackTrace((String)"Could not init library", (Throwable)exception);
            }
        }
        return panelLibrary;
    }

    protected void initializeLibrary(PanelLibrary panelLibrary) {
    }

    protected void registerLibrary(String string, Class<? extends PanelLibrary> clazz) {
        this.m_libraryClasses.put(string, clazz);
    }

    protected boolean registerOtherLibrary(String string, DatabaseDescriptor databaseDescriptor) {
        Class<? extends PanelLibrary> clazz;
        boolean bl = false;
        DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.findDatabaseFactory(databaseDescriptor);
        if (dBEditorFactory instanceof BaseDBEditorFactory && (clazz = ((BaseDBEditorFactory)dBEditorFactory).m_libraryClasses.get(string)) != null) {
            this.registerLibrary(string, clazz);
            bl = true;
        }
        return bl;
    }

    protected void unregisterLibrary(String string, Class<? extends PanelLibrary> clazz) {
        Class<? extends PanelLibrary> clazz2 = this.m_libraryClasses.get(string);
        if (clazz2 != null) {
            if (clazz2.equals(clazz)) {
                this.m_libraryClasses.remove(string);
                this.m_libraries.remove(string);
            } else {
                DBLog.getLogger((Object)this).warning("Cannot remove library for " + string + " as libClass doesn't match.");
            }
        }
    }

    @Override
    @Deprecated
    public String[] listSupportedTypes() {
        Collection<String> collection = this.listSupportedTypesImpl();
        return collection.toArray(new String[collection.size()]);
    }

    @Deprecated
    protected Collection<String> listSupportedTypesImpl() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.m_libraryClasses.keySet());
        return arrayList;
    }

    @Override
    @Deprecated
    public boolean isCreateSupported(String string) {
        return this.listSupportedTypesImpl().contains(string);
    }

    @Override
    public boolean canCreateDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string) {
        boolean bl;
        boolean bl2 = bl = this.getPanelLibrary(dBObjectProvider, string) != null;
        if (bl && Metadata.getInstance().isTypeOf(SystemObject.class, string)) {
            bl = this.supportsObjectType(string, dBObjectProvider);
        }
        return bl;
    }

    protected boolean supportsObjectType(String string, DBObjectProvider dBObjectProvider) {
        return dBObjectProvider.supportsObjectType(string);
    }

    private void throwConfigException(DBEditorConfig dBEditorConfig, String string) {
        throw new IllegalArgumentException("DBEditorConfig is missing: " + string);
    }

    private String getUnsupportedErrorMessage(String string, String string2) {
        return UIBundle.format("DBOBJECT_EDIT_OBJ_UNSUPPORTED", DBTypeDisplayRegistry.getSingularDisplayName(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void launchDialog(final DBEditorConfig dBEditorConfig) {
        String string = dBEditorConfig.getObjectType();
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        if (dBObjectProvider == null) {
            this.throwConfigException(dBEditorConfig, "DBObjectProvider");
        }
        String string2 = BaseDBEditorFactory.getTimestampKey(string) + System.nanoTime();
        DBUtil.suspendTimestampChecking((DBObjectProvider)dBObjectProvider, (String)string2);
        try {
            final PanelLibrary panelLibrary = this.getPanelLibrary(dBObjectProvider, string);
            if (panelLibrary == null) {
                dBEditorConfig.setResult(DBEditorConfig.Result.ERROR);
                DBObjectNode dBObjectNode = dBEditorConfig.getOriginalObjectNode();
                if (dBObjectNode != null) {
                    throw new DBException(null, this.getUnsupportedErrorMessage(string, dBObjectNode.getObjectName()));
                }
            } else {
                Runnable runnable;
                if (panelLibrary.prepareEditorInBackground(dBEditorConfig)) {
                    DBUIProgressBar dBUIProgressBar = new DBUIProgressBar(ProviderOperator.getTitle(dBEditorConfig));
                    runnable = dBUIProgressBar.execute(new DBUIProgressBar.ProgressCallable<Runnable, DBException>(){

                        @Override
                        public Runnable call() throws DBException {
                            return BaseDBEditorFactory.this.prepareEditorImpl(dBEditorConfig, panelLibrary);
                        }
                    }, UIBundle.format("DBOBJECT_PREPARE_EDITOR", dBEditorConfig.getOriginalObjectName()), null);
                    if (dBUIProgressBar.hasUserCancelled()) {
                        throw new CancelledException();
                    }
                } else {
                    runnable = this.prepareEditorImpl(dBEditorConfig, panelLibrary);
                }
                runnable.run();
                this.checkCommit(dBEditorConfig, panelLibrary);
            }
        }
        catch (CancelledException cancelledException) {
            DBLog.getLogger((Object)this).fine(cancelledException.getMessage());
            dBEditorConfig.setResult(DBEditorConfig.Result.CANCELLED);
            dBEditorConfig.setException((DBException)((Object)cancelledException));
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), DBTypeDisplayRegistry.getDialogTitle(string, dBEditorConfig.isEdit(), true), dBException);
            dBEditorConfig.setResult(DBEditorConfig.Result.ERROR);
            dBEditorConfig.setException(dBException);
        }
        finally {
            DBUtil.resumeTimestampChecking((DBObjectProvider)dBObjectProvider, (String)string2);
        }
    }

    private Runnable prepareEditorImpl(DBEditorConfig dBEditorConfig, PanelLibrary panelLibrary) throws DBException {
        Runnable runnable;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        String string = dBEditorConfig.getObjectType();
        try {
            Object object;
            boolean bl;
            Schema schema = dBEditorConfig.getSchema();
            SystemObject systemObject = dBEditorConfig.getOriginalObject();
            boolean bl2 = bl = systemObject != null;
            if (bl) {
                if (panelLibrary.canReplaceByDefault()) {
                    dBEditorConfig.setReplaceAlwaysAllowed(true);
                }
                if (panelLibrary.shouldResetObjectBeforeEdit(dBEditorConfig)) {
                    DBUtil.forceObjectReset((SystemObject)systemObject, (DBObjectProvider)dBObjectProvider);
                }
            }
            SystemObject systemObject2 = dBEditorConfig.getUpdatedObject();
            if (bl && (!((object = systemObject2.getID()) instanceof TemporaryObjectID) || ((TemporaryObjectID)object).getOriginalObject() != systemObject)) {
                throw new IllegalStateException("newObject must be a temp copy of oldObject.");
            }
            object = Metadata.getInstance().getObjectClass(string);
            if (bl && !((Class)object).isAssignableFrom(systemObject.getClass())) {
                Object object2 = dBEditorConfig.getChildObject();
                if (object2 == null) {
                    object2 = panelLibrary.getObjectForCreate(schema, dBObjectProvider, (DBObject)systemObject2);
                    bl = false;
                } else if (TemporaryObjectID.findOriginalObject((DBObject)object2) == null) {
                    bl = false;
                }
                dBEditorConfig.setChildObject((DBObject)object2);
            } else if (systemObject2 == null) {
                SchemaObject schemaObject = dBEditorConfig.getContextObject();
                systemObject2 = (SystemObject)panelLibrary.getObjectForCreate(schema, dBObjectProvider, (DBObject)schemaObject);
                dBEditorConfig.setUpdatedObject(systemObject2);
            }
            if (systemObject2.getName() == null) {
                panelLibrary.makeNameUnique((DBObject)systemObject2, schema, dBObjectProvider, null);
            }
            CancelledException.checkInterrupt();
            if (!panelLibrary.checkPrivilege(systemObject2, dBObjectProvider, bl)) {
                throw new DBException((DBObject)systemObject2, UIBundle.get("DBOBJECT_INSUFFICIENT_PRIVS"));
            }
            runnable = this.prepareEditor(dBEditorConfig, panelLibrary, bl);
        }
        catch (RuntimeException runtimeException) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to launch editor", runtimeException);
            dBEditorConfig.setResult(DBEditorConfig.Result.ERROR);
            runnable = null;
        }
        return runnable;
    }

    protected Runnable prepareEditor(DBEditorConfig dBEditorConfig, PanelLibrary panelLibrary, boolean bl) throws DBException {
        Runnable runnable;
        dBEditorConfig.setException(null);
        dBEditorConfig.setResult(DBEditorConfig.Result.IN_PROGRESS);
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        DBEditorFactory.EditorType editorType = this.determineEditorType(dBEditorConfig);
        dBEditorConfig.setEditorType(editorType);
        List<Navigable> list = panelLibrary.getNavigables(dBEditorConfig);
        if (list == null) {
            Object object = dBEditorConfig.isChildEditOnly() ? dBEditorConfig.getChildObject() : dBEditorConfig.getUpdatedObject();
            dBEditorConfig.setResult(DBEditorConfig.Result.ERROR);
            if (!bl && TemplateExpander.isPendingObject((DBObject)object)) {
                String[] stringArray = TemplateExpander.getTemplateObjectName((DBObject)object).split("\\.");
                throw new DBException(object, UIBundle.format("DBOBJECT_CREATE_INVALID_TEMPLATE", DBTypeDisplayRegistry.getSingularDisplayName(object.getType()), stringArray[stringArray.length - 1]));
            }
            throw new DBException(object, this.getUnsupportedErrorMessage(object.getType(), object.getName()));
        }
        Traversable traversable = panelLibrary.getMainDialogPanel(dBEditorConfig, list.toArray(new Navigable[list.size()]));
        if (traversable == null) {
            runnable = () -> panelLibrary.commitToProvider(dBEditorConfig);
        } else {
            Namespace namespace = this.createNamespace(dBEditorConfig);
            namespace.put(PanelLibrary.class.getName(), (Object)panelLibrary);
            String string = (bl ? "edit" : "create") + dBEditorConfig.getObjectType();
            String string2 = bl ? panelLibrary.getEditTitle() : panelLibrary.getCreateTitle();
            Dimension dimension = panelLibrary.getSize(bl);
            Dimension dimension2 = dimension == null && list.size() == 0 ? OracleDBEditorFactory.NO_PANELS_DIALOG_SIZE : dimension;
            panelLibrary.prepareObjectForEditor(dBEditorConfig, list);
            runnable = () -> this.launchDialog(namespace, string2, bl, traversable, panelLibrary, dimension2, string);
        }
        CancelledException.checkInterrupt();
        return runnable;
    }

    private void checkCommit(DBEditorConfig dBEditorConfig, PanelLibrary panelLibrary) {
        if (dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS) {
            this.commitPerformed(dBEditorConfig, panelLibrary);
        }
    }

    protected DBEditorFactory.EditorType determineEditorType(DBEditorConfig dBEditorConfig) {
        return dBEditorConfig.isEdit() ? DBEditorFactory.EditorType.EDIT_MODAL : DBEditorFactory.EditorType.CREATE_MODAL;
    }

    public void commitPerformed(DBEditorConfig dBEditorConfig, PanelLibrary panelLibrary) {
        if (panelLibrary.showEditorAfterCommit()) {
            BaseDBEditorFactory.showEditor(dBEditorConfig);
        }
    }

    @Override
    public boolean canEditDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        String string;
        PanelLibrary panelLibrary;
        boolean bl = false;
        if (dBObject != null && (panelLibrary = this.getPanelLibrary(dBObjectProvider, string = dBObject.getType())) != null && panelLibrary.canEditObject(dBObject, dBObjectProvider)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public String getCreateLabel(String string) {
        PanelLibrary panelLibrary = this.getPanelLibrary(null, string);
        if (panelLibrary != null) {
            return panelLibrary.getCreateText();
        }
        return DBTypeDisplayRegistry.getNewMenuItemText(string);
    }

    public Namespace createNamespace(DBEditorConfig dBEditorConfig) {
        Namespace namespace = new Namespace();
        namespace.put(DBEditorConfig.class.getName(), (Object)dBEditorConfig);
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        namespace.put("oracle.javatools.db.DBObjectProvider", (Object)dBObjectProvider);
        SystemObject systemObject = dBEditorConfig.getOriginalObject();
        boolean bl = systemObject != null;
        SystemObject systemObject2 = dBEditorConfig.getUpdatedObject();
        if (systemObject2 != null) {
            namespace.put("OriginalObject", (Object)systemObject);
            namespace.put("NewObject", (Object)systemObject2);
            if (dBEditorConfig.isChildEditOnly()) {
                namespace.put("NewChildObject", (Object)dBEditorConfig.getChildObject());
            }
            boolean bl2 = !bl || !dBEditorConfig.isCommitToProvider() || this.canUpdateObject((DBObject)systemObject2, dBObjectProvider);
            dBEditorConfig.setEditable(bl2);
            Schema schema = DBUtil.getSchema((DBObject)systemObject2);
            namespace.put("oracle.javatools.db.Schema", (Object)schema);
        }
        return namespace;
    }

    protected boolean canUpdateObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return true;
    }

    private void launchDialog(Namespace namespace, String string, boolean bl, Traversable traversable, PanelLibrary panelLibrary, Dimension dimension, String string2) {
        Component component = DBMessageDialog.getDialogParent();
        TraversableProxy traversableProxy = new TraversableProxy(traversable);
        TDialogLauncher tDialogLauncher = new TDialogLauncher(component, string, (Traversable)traversableProxy, namespace);
        if (dimension != null) {
            tDialogLauncher.setInitialSize(dimension);
        }
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setName(string2);
        namespace.put(JEWTDialog.class.getName(), (Object)jEWTDialog);
        if (Boolean.getBoolean("ide.db.liveValidate") && namespace.get(DBValidationManager.class) == null) {
            namespace.put(DBValidationManager.class.getName(), (Object)new ModalValidationManager(jEWTDialog));
        }
        DBEditorConfig dBEditorConfig = (DBEditorConfig)namespace.find(DBEditorConfig.class);
        jEWTDialog.setOKButtonEnabled(dBEditorConfig.isEditable());
        Component component2 = this.getDialogHeader(dBEditorConfig);
        if (component2 != null) {
            jEWTDialog.setDialogHeader(component2);
        }
        traversableProxy.enable();
        Component component3 = panelLibrary.getInitialFocus(traversable);
        if (component3 != null) {
            jEWTDialog.setInitialFocus(component3);
        }
        if (!tDialogLauncher.showDialog() && dBEditorConfig.getResult() == DBEditorConfig.Result.IN_PROGRESS) {
            dBEditorConfig.setResult(DBEditorConfig.Result.CANCELLED);
        }
    }

    protected Component getDialogHeader(DBEditorConfig dBEditorConfig) {
        return null;
    }

    public static String getTimestampKey(String string) {
        return string + "EditDialog";
    }

    public static boolean isCreateContext(Context context) {
        return Boolean.TRUE.equals(context.getProperty(CREATE_CONTEXT_PROP));
    }

    public static void setEditorType(DBEditorConfig dBEditorConfig, DBEditorFactory.EditorType editorType) {
        if (dBEditorConfig != null) {
            dBEditorConfig.setEditorType(editorType);
        }
    }

    public static void showEditor(final DBEditorConfig dBEditorConfig) {
        final DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        final SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        URL uRL = DBURLFactory.getURL(dBObjectProvider, systemObject);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)uRL);
        }
        catch (Exception exception) {
            DBLog.getLogger(BaseDBEditorFactory.class).log(DBLog.getExceptionLogLevel(), "Error finding object node.", exception);
        }
        if (node != null) {
            Context context;
            final EditorManager editorManager = EditorManager.getEditorManager();
            List list = editorManager.findEditors(context = Context.newIdeContext((Node)node));
            if (list != null) {
                for (Editor editor : list) {
                    if (!(editor instanceof DBObjectOverviewEditor)) continue;
                    ((DBObjectOverviewEditor)editor).changeEditorConfig(dBEditorConfig);
                    break;
                }
            }
            if (dBEditorConfig.getOriginalObject() == null) {
                context.setProperty(CREATE_CONTEXT_PROP, (Object)Boolean.TRUE);
            } else {
                DBEditorConfig.setConfig(context, dBEditorConfig);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    block9: {
                        if (systemObject instanceof SourceObject) {
                            DBUIProgressBar.ProgressCallable<Integer, CancelledException> progressCallable;
                            Object object;
                            int n = 0;
                            if (systemObject instanceof PlSqlSourceObject) {
                                object = new DBUIProgressBar(UIBundle.get("PLSQL_FINDING_OFFSET"));
                                progressCallable = new DBUIProgressBar.ProgressCallable<Integer, CancelledException>(){

                                    @Override
                                    public Integer call() throws CancelledException {
                                        Integer n = null;
                                        PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)systemObject), (DBObjectProvider)dBObjectProvider);
                                        if (plSqlParser != null) {
                                            Object[] objectArray;
                                            DBObjectPlSqlFragment dBObjectPlSqlFragment = (DBObjectPlSqlFragment)systemObject;
                                            DBObject dBObject = dBEditorConfig.getChildObject();
                                            if (dBObject instanceof DBObjectPlSqlFragment) {
                                                dBObjectPlSqlFragment = (DBObjectPlSqlFragment)dBObject;
                                                n = dBObjectPlSqlFragment.getStartOffset();
                                            } else {
                                                n = plSqlParser.getStartOffsetOfObject();
                                            }
                                            String string = dBEditorConfig.getProperty();
                                            if (string != null && (objectArray = plSqlParser.getPropertyNodes(dBObjectPlSqlFragment, string)).length > 0) {
                                                n = plSqlParser.getStartOffset(objectArray[0]);
                                            }
                                        }
                                        return n;
                                    }
                                };
                                try {
                                    Integer n2 = ((DBUIProgressBar)object).execute(progressCallable);
                                    if (n2 != null) {
                                        n = n2;
                                    }
                                }
                                catch (CancelledException cancelledException) {
                                    // empty catch block
                                }
                            }
                            try {
                                object = NavigationManager.getNavigationManager();
                                progressCallable = new OffsetNavigationPoint(context, n, 0);
                                progressCallable.setPreferredEditorType(null);
                                if (object != null) {
                                    object.navigateTo((NavigationPoint)progressCallable);
                                    break block9;
                                }
                                progressCallable.navigate();
                            }
                            catch (Exception exception) {
                                DBLog.getLogger((Object)this).log(DBLog.getExceptionLogLevel(), "Error opening editor.", exception);
                            }
                        } else {
                            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                            openEditorOptions.setEditorClass(DBObjectOverviewEditor.class);
                            editorManager.openEditor(openEditorOptions);
                        }
                    }
                }
            });
        }
    }
}

