/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;

final class PlSqlBreadcrumb
implements Breadcrumb<Integer> {
    private static final StyledTextAttribute NORMAL_ATTR;
    private static final StyledTextAttribute BOLD_ATTR;
    private StyledTextModel m_shortName;
    private StyledTextModel m_longName;
    private int m_startOffset;
    private PlSqlCodeFragment m_source;
    private String m_peekText;

    PlSqlBreadcrumb(String string, String string2, int n, PlSqlCodeFragment plSqlCodeFragment, String string3) {
        this.m_shortName = new StyledTextModel(string, BOLD_ATTR);
        this.m_longName = new StyledTextModel();
        this.m_longName.addText(string, BOLD_ATTR);
        if (string2 != null) {
            this.m_longName.addText(string2, NORMAL_ATTR);
        }
        this.m_startOffset = n;
        this.m_source = plSqlCodeFragment;
        this.m_peekText = string3;
    }

    public StyledTextModel getShortName() {
        return this.m_shortName;
    }

    public StyledTextModel getLongName() {
        return this.m_longName;
    }

    public Integer getUserObject() {
        return this.m_startOffset;
    }

    public boolean canHavePopupItems() {
        return this.m_source instanceof PlSqlSchemaObjectSpec || this.m_source instanceof PlSqlSchemaObjectBody;
    }

    public List<PopupItem<Integer>> getPopupItems() {
        if (this.canHavePopupItems()) {
            DBUIProgressBar dBUIProgressBar = new DBUIProgressBar(UIBundle.format("PLSQL_BREADCRUMBS_TASK", this.m_source.getName()));
            List<PopupItem<Integer>> list = dBUIProgressBar.execute(new DBUIProgressBar.ProgressCallable<List<PopupItem<Integer>>, RuntimeException>(){

                @Override
                public List<PopupItem<Integer>> call() {
                    ArrayList<PopupItem<Integer>> arrayList = new ArrayList<PopupItem<Integer>>();
                    for (PlSqlSubProgram plSqlSubProgram : ((PlSqlSchemaObject)PlSqlBreadcrumb.this.m_source).getSubPrograms()) {
                        PopupItem popupItem = new PopupItem();
                        String string = plSqlSubProgram.getSignature();
                        if (string.length() > 100) {
                            string = string.substring(0, 100) + "...";
                        }
                        popupItem.setName(string);
                        popupItem.setUserObject((Object)plSqlSubProgram.getStartOffset());
                        arrayList.add((PopupItem<Integer>)popupItem);
                    }
                    Collections.sort(arrayList);
                    return arrayList;
                }
            });
            if (!dBUIProgressBar.hasUserCancelled()) {
                return list;
            }
        }
        return Collections.emptyList();
    }

    public String getPeekText() {
        return this.m_peekText;
    }

    static {
        Font font = UIManager.getFont("Label.font");
        NORMAL_ATTR = new StyledTextAttribute(font, null);
        BOLD_ATTR = new StyledTextAttribute(font.deriveFont(1), null);
    }
}

