/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ideimpl.db.ceditor.PlSqlFoldingBlock;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;

public class PlSqlFoldingModel
extends DefaultCodeFoldingModel<PlSqlFoldingBlock> {
    private final String m_eol;
    private final BaseDBObjectTextNode m_node;
    private LineMap m_map;
    private final Collection<Integer> m_collapsedOffsets = new HashSet<Integer>();
    private final CodeFoldingMargin m_margin;
    private PlSqlParser m_parser;

    public PlSqlFoldingModel(BasicDocument basicDocument, BaseDBObjectTextNode baseDBObjectTextNode, CodeFoldingMargin codeFoldingMargin) {
        super(basicDocument);
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        this.m_eol = textBuffer.getEOLType();
        this.m_node = baseDBObjectTextNode;
        this.m_margin = codeFoldingMargin;
        this.setRoot(new PlSqlFoldingBlock());
        this.resetRoot();
    }

    final void resetRoot() {
        DBRequestProcessor dBRequestProcessor = DBRequestProcessorFactory.getProcessor(this.m_node);
        String string = this.getRequestProcessorKey();
        DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor;
        dBRequestProcessor2.getClass();
        dBRequestProcessor.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor2, this.m_node.getProvider(), UIBundle.format("PLSQL_FOLDING_TASK", this.m_node.getShortLabel())){
            {
                DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor;
                dBRequestProcessor2.getClass();
                super(dBObjectProvider, string);
            }

            @Override
            protected void doWork() throws DBException {
                PlSqlFoldingModel.this.resetRootImpl();
            }
        }, 1500);
    }

    private void resetRootImpl() throws CancelledException {
        PlSqlParser plSqlParser;
        boolean bl;
        TextBuffer textBuffer = this.m_node.acquireTextBuffer();
        this.m_map = textBuffer == null ? null : textBuffer.getLineMap();
        PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)this.m_node.getDBObjectFromBuffer();
        boolean bl2 = bl = plSqlSourceObject == null;
        if (!bl && this.getRoot() != null) {
            plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)this.m_node.getProvider());
            bl = plSqlParser == null || !plSqlParser.getIssues().isEmpty();
        } else {
            plSqlParser = null;
        }
        if (!bl && this.m_map != null) {
            int n;
            this.m_parser = plSqlParser;
            DefaultFoldingBlock[] defaultFoldingBlockArray = this.getCollapsedBlocks();
            this.m_collapsedOffsets.clear();
            for (n = 0; n < defaultFoldingBlockArray.length; ++n) {
                this.m_collapsedOffsets.add(defaultFoldingBlockArray[n].getStartOffset());
            }
            if (plSqlParser != null) {
                n = plSqlParser.getStartOffsetOfObject();
                int n2 = plSqlParser.getEndOffsetOfObject();
                Object object = plSqlParser.getParseNode(n);
                final PlSqlFoldingBlock plSqlFoldingBlock = new PlSqlFoldingBlock();
                this.populateFoldingBlock(plSqlFoldingBlock, object, n, n2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlSqlFoldingModel.this.setRoot(plSqlFoldingBlock);
                    }
                });
            }
        }
    }

    private void populateFoldingBlock(PlSqlFoldingBlock plSqlFoldingBlock, Object object, int n, int n2) throws CancelledException {
        plSqlFoldingBlock.setUserObject(object);
        plSqlFoldingBlock.setStartOffset(n);
        plSqlFoldingBlock.setEndOffset(n2);
        int n3 = this.m_map.getLineEndOffset(this.m_map.getLineFromOffset(n));
        if (n3 > n2) {
            n3 = n2;
        }
        PlSqlToken plSqlToken = this.m_parser.getTokenAtOffset(n);
        PlSqlToken plSqlToken2 = this.m_parser.getTokenAtOffset(n3);
        if (plSqlToken != null && plSqlToken2 != null) {
            if (!plSqlToken2.isCode()) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
            }
            plSqlFoldingBlock.setReplacementText(plSqlToken.getSource(false, (Token)plSqlToken2) + "...");
        }
    }

    public Iterator getChildren(PlSqlFoldingBlock plSqlFoldingBlock) {
        Object object;
        if (!plSqlFoldingBlock.isChildrenLoaded() && (object = plSqlFoldingBlock.getUserObject()) != null) {
            try {
                this.addChildren(plSqlFoldingBlock, object);
                plSqlFoldingBlock.setChildrenLoaded(true);
            }
            catch (CancelledException cancelledException) {
                DBLog.getLogger((Object)((Object)this)).fine(cancelledException.getMessage());
            }
        }
        return plSqlFoldingBlock.getChildren();
    }

    private void addChildren(PlSqlFoldingBlock plSqlFoldingBlock, Object object) throws CancelledException {
        int n = this.m_map.getLineFromOffset(this.m_parser.getStartOffset(object));
        for (Object e : this.m_parser.getChildParseNodes(null, object)) {
            int n2 = this.m_parser.getStartOffset(e);
            int n3 = this.m_map.getLineFromOffset(n2);
            int n4 = this.m_parser.getEndOffset(e);
            int n5 = this.m_map.getLineFromOffset(n4);
            PlSqlToken plSqlToken = this.m_parser.getTokenAtOffset(n2);
            if (this.isAlwaysFold(plSqlToken) || n3 != n && n5 > n3 + 5) {
                PlSqlFoldingBlock plSqlFoldingBlock2 = new PlSqlFoldingBlock();
                this.populateFoldingBlock(plSqlFoldingBlock2, e, n2, n4);
                plSqlFoldingBlock.add((FoldingBlock)plSqlFoldingBlock2);
                if (!this.m_collapsedOffsets.contains(this.m_parser.getStartOffset(e))) continue;
                this.m_margin.setExpansionState((Object)plSqlFoldingBlock2, false);
                continue;
            }
            this.addChildren(plSqlFoldingBlock, e);
        }
    }

    private boolean isAlwaysFold(PlSqlToken plSqlToken) {
        return plSqlToken != null && (plSqlToken.matches("IF") || plSqlToken.matches("ELSIF") || plSqlToken.matches("ELSE") || plSqlToken.matches("WHILE") || plSqlToken.matches("FOR") || plSqlToken.matches("LOOP"));
    }

    private String getRequestProcessorKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

