/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.ceditor.DBEditorConnectionProvider;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.token.Token;

public class PlSqlQueryTester {
    private PlSqlQueryTester() {
    }

    public static boolean enableTestQuery(Context context) {
        try {
            return PlSqlQueryTester.getSelectTokens(context, false) != null;
        }
        catch (CancelledException cancelledException) {
            return false;
        }
    }

    public static void invokeTestQuery(final Context context) {
        Component component = context.getView().getGUI();
        final ProgressBar progressBar = new ProgressBar(component, UIBundle.get("TEST_QUERY_ACTION"), null, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PlSqlQueryTester.invokeTestQueryImpl(context);
                }
                catch (CancelledException cancelledException) {
                    DBLog.getLogger((Object)this).fine(cancelledException.getMessage());
                }
                finally {
                    progressBar.setDoneStatus();
                }
            }
        };
        progressBar.setRunnable(runnable);
        progressBar.setCancelable(true);
        progressBar.start(null, null, 1500);
    }

    private static void invokeTestQueryImpl(final Context context) throws CancelledException {
        PlSqlToken[] plSqlTokenArray;
        SourceObject sourceObject = ((BaseDBObjectTextNode)context.getNode()).getDBObjectFromBuffer();
        final Database database = DBEditorConnectionProvider.getCurrentDatabase(context);
        if (sourceObject != null && (plSqlTokenArray = PlSqlQueryTester.getSelectTokens(context, true)) != null && plSqlTokenArray.length == 4) {
            String string;
            StringBuilder stringBuilder;
            DBObjectPlSqlFragment dBObjectPlSqlFragment;
            PlSqlToken plSqlToken = plSqlTokenArray[0];
            PlSqlToken plSqlToken2 = plSqlTokenArray[1];
            PlSqlToken plSqlToken3 = plSqlTokenArray[2];
            PlSqlToken plSqlToken4 = plSqlTokenArray[3];
            StringBuilder stringBuilder2 = new StringBuilder(plSqlToken.getSource(false, (Token)plSqlToken2));
            boolean bl = false;
            for (PlSqlToken plSqlToken5 = plSqlToken2; plSqlToken5 != plSqlToken && !Thread.currentThread().isInterrupted(); plSqlToken5 = (PlSqlToken)plSqlToken5.getPrevCodeToken()) {
                CancelledException.checkInterrupt();
                if (plSqlToken5 == plSqlToken4) {
                    bl = true;
                    continue;
                }
                if (plSqlToken5 == plSqlToken3) {
                    bl = false;
                    stringBuilder2.replace(plSqlToken3.getStart() - plSqlToken.getStart(), plSqlToken4.getEnd() - plSqlToken.getStart() + 1, "");
                    continue;
                }
                if (bl || !((dBObjectPlSqlFragment = ((DBObjectPlSqlFragment)sourceObject).getReferenceAtOffset(plSqlToken5.getStart())) instanceof PlSqlReference)) continue;
                stringBuilder = ((PlSqlReference)dBObjectPlSqlFragment).getReferenceID();
                if (!Metadata.getInstance().isTypeOf(PlSqlDatum.class, stringBuilder.getType())) continue;
                DBObject dBObject = null;
                try {
                    dBObject = ((PlSqlReference)dBObjectPlSqlFragment).getReferenceID().resolveID();
                }
                catch (CancelledException cancelledException) {
                    throw cancelledException;
                }
                catch (DBException dBException) {
                    DBLog.getLogger(PlSqlQueryTester.class).warning(dBException.getMessage());
                }
                string = (PlSqlSourceObject)DBUtil.getSchemaObject((DBObject)dBObject);
                PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)string, (DBObjectProvider)database);
                if (plSqlParser == null) continue;
                PlSqlSearch plSqlSearch = new PlSqlSearch("? constant ?% := <def {^{;}}...>;");
                PlSqlToken plSqlToken6 = plSqlParser.getTokenAtOffset(((PlSqlDatum)dBObject).getStartOffset().intValue());
                if (plSqlSearch.matches(plSqlToken6)) {
                    stringBuilder2.replace(plSqlToken5.getStart() - plSqlToken.getStart(), plSqlToken5.getEnd() - plSqlToken.getStart() + 1, plSqlSearch.getNamedMatch("def"));
                    continue;
                }
                if (((PlSqlToken)plSqlToken5.getPrevCodeToken()).matches(".")) {
                    stringBuilder2.replace(plSqlToken5.getStart() - plSqlToken.getStart() - 1, plSqlToken5.getStart() - plSqlToken.getStart(), "_");
                    continue;
                }
                stringBuilder2.insert(plSqlToken5.getStart() - plSqlToken.getStart(), ":");
            }
            if (!Thread.currentThread().isInterrupted()) {
                dBObjectPlSqlFragment = stringBuilder2.toString().split("\n");
                stringBuilder = new StringBuilder();
                for (int i = 0; i < ((String[])dBObjectPlSqlFragment).length; ++i) {
                    if (dBObjectPlSqlFragment[i] == null || (string = dBObjectPlSqlFragment[i].trim()) == null || string.length() <= 0) continue;
                    stringBuilder.append(string);
                    stringBuilder.append("\n");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLQueryTester sQLQueryTester = new SQLQueryTester(database);
                        sQLQueryTester.showDialog(((CodeEditor)context.getView()).getDefaultFocusComponent(), stringBuilder.toString());
                    }
                });
            }
        }
    }

    private static PlSqlToken[] getSelectTokens(Context context, boolean bl) throws CancelledException {
        PlSqlToken[] plSqlTokenArray = null;
        PlSqlSearch plSqlSearch = new PlSqlSearch("{SELECT|WITH} {^;}...");
        PlSqlSearch plSqlSearch2 = new PlSqlSearch("{SELECT|WITH} {^INTO|BULK COLLECT INTO|;}... <into [[BULK COLLECT]INTO {^FROM}...]> {^;}...");
        if (context.getView() instanceof CodeEditor && context.getNode() instanceof DBObjectPlSqlNode) {
            CodeEditor codeEditor = (CodeEditor)context.getView();
            BaseDBObjectTextNode baseDBObjectTextNode = (BaseDBObjectTextNode)context.getNode();
            PlSqlSourceObject plSqlSourceObject = baseDBObjectTextNode != null ? (PlSqlSourceObject)baseDBObjectTextNode.getDBObject() : null;
            if (plSqlSourceObject != null) {
                PlSqlToken plSqlToken = null;
                PlSqlToken plSqlToken2 = null;
                PlSqlToken plSqlToken3 = null;
                PlSqlToken plSqlToken4 = null;
                PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)baseDBObjectTextNode.getProvider());
                if (plSqlParser != null) {
                    int n = codeEditor.getSelectionStart();
                    if (codeEditor.getSelectedText() != null) {
                        plSqlToken = plSqlParser.getTokenAtOffset(codeEditor.getSelectionStart());
                        if (plSqlToken != null) {
                            if (!plSqlToken.isCode()) {
                                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                            }
                            if ((plSqlToken2 = plSqlParser.getTokenAtOffset(codeEditor.getSelectionEnd() - 1)) != null) {
                                if (!plSqlToken2.isCode()) {
                                    plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
                                }
                                if (plSqlToken2.matches(";")) {
                                    plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
                                }
                                if (plSqlSearch2.matches(plSqlToken)) {
                                    plSqlToken3 = plSqlSearch2.getNamedMatchStartToken("into");
                                    plSqlToken4 = plSqlSearch2.getNamedMatchEndToken("into");
                                } else if (!plSqlSearch.matches(plSqlToken)) {
                                    plSqlToken = null;
                                    plSqlToken2 = null;
                                }
                            }
                        }
                    } else if (!bl) {
                        PlSqlToken plSqlToken5 = plSqlParser.getTokenAtOffset(codeEditor.getSelectionStart());
                        if (plSqlToken5 != null) {
                            plSqlToken2 = plSqlToken5;
                            while (plSqlToken5.isCode()) {
                                if (plSqlToken5.matches("select")) {
                                    plSqlToken = plSqlToken5;
                                    break;
                                }
                                if (plSqlToken5.matches(";")) {
                                    plSqlToken2 = null;
                                    break;
                                }
                                plSqlToken5 = (PlSqlToken)plSqlToken5.getPrevCodeToken();
                            }
                        }
                    } else {
                        DBObjectPlSqlFragment dBObjectPlSqlFragment;
                        for (dBObjectPlSqlFragment = plSqlSourceObject.getDeclarationAtOffset(n); dBObjectPlSqlFragment != null && !(dBObjectPlSqlFragment instanceof PlSqlStatement); dBObjectPlSqlFragment = (DBObjectPlSqlFragment)dBObjectPlSqlFragment.getParent()) {
                        }
                        if (dBObjectPlSqlFragment instanceof PlSqlStatement) {
                            PlSqlToken plSqlToken6 = plSqlParser.getTokenAtOffset(dBObjectPlSqlFragment.getStartOffset().intValue());
                            DBObjectPlSqlFragment dBObjectPlSqlFragment2 = (DBObjectPlSqlFragment)dBObjectPlSqlFragment.getParent();
                            if (dBObjectPlSqlFragment2 != null) {
                                PlSqlSearch plSqlSearch3;
                                PlSqlToken plSqlToken7 = plSqlParser.getTokenAtOffset(dBObjectPlSqlFragment2.getStartOffset().intValue());
                                if (((PlSqlStatement)dBObjectPlSqlFragment).getStatementType() == PlSqlStatement.Type.STATEMENT && plSqlSearch2.matches(plSqlToken6)) {
                                    plSqlToken = plSqlSearch2.getStartToken();
                                    plSqlToken2 = plSqlSearch2.getEndToken();
                                    plSqlToken3 = plSqlSearch2.getNamedMatchStartToken("into");
                                    plSqlToken4 = plSqlSearch2.getNamedMatchEndToken("into");
                                } else if (((PlSqlStatement)dBObjectPlSqlFragment).getStatementType() == PlSqlStatement.Type.CURSOR) {
                                    PlSqlSearch plSqlSearch4 = new PlSqlSearch("CURSOR {^IS}... IS <select {SELECT|WITH} {^;}...>");
                                    if (plSqlSearch4.matches(plSqlToken7)) {
                                        plSqlToken = plSqlSearch4.getNamedMatchStartToken("select");
                                        plSqlToken2 = plSqlSearch4.getNamedMatchEndToken("select");
                                    }
                                } else if (((PlSqlStatement)dBObjectPlSqlFragment).getStatementType() == PlSqlStatement.Type.FOR_LOOP && (plSqlSearch3 = new PlSqlSearch("FOR ? IN <select (...)> LOOP")).matches(plSqlToken6)) {
                                    plSqlToken = (PlSqlToken)plSqlSearch3.getNamedMatchStartToken("select").getNextCodeToken();
                                    plSqlToken2 = (PlSqlToken)plSqlSearch3.getNamedMatchEndToken("select").getPrevCodeToken();
                                }
                            }
                        }
                    }
                }
                if (plSqlToken != null && plSqlToken2 != null) {
                    plSqlTokenArray = new PlSqlToken[]{plSqlToken, plSqlToken2, plSqlToken3, plSqlToken4};
                }
            }
        }
        return plSqlTokenArray;
    }
}

