/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.cmd.buffer.EditProcessor;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.checktree.CheckboxTree;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public final class PlSqlSpecAndBodySynchronizer {
    private PlSqlSpecAndBodySynchronizer() {
    }

    public static void launch(BaseDBObjectTextNode baseDBObjectTextNode, Integer n) {
        PlSqlSpecAndBodySynchronizer.process(baseDBObjectTextNode, n, null);
    }

    public static void add(BaseDBObjectTextNode baseDBObjectTextNode, PlSqlSubProgram plSqlSubProgram) {
        PlSqlSpecAndBodySynchronizer.process(baseDBObjectTextNode, null, plSqlSubProgram);
    }

    private static void process(final BaseDBObjectTextNode baseDBObjectTextNode, final Integer n, final PlSqlSubProgram plSqlSubProgram) {
        final Holder holder = new Holder();
        if (SwingUtilities.isEventDispatchThread()) {
            final ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), StringUtils.stripMnemonic((String)UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_ACTION")), null, true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        holder.set((Object)PlSqlSpecAndBodySynchronizer.getSyncContext(baseDBObjectTextNode, n, plSqlSubProgram));
                    }
                    finally {
                        progressBar.setDoneStatus();
                    }
                }
            };
            progressBar.setRunnable(runnable);
            progressBar.setCancelable(true);
            progressBar.start(null, null, 1500);
            if (!progressBar.hasUserCancelled()) {
                PlSqlSpecAndBodySynchronizer.updateUI((SyncContext)holder.get());
            }
        } else {
            holder.set((Object)PlSqlSpecAndBodySynchronizer.getSyncContext(baseDBObjectTextNode, n, plSqlSubProgram));
            if (!Thread.currentThread().isInterrupted()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlSqlSpecAndBodySynchronizer.updateUI((SyncContext)holder.get());
                    }
                });
            }
        }
    }

    private static SyncContext getSyncContext(BaseDBObjectTextNode baseDBObjectTextNode, Integer n, PlSqlSubProgram plSqlSubProgram) {
        SyncContext syncContext;
        block24: {
            syncContext = new SyncContext();
            try {
                Object object;
                PlSqlSchemaObject plSqlSchemaObject;
                DBObjectProvider dBObjectProvider = baseDBObjectTextNode.getProvider();
                PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)baseDBObjectTextNode.getDBObjectFromBuffer();
                syncContext.m_pro = dBObjectProvider;
                boolean bl = true;
                if (!(plSqlSourceObject instanceof PlSqlSchemaObject)) break block24;
                BaseDBObjectTextNode baseDBObjectTextNode2 = DBObjectNodeUtil.getCompanionNode(baseDBObjectTextNode);
                if (baseDBObjectTextNode2 != null) {
                    if (baseDBObjectTextNode2.isOpen()) {
                        plSqlSchemaObject = (PlSqlSourceObject)baseDBObjectTextNode2.getDBObjectFromBuffer();
                    } else {
                        plSqlSchemaObject = (PlSqlSourceObject)baseDBObjectTextNode2.getDBObject();
                        if (plSqlSchemaObject == null) {
                            baseDBObjectTextNode2 = null;
                            bl = false;
                        }
                    }
                } else {
                    plSqlSchemaObject = PlSqlUtil.getCompanionObject((PlSqlSchemaObject)((PlSqlSchemaObject)plSqlSourceObject), (DBObjectProvider)dBObjectProvider);
                    if (plSqlSourceObject instanceof PlSqlSchemaObjectSpec) {
                        bl = false;
                    } else {
                        DBLog.getLogger(PlSqlSpecAndBodySynchronizer.class).warning("Body with no spec found.  Not suppoted.");
                        return null;
                    }
                }
                if (plSqlSourceObject instanceof PlSqlSchemaObjectSpec) {
                    syncContext.m_spec = (PlSqlSchemaObjectSpec)plSqlSourceObject;
                    syncContext.m_specNode = baseDBObjectTextNode;
                    syncContext.m_body = (PlSqlSchemaObjectBody)plSqlSchemaObject;
                    syncContext.m_bodyNode = baseDBObjectTextNode2;
                    syncContext.m_specOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(n, baseDBObjectTextNode, (PlSqlSchemaObject)syncContext.m_spec);
                    syncContext.m_bodyOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(null, baseDBObjectTextNode2, (PlSqlSchemaObject)syncContext.m_body);
                } else {
                    syncContext.m_spec = (PlSqlSchemaObjectSpec)plSqlSchemaObject;
                    syncContext.m_specNode = baseDBObjectTextNode2;
                    syncContext.m_body = (PlSqlSchemaObjectBody)plSqlSourceObject;
                    syncContext.m_bodyNode = baseDBObjectTextNode;
                    syncContext.m_specOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(null, baseDBObjectTextNode2, (PlSqlSchemaObject)syncContext.m_spec);
                    syncContext.m_bodyOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(n, baseDBObjectTextNode, (PlSqlSchemaObject)syncContext.m_body);
                }
                CancelledException.checkInterrupt();
                if (syncContext.m_body != null) {
                    object = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)syncContext.m_body, (DBObjectProvider)dBObjectProvider);
                    if (object == null) {
                        syncContext.m_cancelled = true;
                        return syncContext;
                    }
                    if (object.isWrapped()) {
                        syncContext.m_errorMessage = UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_BODY_WRAPPED");
                        return syncContext;
                    }
                } else if (syncContext.m_body == null && !syncContext.m_spec.canHaveBody()) {
                    if (syncContext.m_spec instanceof Type && "COLLECTION".equals(((Type)syncContext.m_spec).getTypeCode())) {
                        syncContext.m_errorMessage = UIBundle.get("FIND_OR_CREATE_BODY_COLLECTION_ERROR");
                    } else {
                        syncContext.m_errorMessage = UIBundle.format("FIND_OR_CREATE_BODY_OTHER_ERROR", syncContext.m_spec.getType(), syncContext.m_spec.getName());
                    }
                    return syncContext;
                }
                if (plSqlSubProgram != null && baseDBObjectTextNode2 != null) {
                    object = PlSqlSpecAndBodySynchronizer.getBuilder(Collections.singletonList(plSqlSubProgram), (PlSqlSchemaObject)plSqlSourceObject, dBObjectProvider);
                    if (plSqlSchemaObject instanceof PlSqlSchemaObjectBody) {
                        syncContext.m_bodyOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(n, baseDBObjectTextNode2, plSqlSchemaObject);
                        syncContext.m_bodyText = ((StringBuilder)object).toString();
                    } else {
                        syncContext.m_specOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(n, baseDBObjectTextNode2, plSqlSchemaObject);
                        syncContext.m_specText = ((StringBuilder)object).toString();
                    }
                    break block24;
                }
                if (!bl) {
                    object = syncContext.m_spec instanceof Package ? PackageBody.class : TypeBody.class;
                    String string = syncContext.m_spec.getName();
                    syncContext.m_body = (PlSqlSchemaObjectBody)dBObjectProvider.getObjectFactory().newObject((Class)object, (DBObject)syncContext.m_spec.getSchema(), string);
                    syncContext.m_body.setSpecID(syncContext.m_spec.getID());
                    syncContext.m_newBody = true;
                    String string2 = PlSqlUtil.getDefaultBodyForSpec((PlSqlSourceObject)syncContext.m_spec, (String)dBObjectProvider.getExternalName(string), (DBObjectProvider)dBObjectProvider);
                    syncContext.m_body.setSource(string2);
                    break block24;
                }
                syncContext.m_specList = PlSqlUtil.getTopLevelPlSqlFragments((DBObjectProvider)dBObjectProvider, (PlSqlSchemaObject)syncContext.m_spec, (PlSqlSchemaObject)syncContext.m_body);
                if (syncContext.m_body != null) {
                    syncContext.m_bodyList = PlSqlUtil.getTopLevelPlSqlFragments((DBObjectProvider)dBObjectProvider, (PlSqlSchemaObject)syncContext.m_body, (PlSqlSchemaObject)syncContext.m_spec);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlSqlSpecAndBodySynchronizer.showDialog(syncContext);
                    }
                });
                return null;
            }
            catch (CancelledException cancelledException) {
                syncContext.m_cancelled = true;
            }
            catch (DBException dBException) {
                syncContext.m_errorMessage = dBException.getMessage();
            }
        }
        return syncContext;
    }

    private static void updateUI(SyncContext syncContext) {
        if (syncContext != null && !syncContext.m_cancelled) {
            if (syncContext.m_errorMessage != null) {
                DBMessageDialog.showErrorDialog(syncContext.m_errorMessage, syncContext.m_spec, Level.INFO, UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), null);
            } else if (syncContext.m_newBody) {
                DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(syncContext.m_pro, syncContext.m_body.getType());
                if (dBEditorFactory != null) {
                    DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig(syncContext.m_pro, (DBObject)syncContext.m_body);
                    dBEditorFactory.launchDialog(dBEditorConfig);
                }
            } else {
                if (ModelUtil.hasLength((String)syncContext.m_specText)) {
                    PlSqlSpecAndBodySynchronizer.insertIntoBuffer(syncContext.m_specText, syncContext.m_specNode, syncContext.m_specOffset);
                }
                if (ModelUtil.hasLength((String)syncContext.m_bodyText)) {
                    PlSqlSpecAndBodySynchronizer.insertIntoBuffer(syncContext.m_bodyText, syncContext.m_bodyNode, syncContext.m_bodyOffset);
                }
            }
        }
    }

    private static void showDialog(final SyncContext syncContext) {
        final SyncPanel syncPanel = new SyncPanel(syncContext);
        syncPanel.setHelpID("f1_synchspecbody_html");
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), (Traversable)syncPanel, new Namespace());
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setContent((Component)((Object)syncPanel));
        jEWTDialog.setPreferredSize(400, 300);
        jEWTDialog.setResizable(true);
        jEWTDialog.setName("PlSqlSpecAndBodySynchronizer");
        if (tDialogLauncher.showDialog()) {
            final ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_ACTION"), null, true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        StringBuilder stringBuilder = PlSqlSpecAndBodySynchronizer.getBuilder(syncPanel.getAddToBodyFragments(), (PlSqlSchemaObject)syncContext.m_spec, syncContext.m_pro);
                        syncContext.m_bodyText = stringBuilder == null ? null : stringBuilder.toString();
                        StringBuilder stringBuilder2 = PlSqlSpecAndBodySynchronizer.getBuilder(syncPanel.getAddToSpecFragments(), (PlSqlSchemaObject)syncContext.m_body, syncContext.m_pro);
                        syncContext.m_specText = stringBuilder2 == null ? null : stringBuilder2.toString();
                    }
                    catch (CancelledException cancelledException) {
                        syncContext.m_cancelled = true;
                    }
                    progressBar.setDoneStatus();
                }
            };
            progressBar.setRunnable(runnable);
            progressBar.setCancelable(true);
            progressBar.start(null, null, 1500);
        } else {
            syncContext.m_cancelled = true;
        }
        PlSqlSpecAndBodySynchronizer.updateUI(syncContext);
    }

    private static StringBuilder getBuilder(List<PlSqlSubProgram> list, PlSqlSchemaObject plSqlSchemaObject, DBObjectProvider dBObjectProvider) throws CancelledException {
        PlSqlParser plSqlParser;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = plSqlSchemaObject instanceof PackageBody ? new PlSqlSearch("{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}") : (plSqlSchemaObject instanceof TypeBody ? new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]") : null);
        if (list.size() > 0 && (plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSchemaObject, (DBObjectProvider)dBObjectProvider)) != null) {
            for (PlSqlSubProgram plSqlSubProgram : list) {
                PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(plSqlSubProgram.getStartOffset().intValue());
                if (plSqlSchemaObject instanceof PlSqlSchemaObjectSpec) {
                    stringBuilder.append(PlSqlUtil.getDefaultImplementation((PlSqlSourceObject)plSqlSchemaObject, (PlSqlSubProgram)plSqlSubProgram, (DBObjectProvider)dBObjectProvider));
                    continue;
                }
                if (!object.matches(plSqlToken)) continue;
                stringBuilder.append("  ");
                stringBuilder.append(object.getStartToken().getSource(false, (Token)object.getEndToken()));
                stringBuilder.append(";\n\n");
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertIntoBuffer(String string, BaseDBObjectTextNode baseDBObjectTextNode, Integer n) {
        try {
            Context context = Context.newIdeContext((Node)baseDBObjectTextNode);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManager.openEditor(openEditorOptions);
            TextBuffer textBuffer = baseDBObjectTextNode.acquireTextBuffer();
            int n2 = textBuffer.getLineMap().getLineFromOffset(n.intValue());
            int n3 = textBuffer.getLineMap().getLineStartOffset(n2);
            EditProcessor.doInsert((char[])string.toCharArray(), (int)n3, (Node)baseDBObjectTextNode, (boolean)true, (String)UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), PlSqlSpecAndBodySynchronizer.class);
            OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(context, n3, 0);
            offsetNavigationPoint.setPreferredEditorType(null);
            NavigationManager navigationManager = NavigationManager.getNavigationManager();
            if (navigationManager != null) {
                navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint);
            } else {
                offsetNavigationPoint.navigate();
            }
        }
        catch (Exception exception) {
            DBLog.getLogger(PlSqlSpecAndBodySynchronizer.class).log(DBLog.getExceptionLogLevel(), exception.getMessage(), exception);
        }
        finally {
            baseDBObjectTextNode.releaseTextBuffer();
        }
    }

    private static Integer ensureOffset(Integer n, BaseDBObjectTextNode baseDBObjectTextNode, PlSqlSchemaObject plSqlSchemaObject) throws CancelledException {
        PlSqlParser plSqlParser;
        if (baseDBObjectTextNode != null && plSqlSchemaObject != null && (plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSchemaObject, (DBObjectProvider)baseDBObjectTextNode.getProvider())) != null) {
            PlSqlToken plSqlToken;
            PlSqlToken plSqlToken2;
            if (n != null && ((plSqlToken2 = plSqlSchemaObject.getChildAtOffset(n.intValue())) != plSqlSchemaObject || n < plSqlParser.getStartOffsetOfObject() || n > plSqlParser.getEndOffsetOfObject())) {
                n = null;
            }
            if (n == null && plSqlSchemaObject instanceof PackageBody && ((PlSqlToken)(plSqlToken2 = plSqlSchemaObject.getSubPrograms())).length > 0) {
                n = plSqlToken2[((PlSqlToken)plSqlToken2).length - 1].getEndOffset();
                plSqlToken = plSqlParser.getTokenAtOffset(n.intValue());
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                n = plSqlToken.getStart();
            }
            if (n == null) {
                plSqlToken2 = plSqlParser.getTokenAtOffset(plSqlParser.getEndOffsetOfObject());
                if (!plSqlToken2.isCode()) {
                    plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
                }
                plSqlToken = plSqlToken2;
                for (int i = 0; i < 3; ++i) {
                    if (plSqlToken.matches("end")) {
                        plSqlToken2 = plSqlToken;
                        break;
                    }
                    plSqlToken = (PlSqlToken)plSqlToken.getPrevCodeToken();
                }
                n = plSqlToken2.getStart();
            }
        }
        return n;
    }

    private static class SyncContext {
        private DBObjectProvider m_pro;
        private boolean m_cancelled;
        private boolean m_newBody;
        private String m_errorMessage;
        private PlSqlSchemaObjectSpec m_spec;
        private BaseDBObjectTextNode m_specNode;
        private Integer m_specOffset;
        private String m_specText;
        private List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> m_specList;
        private PlSqlSchemaObjectBody m_body;
        private BaseDBObjectTextNode m_bodyNode;
        private Integer m_bodyOffset;
        private String m_bodyText;
        private List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> m_bodyList;

        private SyncContext() {
        }
    }

    private static class SyncPanel
    extends DefaultTraversablePanel {
        private final LocalTreeNode m_rootNode = new LocalTreeNode("root");
        private LocalTreeNode m_addToBodyNode = null;
        private LocalTreeNode m_addToSpecNode = null;

        public SyncPanel(SyncContext syncContext) {
            LocalTreeNode localTreeNode;
            Object object;
            PlSqlSchemaObjectSpec plSqlSchemaObjectSpec = syncContext.m_spec;
            List list = syncContext.m_specList;
            PlSqlSchemaObjectBody plSqlSchemaObjectBody = syncContext.m_body;
            List list2 = syncContext.m_bodyList;
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)((Object)this.m_rootNode));
            for (Tuple tuple : list) {
                if (tuple.getSecond() != null) continue;
                object = this.getAddToBodyNode(plSqlSchemaObjectSpec);
                localTreeNode = new LocalTreeNode(tuple.getFirst());
                localTreeNode.setNodeState(TriStateNode.NodeState.YES);
                object.setNodeState(TriStateNode.NodeState.YES);
                object.add((MutableTreeNode)((Object)localTreeNode));
            }
            if (list2 != null) {
                for (Tuple tuple : list2) {
                    if (tuple.getSecond() != null) continue;
                    object = new LocalTreeNode(tuple.getFirst());
                    localTreeNode = this.getAddToSpecNode(plSqlSchemaObjectBody);
                    localTreeNode.add((MutableTreeNode)object);
                }
            }
            CheckboxTree checkboxTree = new CheckboxTree((TreeModel)defaultTreeModel);
            checkboxTree.setRootVisible(false);
            for (int i = 0; checkboxTree.getRowCount() > i; ++i) {
                checkboxTree.expandRow(i);
            }
            object = new DBUILayoutHelper((JPanel)((Object)this));
            ((DBUILayoutHelper)object).add(new JScrollPane((Component)checkboxTree));
            ((DBUILayoutHelper)object).layout();
        }

        public List<PlSqlSubProgram> getAddToSpecFragments() {
            ArrayList<PlSqlSubProgram> arrayList = new ArrayList<PlSqlSubProgram>();
            this.addSelectedFragments(arrayList, this.m_addToSpecNode);
            return arrayList;
        }

        public List<PlSqlSubProgram> getAddToBodyFragments() {
            ArrayList<PlSqlSubProgram> arrayList = new ArrayList<PlSqlSubProgram>();
            this.addSelectedFragments(arrayList, this.m_addToBodyNode);
            return arrayList;
        }

        private LocalTreeNode getAddToBodyNode(PlSqlSchemaObjectSpec plSqlSchemaObjectSpec) {
            if (this.m_addToBodyNode == null && plSqlSchemaObjectSpec != null) {
                this.m_addToBodyNode = new LocalTreeNode(plSqlSchemaObjectSpec);
                this.m_rootNode.add((MutableTreeNode)((Object)this.m_addToBodyNode));
            }
            return this.m_addToBodyNode;
        }

        private LocalTreeNode getAddToSpecNode(PlSqlSchemaObjectBody plSqlSchemaObjectBody) {
            if (this.m_addToSpecNode == null && plSqlSchemaObjectBody != null) {
                this.m_addToSpecNode = new LocalTreeNode(plSqlSchemaObjectBody);
                this.m_rootNode.add((MutableTreeNode)((Object)this.m_addToSpecNode));
            }
            return this.m_addToSpecNode;
        }

        private void addSelectedFragments(List<PlSqlSubProgram> list, LocalTreeNode localTreeNode) {
            if (localTreeNode != null && !localTreeNode.isLeaf()) {
                for (LocalTreeNode localTreeNode2 = (LocalTreeNode)((Object)localTreeNode.getFirstChild()); localTreeNode2 != null; localTreeNode2 = (LocalTreeNode)((Object)localTreeNode2.getNextSibling())) {
                    if (!TriStateNode.NodeState.YES.equals((Object)localTreeNode2.getNodeState())) continue;
                    list.add((PlSqlSubProgram)localTreeNode2.getUserObject());
                }
            }
        }

        private static class LocalTreeNode
        extends TriStateNode {
            public LocalTreeNode(Object object) {
                super(object);
            }

            public Icon getIcon() {
                PlSqlStatement.Type type;
                Icon icon = null;
                Object object = this.getUserObject();
                icon = object instanceof PlSqlSubProgram ? ((type = ((PlSqlSubProgram)object).getStatementType()) == PlSqlStatement.Type.FUNCTION || type == PlSqlStatement.Type.FUNCTION_FD ? DBTypeDisplayRegistry.getNodeIcon("FUNCTION") : (type == PlSqlStatement.Type.CURSOR ? OracleIcons.getIcon((String)"selection.png") : DBTypeDisplayRegistry.getNodeIcon("PROCEDURE"))) : (object instanceof DBObject ? DBTypeDisplayRegistry.getNodeIcon((DBObject)object) : OracleIcons.getIcon((String)"spacer.png"));
                return icon;
            }

            public String getLabel() {
                Object object = this.getUserObject();
                if (object instanceof PlSqlSchemaObject) {
                    String string = "PACKAGE BODY";
                    if (object instanceof PackageBody) {
                        string = "PACKAGE";
                    } else if (object instanceof Type) {
                        string = "TYPE BODY";
                    } else if (object instanceof Type) {
                        string = "TYPE BODY";
                    }
                    return UIBundle.format("SYNCHRONIZE_SPEC_AND_BODY_ADD_TO", DBTypeDisplayRegistry.getSingularDisplayName(string));
                }
                if (object instanceof PlSqlSubProgram) {
                    return ((PlSqlSubProgram)object).getSignature();
                }
                return super.getLabel();
            }
        }
    }
}

