/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;

public abstract class AsynchronousDocumentComponentWrapper<T extends JComponent>
extends AsynchronousComponentWrapper<T> {
    private final DocumentListener m_listener = new AsynchronousDocumentListener();
    private boolean m_listening;

    public AsynchronousDocumentComponentWrapper(T t) {
        super(t);
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        this.addDocumentListener(this.getDocument());
    }

    protected final void addDocumentListener(Document document) {
        if (document != null) {
            document.removeDocumentListener(this.m_listener);
            document.addDocumentListener(this.m_listener);
        }
    }

    protected abstract Document getDocument();

    @Override
    public final void setPropertyValue(Object object) {
        boolean bl = this.m_listening;
        this.m_listening = false;
        try {
            this.setPropertyValueImpl(object);
        }
        finally {
            this.m_listening = bl;
        }
    }

    protected abstract void setPropertyValueImpl(Object var1);

    protected boolean isListenOnFocusOnly() {
        return true;
    }

    @Override
    protected void gainingFocus() {
        if (this.isListenOnFocusOnly()) {
            this.m_listening = true;
        }
    }

    @Override
    protected void losingFocus() {
        if (this.isListenOnFocusOnly()) {
            this.m_listening = false;
        }
    }

    private void processUpdate(DocumentEvent documentEvent) {
        if (this.m_listening && this.isActive() && documentEvent.getLength() != 0) {
            this.documentChanged(documentEvent);
        }
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        this.markDirty();
    }

    @Override
    protected void setActiveImpl(boolean bl) {
        super.setActiveImpl(bl);
        if (bl) {
            if (!this.isListenOnFocusOnly()) {
                this.m_listening = true;
            }
        } else {
            this.m_listening = false;
        }
    }

    private class AsynchronousDocumentListener
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AsynchronousDocumentComponentWrapper.this.processUpdate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AsynchronousDocumentComponentWrapper.this.processUpdate(documentEvent);
        }
    }
}

