/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.validators.ValidationException;

public abstract class DelegateComponentWrapper
extends ComponentWrapper<JPanel> {
    private final Map<String, ComponentWrapper> m_wrappers = new HashMap<String, ComponentWrapper>();
    private final CardLayout m_layout = new CardLayout();
    private String m_currentKey;

    public DelegateComponentWrapper() {
        super(new JPanel());
        ((JPanel)this.getActiveComponent()).setLayout(this.m_layout);
    }

    protected final void registerDelegateWrapper(String string, ComponentWrapper componentWrapper) {
        ComponentContext componentContext = this.getComponentContext();
        if (componentContext == null) {
            throw new IllegalStateException("Cannot call registerDelegateWrapper before initialise.");
        }
        this.m_wrappers.put(string, componentWrapper);
        componentWrapper.initialise(componentContext);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(componentWrapper.getComponent(), "Center");
        ((JPanel)this.getActiveComponent()).add((Component)jPanel, string);
    }

    protected abstract void registerDelegateWrappers();

    protected abstract String getDelegateKey();

    protected final ComponentWrapper getDelegate(String string) {
        return this.m_wrappers.get(string);
    }

    protected final ComponentWrapper getDelegate() {
        String string = this.getDelegateKey();
        ComponentWrapper componentWrapper = this.getDelegate(string);
        if (!string.equals(this.m_currentKey)) {
            Object object;
            String string2 = this.m_currentKey;
            if (string2 != null) {
                object = this.getDelegate(string2);
                ((ComponentWrapper)object).setActive(false);
            }
            this.m_currentKey = string;
            object = (JPanel)this.getActiveComponent();
            this.m_layout.show((Container)object, string);
            componentWrapper.setActive(this.isActive());
            this.fireDelegateChanged(string2, string);
        }
        return componentWrapper;
    }

    protected void fireDelegateChanged(String string, String string2) {
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getDelegate().getDefaultFocusComponent();
    }

    @Override
    public void setValidationStatus(Collection<ValidationException> collection, DBValidationHandler dBValidationHandler) {
        this.getDelegate().setValidationStatus(collection, dBValidationHandler);
    }

    @Override
    public Object getPropertyValue() {
        return this.getDelegate().getPropertyValue();
    }

    @Override
    public void setPropertyValue(Object object) {
        ComponentWrapper componentWrapper = this.getDelegate();
        if (componentWrapper.isActive()) {
            componentWrapper.setPropertyValue(object);
        }
    }

    @Override
    protected void initialiseComponentListener() {
    }

    @Override
    protected final void initialiseComponent() {
        this.registerDelegateWrappers();
    }

    @Override
    public void processComponent(boolean bl, boolean bl2) {
        super.processComponent(bl, bl2);
        for (ComponentWrapper componentWrapper : this.m_wrappers.values()) {
            componentWrapper.processComponent(bl, bl2);
        }
        this.getDelegate();
    }

    @Override
    public boolean refreshObject(DBObject dBObject) {
        boolean bl = super.refreshObject(dBObject);
        for (ComponentWrapper componentWrapper : this.m_wrappers.values()) {
            if (!componentWrapper.refreshObject(dBObject)) continue;
            bl = true;
        }
        this.getDelegate();
        return bl;
    }

    @Override
    protected void setActiveImpl(boolean bl) {
        this.getDelegate().setActive(bl);
    }
}

