/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.TitledSeparator;

public abstract class ChildObjectDefineEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private final JCheckBox m_chkDefine = new JCheckBox();
    private TitledSeparator m_titledSeparator;
    private C m_lastChild;

    public ChildObjectDefineEditorPanel(String string, String string2) {
        super(string, string2, true);
        this.m_chkDefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChildObjectDefineEditorPanel.this.checkBoxChanged();
            }
        });
    }

    protected final JCheckBox getDefineCheckBox() {
        return this.m_chkDefine;
    }

    private void checkBoxChanged() {
        if (this.isEntered()) {
            boolean bl = this.m_chkDefine.isSelected();
            Object c = this.getChildObject();
            ChildDBObject childDBObject = bl ? (c == null ? (this.m_lastChild == null ? (ChildDBObject)this.getProvider().getObjectFactory().newObject(this.getChildClass()) : (ChildDBObject)this.m_lastChild) : (ChildDBObject)c) : null;
            if (childDBObject != c) {
                this.setChildOnParent(childDBObject);
                this.getComponentFactory().refreshComponents(this.getComponentFactoryUpdatedObject());
                if (childDBObject == null) {
                    this.m_lastChild = c;
                }
            }
            this.enabledChildComponents(bl);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_chkDefine.setEnabled(bl);
        if (this.isInitialized()) {
            this.enabledChildComponents(this.m_chkDefine.isSelected() && bl);
        }
    }

    protected void enabledChildComponents(boolean bl) {
        if (!bl || this.isEnabled()) {
            this.getComponentFactory().setEnabled(bl);
        }
    }

    private boolean isDefineSeparatorVisible() {
        String string = Property.createPath((String[])new String[]{this.getComponentFactory().getBasePath(), this.getPropertyPath()});
        return this.getProvider().getPropertyManager().canCreateProperty((SystemObject)this.getUpdatedObject(), string);
    }

    @Override
    protected final void initialiseChildComponents() {
        super.initialiseChildComponents();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.setMargins(0);
        DBUIResourceHelper dBUIResourceHelper = this.getComponentFactory().getResourceHelper();
        dBUIResourceHelper.resButton(this.m_chkDefine, this.getDefineCheckBoxText(), "Define");
        DBUILayoutHelper dBUILayoutHelper2 = dBUILayoutHelper.newTitledHelper(this.m_chkDefine, 1, 1, true, true);
        this.m_titledSeparator = dBUILayoutHelper2.getTitleSeparator();
        this.initialiseChildComponents(dBUILayoutHelper2);
        dBUILayoutHelper2.layout();
        dBUILayoutHelper.layout();
    }

    protected String getDefineCheckBoxText() {
        String string = PropertyDisplayRegistry.getDisplayName(this.getPropertyPath(), this.getProvider(), this.getComponentFactoryUpdatedObject());
        return UIBundle.format("STORAGE_INFO_PANEL_TITLE", string);
    }

    protected abstract void initialiseChildComponents(DBUILayoutHelper var1);

    protected abstract Class<? extends C> getChildClass();

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        boolean bl = this.getChildObject() != null;
        this.m_chkDefine.setSelected(bl);
        this.enabledChildComponents(bl);
        this.m_titledSeparator.setVisible(this.isDefineSeparatorVisible());
        this.m_lastChild = null;
        if (this.m_chkDefine.isEnabled() && this.getOriginalChildObject() != null) {
            this.m_chkDefine.setEnabled(this.canRemoveOnEdit());
        }
    }

    protected boolean canRemoveOnEdit() {
        return !(this.getProvider() instanceof Database);
    }
}

