/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseChildrenEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;

public abstract class ChildSelectableComponentEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseChildrenEditorPanel<C, P> {
    private SelectableComponent m_selectableComponent;
    private ListButtons m_listButtons;

    public ChildSelectableComponentEditorPanel(String string) {
        super(string);
    }

    protected abstract String getListLabel();

    protected abstract SelectableComponent createSelectableComponent();

    protected abstract void populateComponent();

    protected ListButtons createListButtons() {
        return null;
    }

    protected ListButtons.Controller createButtonsHelper() {
        return new DefaultButtonsHelper();
    }

    protected void listSelectionChanged() {
        Object c;
        ChildDBObject childDBObject = null;
        SelectableComponent selectableComponent = this.getSelectableComponent();
        int[] nArray = selectableComponent.getSelectedIndices();
        if (nArray != null && nArray.length == 1) {
            childDBObject = (ChildDBObject)selectableComponent.get(nArray[0]);
        }
        if ((c = this.getCurrentChild()) == childDBObject || this.exitChildPanel()) {
            this.enterChildPanel(childDBObject);
        } else {
            selectableComponent.setSelectedIndices(selectableComponent.indexOf(c));
        }
    }

    @Override
    protected void initialiseComponents() {
        this.layoutComponents(this.getChildProperty());
    }

    protected final JTextComponent getNameField() {
        return this.getChildPanel().getNameField();
    }

    protected final SelectableComponent getSelectableComponent() {
        if (this.m_selectableComponent == null) {
            this.m_selectableComponent = this.createSelectableComponent();
            if (this.m_selectableComponent != null && !this.isEnabled()) {
                ((Component)this.m_selectableComponent.getComponent()).setEnabled(false);
            }
        }
        return this.m_selectableComponent;
    }

    protected final ListButtons getListButtons() {
        if (this.m_listButtons == null) {
            this.m_listButtons = this.createListButtons();
            if (this.m_listButtons != null && !this.isEnabled()) {
                this.m_listButtons.setEnabled(false);
            }
        }
        return this.m_listButtons;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getSelectableComponent().getComponent();
    }

    @Override
    protected void initialisePanel() {
        Object c = this.getCurrentChild();
        this.getSelectableComponent().clear();
        this.setCurrentChild(null);
        this.populateComponent();
        Object c2 = this.getInitialChild(c);
        this.selectChild(c2);
        ListButtons listButtons = this.getListButtons();
        if (listButtons != null) {
            listButtons.enableButtons();
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (!this.exitChildPanel()) {
            throw new TraversalException(null);
        }
    }

    @Override
    protected void currentChildNameChanged() {
        ChildObjectEditorPanel childObjectEditorPanel;
        if (this.getCurrentChild() != null && (childObjectEditorPanel = this.getChildPanel()) != null) {
            ((Component)this.getSelectableComponent().getComponent()).repaint();
        }
    }

    @Override
    protected final void selectChild(C c) {
        Object c2 = this.getCurrentChild();
        if (c2 != c && (c2 == null || this.exitChildPanel())) {
            this.getSelectableComponent().setSelectedIndices(this.getSelectableComponent().indexOf(c));
            if (!this.isEntered()) {
                this.listSelectionChanged();
            }
        }
        if (c == null && !this.getChildPanel().isEntered()) {
            ListButtons listButtons = this.getListButtons();
            if (listButtons != null) {
                listButtons.setEnabled(this.isEnabled());
            }
            this.enterChildPanel(null);
        }
    }

    private void layoutComponents(String ... stringArray) {
        this.m_selectableComponent = this.createSelectableComponent();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        Component component = this.getChildPanel().getComponent();
        boolean bl = this.isHorizontalSplit();
        ListButtons listButtons = this.getListButtons();
        if (listButtons != null) {
            JComponent jComponent = listButtons.getComponent();
            this.getComponentFactory().getResourceHelper().setName(jComponent, "ChildListPanel");
            dBUILayoutHelper.add(jComponent, 1, 1, !bl, bl);
            if (bl) {
                component = dBUILayoutHelper.wrapForInvisibility(component);
            } else {
                dBUILayoutHelper.nextRow();
            }
        }
        this.getComponentFactory().registerComponent(listButtons == null ? null : listButtons.getLabel(), (Component)this.getSelectableComponent().getComponent(), this.getListLabel(), "ChildList", Property.createPath((String[])stringArray));
        dBUILayoutHelper.add(component, 1, 1, true, true);
        dBUILayoutHelper.layout();
        this.getSelectableComponent().addSelectionListener(new SelectableComponent.SelectionListener(){

            @Override
            public void valueChanged(SelectableComponent.SelectionEvent selectionEvent) {
                if (ChildSelectableComponentEditorPanel.this.isEntered()) {
                    ChildSelectableComponentEditorPanel.this.listSelectionChanged();
                }
            }
        });
    }

    @Override
    protected Dimension getDialogInitialSize() {
        return new Dimension(700, 450);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.m_selectableComponent != null) {
            ((Component)this.m_selectableComponent.getComponent()).setEnabled(bl);
        }
        if (this.m_listButtons != null) {
            this.m_listButtons.setEnabled(bl);
        }
    }

    protected class DefaultButtonsHelper
    extends ListButtons.Controller {
        protected DefaultButtonsHelper() {
        }

        @Override
        public void addToList() {
            SelectableComponent selectableComponent = this.getSelectableComponent();
            if (ChildSelectableComponentEditorPanel.this.exitChildPanel()) {
                Object c = ChildSelectableComponentEditorPanel.this.newChild();
                selectableComponent.add(c);
                ChildSelectableComponentEditorPanel.this.selectChild(c);
                ChildSelectableComponentEditorPanel.this.commitChildProperty();
                JTextComponent jTextComponent = ChildSelectableComponentEditorPanel.this.getChildPanel().getNameField();
                if (jTextComponent != null) {
                    jTextComponent.requestFocusInWindow();
                }
            } else {
                selectableComponent.setSelectedIndices(selectableComponent.indexOf(ChildSelectableComponentEditorPanel.this.getCurrentChild()));
            }
        }

        @Override
        public void removeFromList() {
            SelectableComponent selectableComponent = this.getSelectableComponent();
            int[] nArray = selectableComponent.getSelectedIndices();
            if (nArray != null && nArray.length > 0) {
                int n;
                int n2 = nArray.length;
                ChildSelectableComponentEditorPanel.this.setCurrentChild(null);
                Arrays.sort(nArray);
                for (n = n2 - 1; n > -1; --n) {
                    selectableComponent.remove(nArray[n]);
                }
                int n3 = nArray[n2 - 1];
                int n4 = n3 - n2 + 1;
                n = selectableComponent.size();
                if (n4 == n) {
                    --n4;
                }
                ChildSelectableComponentEditorPanel.this.commitChildProperty();
                ChildSelectableComponentEditorPanel.this.selectChild(n4 >= 0 ? (ChildDBObject)selectableComponent.get(n4) : null);
            }
        }

        @Override
        public boolean canAdd() {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        public boolean canAdd(Object object) {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public boolean canRemove() {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public boolean canRemove(Object object) {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public String getBaseName() {
            return ChildSelectableComponentEditorPanel.this.getComponentFactory().getResourceHelper().getPanelName();
        }

        @Override
        public String getListLabel() {
            return ChildSelectableComponentEditorPanel.this.getListLabel();
        }

        @Override
        public boolean useResizeComponent() {
            return ChildSelectableComponentEditorPanel.this.isInFlatEditor();
        }

        @Override
        public void objectMovedDown(Object object) {
            ChildSelectableComponentEditorPanel.this.commitChildProperty();
        }

        @Override
        public void objectMovedUp(Object object) {
            ChildSelectableComponentEditorPanel.this.commitChildProperty();
        }
    }
}

