/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellRenderer;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectTabbedEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.table.ConstraintEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ButtonMenu;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.ModelUtil;

public class ConstraintsPanel
extends ChildTableEditorPanel<Constraint, Relation> {
    private static final String CONSTRAINT_TYPE = "constraintType";
    private final Comparator<Constraint> m_comparator = new CC();
    private final Map<ConstraintType, JMenuItem> m_menuItems = new EnumMap<ConstraintType, JMenuItem>(ConstraintType.class);

    public ConstraintsPanel() {
        super("ConstraintsPanel");
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"constraints"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                ConstraintsPanel.this.modelChanged();
            }
        };
    }

    @Override
    protected Class getChildClass() {
        return Constraint.class;
    }

    @Override
    protected String getChildProperty() {
        return "constraints";
    }

    @Override
    protected void initialiseTableComponents() {
        ChildTableEditorPanel.NonPropertyColumnLogic<Constraint> nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<Constraint>(){

            @Override
            public Object getCellValue(Constraint constraint) {
                return ConstraintType.valueOf(constraint.getConstraintType());
            }
        };
        this.addColumn(0, DisplayNames.getPropertyDisplayName((String)CONSTRAINT_TYPE), ConstraintType.class, nonPropertyColumnLogic, (TableCellRenderer)((Object)new ConstraintTypeCellRenderer()));
    }

    private void modelChanged() {
        Relation relation = (Relation)this.getUpdatedObject();
        if (relation != null) {
            this.checkAddMenuItems();
            if (!this.isInFlatEditor()) {
                Table table = (Table)this.getEditorConfig().getUpdatedObject();
                ConstraintIndexHelper constraintIndexHelper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
                constraintIndexHelper.clearNewUnusedIndexes(table);
            }
        }
    }

    private void checkAddMenuItems() {
        for (Map.Entry<ConstraintType, JMenuItem> entry : this.m_menuItems.entrySet()) {
            entry.getValue().setEnabled(this.isConstraintTypeEnabled(entry.getKey()));
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.checkAddMenuItems();
    }

    @Override
    protected String[] getPropertiesForRow() {
        return new String[]{"name", "enabled", "deferrableState"};
    }

    @Override
    protected ChildObjectEditorPanel<Constraint, Relation> createChildPanel() {
        Object object;
        ArrayList<Navigable> arrayList = null;
        PanelLibrary panelLibrary = (PanelLibrary)this.getDataContext().find(PanelLibrary.class);
        if (panelLibrary != null && (object = panelLibrary.getDefaultPanels(this.isEditing())) != null && ((Navigable[])object).length > 0) {
            arrayList = new ArrayList<Navigable>();
            arrayList.add(new DBNavigable(UIBundle.get("PROPERTIES"), ConstraintEditorPanel.class));
            for (int i = 0; i < ((Navigable[])object).length; ++i) {
                arrayList.add(object[i]);
            }
        }
        object = arrayList != null ? new ChildObjectTabbedEditorPanel(this.getName(), arrayList) : new ConstraintEditorPanel();
        return object;
    }

    @Override
    protected boolean preserveListOrder() {
        return false;
    }

    @Override
    protected Comparator<Constraint> getChildComparator() {
        return this.m_comparator;
    }

    @Override
    protected AbstractButton createAddButton() {
        Collection collection = this.getProvider().getPropertyManager().getAllowedPropertyValues(null, (DBObject)new Table(), Property.createPath((String[])new String[]{"constraints", CONSTRAINT_TYPE}));
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (ConstraintType constraintType : ConstraintType.values()) {
            if (!collection.contains(constraintType.toString())) continue;
            arrayList.add(this.createMenuItem(constraintType));
        }
        JToggleButton jToggleButton = ButtonMenu.createButtonMenu(null, (Icon)OracleIcons.getIcon((String)"add.png"), arrayList);
        String string = UIBundle.get("CONSTRAINT_BUTTON_ADD");
        jToggleButton.setToolTipText(string);
        jToggleButton.getAccessibleContext().setAccessibleDescription(string);
        return jToggleButton;
    }

    private void createConstraint(ConstraintType constraintType) {
        Constraint constraint;
        Relation relation = (Relation)this.getUpdatedObject();
        if (relation != null && this.exitChildPanel() && (constraint = ConstraintsPanel.newConstraint(relation, constraintType, this.getChildNames(), null, this.getProvider())) != null) {
            this.addChildRow((ChildDBObject[])new Constraint[]{constraint});
            this.selectChild(constraint);
        }
    }

    private JMenuItem createMenuItem(final ConstraintType constraintType) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConstraintsPanel.this.createConstraint(constraintType);
            }

            @Override
            public boolean isEnabled() {
                return ConstraintsPanel.this.isConstraintTypeEnabled(constraintType);
            }
        };
        abstractAction.putValue("SmallIcon", constraintType.getIcon());
        abstractAction.putValue("Name", UIBundle.format("CONSTRAINT_NEW_LABEL", constraintType.getName()));
        JMenuItem jMenuItem = new JMenuItem(abstractAction);
        this.m_menuItems.put(constraintType, jMenuItem);
        return jMenuItem;
    }

    private boolean isConstraintTypeEnabled(ConstraintType constraintType) {
        boolean bl = true;
        Relation relation = (Relation)this.getUpdatedObject();
        if (relation == null) {
            bl = false;
        } else {
            Collection collection = this.getProvider().getPropertyManager().getAllowedPropertyValues(this.getOriginalObject(), this.getUpdatedObject(), Property.createPath((String[])new String[]{"constraints", CONSTRAINT_TYPE}));
            bl = collection.contains(constraintType.toString());
        }
        if (bl && constraintType == ConstraintType.PKConstraint) {
            bl = PKConstraint.getPrimaryKey((Relation)relation) == null;
        }
        return bl;
    }

    @Override
    protected boolean isHorizontalSplit() {
        return false;
    }

    public static FKConstraint newFKConstraint(Relation relation, DBObjectID dBObjectID, DBObjectProvider dBObjectProvider) {
        DBObject dBObject;
        String string = null;
        if (dBObjectID instanceof TemporaryObjectID) {
            dBObject = ((TemporaryObjectID)dBObjectID).getDBObject();
            DBObject dBObject2 = dBObject.getParent();
            if (dBObject2 != null) {
                string = dBObject2.getName();
            }
        } else if (dBObjectID != null) {
            dBObject = dBObjectID.getParent();
            string = DBUtil.getDBObjectName((DBObjectID)dBObject);
        }
        dBObject = (FKConstraint)ConstraintsPanel.newConstraint(relation, ConstraintType.FKConstraint, null, string, dBObjectProvider);
        dBObject.setReferenceID(dBObjectID);
        return dBObject;
    }

    public static Constraint newConstraint(Relation relation, String string, DBObjectProvider dBObjectProvider) {
        return ConstraintsPanel.newConstraint(relation, ConstraintType.valueOf(string), null, null, dBObjectProvider);
    }

    private static Constraint newConstraint(Relation relation, ConstraintType constraintType, Collection<String> collection, String string, DBObjectProvider dBObjectProvider) {
        if (collection == null) {
            collection = new ArrayList<String>();
            for (Object object : relation.getConstraints()) {
                collection.add(object.getName());
            }
        }
        Constraint constraint = (Constraint)dBObjectProvider.getObjectFactory().newObject(constraintType.getConstraintClass(), (DBObject)relation);
        int n = dBObjectProvider.getDescriptor().getMaxNameLength("CONSTRAINT");
        int n2 = constraintType.getPostfix().length();
        if (constraint.getName() == null) {
            Object object;
            object = new StringBuilder();
            ((StringBuilder)object).append(relation.getName());
            if (ModelUtil.hasLength((String)string) && ((StringBuilder)object).length() + string.length() + n2 + 1 < n) {
                ((StringBuilder)object).append("_");
                ((StringBuilder)object).append(string);
            }
            if (((StringBuilder)object).length() + n2 >= n) {
                ((StringBuilder)object).delete(n - n2 - 1, ((StringBuilder)object).length());
            }
            ((StringBuilder)object).append(constraintType.getPostfix());
            String string2 = DBUtil.getUniqueName(collection, (String)((StringBuilder)object).toString(), (boolean)true);
            constraint.setName(string2);
        }
        TemporaryObjectID.setID((DBObject)constraint, (boolean)true);
        return constraint;
    }

    static enum ConstraintType {
        PKConstraint,
        UniqueConstraint,
        FKConstraint,
        CheckConstraint;


        public Class<? extends Constraint> getConstraintClass() {
            switch (this) {
                case UniqueConstraint: {
                    return UniqueConstraint.class;
                }
                case FKConstraint: {
                    return FKConstraint.class;
                }
                case CheckConstraint: {
                    return CheckConstraint.class;
                }
            }
            return PKConstraint.class;
        }

        public Icon getIcon() {
            switch (this) {
                case FKConstraint: {
                    return OracleIcons.getIcon((String)"foreignkey.png");
                }
                case CheckConstraint: {
                    return OracleIcons.getIcon((String)"constraint.png");
                }
                case PKConstraint: {
                    return OracleIcons.getIcon((String)"primarykey.png");
                }
            }
            return OracleIcons.getIcon((String)"key.png");
        }

        public String getName() {
            return PropertyDisplayRegistry.getPropValueDisplay(ConstraintsPanel.CONSTRAINT_TYPE, this.toString());
        }

        public String getPostfix() {
            switch (this) {
                case UniqueConstraint: {
                    return "_UK1";
                }
                case FKConstraint: {
                    return "_FK1";
                }
                case CheckConstraint: {
                    return "_CHK1";
                }
            }
            return "_PK";
        }
    }

    private static class CC
    implements Comparator<Constraint> {
        private CC() {
        }

        @Override
        public int compare(Constraint constraint, Constraint constraint2) {
            int n;
            if (constraint == constraint2) {
                n = 0;
            } else if (constraint == null) {
                n = 100;
            } else if (constraint2 == null) {
                n = -100;
            } else {
                String string = constraint.getConstraintType();
                String string2 = constraint2.getConstraintType();
                int n2 = ConstraintType.valueOf(string).compareTo(ConstraintType.valueOf(string2));
                n = n2 == 0 ? DBUtil.getNameComparator().compare(constraint, constraint2) : n2 * 10;
            }
            return n;
        }
    }

    static class ConstraintTypeCellRenderer
    extends GenericTableCellRenderer {
        ConstraintTypeCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel && object instanceof ConstraintType) {
                ((JLabel)component).setText(((ConstraintType)((Object)object)).getName());
                ((JLabel)component).setIcon(((ConstraintType)((Object)object)).getIcon());
            }
            return component;
        }
    }
}

